/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.Objects;
import java.util.zip.Checksum;
import org.netbeans.modules.autoupdate.services.MessageValidator;

public class MessageChecksumValidator
implements MessageValidator {
    private final Checksum checksum;
    private final long expectedValue;
    private Long digestValue;

    public MessageChecksumValidator(Checksum checksum, long l) {
        Objects.requireNonNull(checksum, "messageDigenst must not be NULL");
        Objects.requireNonNull(Long.valueOf(l), "expectedValue must not be NULL");
        this.checksum = checksum;
        this.expectedValue = l;
    }

    @Override
    public void update(byte by) {
        if (this.digestValue != null) {
            throw new IllegalStateException("isValid was already called");
        }
        this.checksum.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        if (this.digestValue != null) {
            throw new IllegalStateException("isValid was already called");
        }
        this.checksum.update(byArray, n, n2);
    }

    @Override
    public void update(byte[] byArray) {
        if (this.digestValue != null) {
            throw new IllegalStateException("isValid was already called");
        }
        this.update(byArray, 0, byArray.length);
    }

    @Override
    public boolean isValid() {
        return this.getDigestValue() == this.expectedValue;
    }

    private long getDigestValue() {
        if (this.digestValue == null) {
            this.digestValue = this.checksum.getValue();
        }
        return this.digestValue;
    }

    @Override
    public String getName() {
        return "Checksum " + this.checksum.getClass().getSimpleName();
    }

    @Override
    public String getExpectedValueAsString() {
        return Long.toString(this.expectedValue);
    }

    @Override
    public String getRealValueAsString() {
        return Long.toString(this.checksum.getValue());
    }

    @Override
    public void reset() {
        this.checksum.reset();
        this.digestValue = null;
    }
}

