/*
 * Decompiled with CFR 0.152.
 */
package tr.model.action;

import java.util.Date;
import java.util.List;
import tr.model.action.Interval;
import tr.model.action.Period;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Intervals {
    public final Period period;
    public final int frequency;
    public final Date startDate;
    private transient Interval firstInterval;

    public Intervals(Period period, int frequency, Date startDate) {
        assert (period != null);
        assert (frequency > 0);
        assert (startDate != null);
        this.period = period;
        this.frequency = frequency;
        this.startDate = startDate;
    }

    public Interval getFirstInterval() {
        if (this.firstInterval == null) {
            Interval firstPeriod = this.period.getPeriod(this.startDate);
            Interval lastPeriod = this.period.addPeriods(firstPeriod, this.frequency - 1);
            this.firstInterval = new Interval(firstPeriod.start, lastPeriod.end);
        }
        return this.firstInterval;
    }

    public Interval getNextInterval(Interval interval) {
        assert (interval != null);
        Interval firstPeriod = this.period.getNextPeriod(this.period.getPeriod(interval.end));
        Interval lastPeriod = this.period.addPeriods(firstPeriod, this.frequency - 1);
        return new Interval(firstPeriod.start, lastPeriod.end);
    }

    public Interval getPreviousInterval(Interval interval) {
        assert (interval != null);
        Interval lastPeriod = this.period.getPreviousPeriod(this.period.getPeriod(interval.start));
        Interval firstPeriod = this.period.addPeriods(lastPeriod, -(this.frequency - 1));
        return new Interval(firstPeriod.start, lastPeriod.end);
    }

    public Interval getInterval(Date date) {
        assert (date != null);
        Interval interval = this.getFirstInterval();
        while (date.before(interval.start)) {
            interval = this.getPreviousInterval(interval);
        }
        while (date.after(interval.end)) {
            interval = this.getNextInterval(interval);
        }
        return interval;
    }

    public List<Date> getSelectedDates(Interval interval, Date templateDate) {
        return this.period.getSelectedDates(interval.start, templateDate);
    }
}

