-- Copyright © 2008-2019 Pioneer Developers. See AUTHORS.txt for details
-- Licensed under the terms of the GPL v3. See licenses/GPL-3.txt

local s = CustomSystem:new('Regula Benedicti', { 'BROWN_DWARF' })
	:govtype('EARTHDEMOC')
	:lawlessness(f(1,100)) -- 1/100th from a peaceful eden
	:short_desc('Among the first habitable exoplanets were discovered here')
	:long_desc([[Regula Benedicti was among the first star systems where habitable exoplanets were discovered, also known as TRAPPIST-1 after the telescope which discovered it.]])

local trappist_1 = CustomSystemBody:new('Regula Benedicti', 'BROWN_DWARF')
	:radius(f(114,1000))
	:mass(f(8,100))
	:temp(2550)

local trappist_1b = CustomSystemBody:new('Achel', 'PLANET_TERRESTRIAL')
	:seed(1998)
	:radius(f(1086,1000))
	:mass(f(85,100))
	:temp(340)
	:semi_major_axis(f(1111,100000))
	:eccentricity(f(81,1000))
	:inclination(math.deg2rad(0.65))
	:rotation_period(f(15,10))
	:axial_tilt(fixed.deg2rad(f(1,100)))
	:metallicity(f(97,100))
	:volcanicity(f(1,2))
	:atmos_density(f(0,1))
	:atmos_oxidizing(f(0,1))
	:ocean_cover(f(0,1))
	:ice_cover(f(2,100))
	:life(f(0,1))
	:orbital_phase_at_start(fixed.deg2rad(f(21,1)))

local trappist_1c = CustomSystemBody:new('Chimay', 'PLANET_TERRESTRIAL')
	:seed(1863)
	:radius(f(1056,1000))
	:mass(f(138,100))
	:temp(335)
	:semi_major_axis(f(1522,100000))
	:eccentricity(f(83,1000))
	:inclination(math.deg2rad(0.67))
	:rotation_period(f(24,10))
	:axial_tilt(fixed.deg2rad(f(26,10)))
	:metallicity(f(7,10))
	:volcanicity(f(5,10))
	:atmos_density(f(32,100))
	:atmos_oxidizing(f(12,100))
	:ocean_cover(f(36,100))
	:ice_cover(f(2,10))
	:life(f(0,1))
	:orbital_phase_at_start(fixed.deg2rad(f(21,1)))

local trappist_1d = CustomSystemBody:new('Orval', 'PLANET_TERRESTRIAL')
	:seed(1931)
	:radius(f(772,1000))
	:mass(f(41,100))
	:temp(288)
	:semi_major_axis(f(216,10000))
	:eccentricity(f(7,100))
	:inclination(math.deg2rad(0.75))
	:rotation_period(f(41,10))
	:axial_tilt(fixed.deg2rad(f(2344,100)))
	:rotational_phase_at_start(fixed.deg2rad(f(170,1)))
	:metallicity(f(67,100))
	:volcanicity(f(452,1000))
	:atmos_density(f(525,1000))
	:atmos_oxidizing(f(32,100))
	:ocean_cover(f(37,100))
	:ice_cover(f(35,100))
	:life(f(0,1))
	--:orbital_phase_at_start(fixed.deg2rad(f(36,1)))

local trappist_1e = CustomSystemBody:new('Rochefort', 'PLANET_TERRESTRIAL')
	:seed(1595)
	:radius(f(918,1000))
	:mass(f(62,100))
	:temp(278)
	:semi_major_axis(f(28,1000))
	:eccentricity(f(85,1000))
	:inclination(math.deg2rad(0.86))
	:rotation_period(f(6,1))
	:axial_tilt(fixed.deg2rad(f(2519,100)))
	-- XXX composition copied from earth until there's a way to indicate terraformed
	:metallicity(f(14.5,5))
	:volcanicity(f(2,10))
	:atmos_density(f(489,1000))
	:atmos_oxidizing(f(950001,1000000))
	:ocean_cover(f(10,100))
	:ice_cover(f(440,1000))
	:life(f(10,100))
	--:orbital_phase_at_start(fixed.deg2rad(f(12,1)))


local trappist_1f = CustomSystemBody:new('Westmalle', 'PLANET_TERRESTRIAL')
	:seed(1836)
	:radius(f(1045,1000))
	:mass(f(68,100))
	:temp(288)
	:semi_major_axis(f(37,1000))
	:eccentricity(f(63,1000))
	:inclination(math.deg2rad(0.68))
	:rotation_period(f(92,10))
	:axial_tilt(fixed.deg2rad(f(2344,100)))
	:rotational_phase_at_start(fixed.deg2rad(f(170,1)))
	:metallicity(f(1,2))
	:volcanicity(f(1,10))
	:atmos_density(f(1,1))
	:atmos_oxidizing(f(99,100))
	:ocean_cover(f(7,10))
	:ice_cover(f(5,10))
	:life(f(9,10))
	--:orbital_phase_at_start(fixed.deg2rad(f(6,1)))

	local trappist_1g = CustomSystemBody:new('Westvleteren', 'PLANET_TERRESTRIAL')
	:seed(1838)
	:radius(f(1127,1000))
	:mass(f(134,100))
	:temp(288)
	:semi_major_axis(f(45,1000))
	:eccentricity(f(61,1000))
	:inclination(math.deg2rad(0.71))
	:rotation_period(f(123,10))
	:axial_tilt(fixed.deg2rad(f(2344,100)))
	:rotational_phase_at_start(fixed.deg2rad(f(170,1)))
	:metallicity(f(1,2))
	:volcanicity(f(1,10))
	:atmos_density(f(1,1))
	:atmos_oxidizing(f(99,100))
	:ocean_cover(f(7,10))
	:ice_cover(f(5,10))
	:life(f(9,10))
	--:orbital_phase_at_start(fixed.deg2rad(f(9,1)))

local trappist_1h = CustomSystemBody:new('Koningshoeven', 'PLANET_TERRESTRIAL')
	:seed(1884)
	:radius(f(755,100))
	:mass(f(63,100))
	:temp(288)
	:semi_major_axis(f(63,1000))
	:eccentricity(f(57,1000))
	:inclination(math.deg2rad(0.80))
	:rotation_period(f(204,10))
	:axial_tilt(fixed.deg2rad(f(2344,100)))
	:rotational_phase_at_start(fixed.deg2rad(f(170,1)))
	:metallicity(f(1,2))
	:volcanicity(f(1,10))
	:atmos_density(f(1,1))
	:atmos_oxidizing(f(99,100))
	:ocean_cover(f(7,10))
	:ice_cover(f(5,10))
	:life(f(9,10))
	--:orbital_phase_at_start(fixed.deg2rad(f(336,1)))


s:bodies(trappist_1, {
	trappist_1b,
	trappist_1c,
	trappist_1d,
	trappist_1e,
	trappist_1f,
	trappist_1g,
	trappist_1h,
	
})

s:add_to_sector(-4,1,-3,v(0.133,0.430,0.284))
--s:add_to_sector(0,0,0,v(0.999,0.999,0.999))
