/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;

@Incubating
public interface AggregateEmbeddableResultGraphNode
extends EmbeddableResultGraphNode {
    public int[] getAggregateValuesArrayPositions();

    public static int[] determineAggregateValuesArrayPositions(@Nullable FetchParent parent, SqlSelection structSelection) {
        if (parent instanceof AggregateEmbeddableResultGraphNode) {
            int[] parentAggregateValuesArrayPositions = ((AggregateEmbeddableResultGraphNode)parent).getAggregateValuesArrayPositions();
            int[] aggregateValuesArrayPositions = new int[parentAggregateValuesArrayPositions.length + 1];
            System.arraycopy(parentAggregateValuesArrayPositions, 0, aggregateValuesArrayPositions, 0, parentAggregateValuesArrayPositions.length);
            aggregateValuesArrayPositions[aggregateValuesArrayPositions.length - 1] = structSelection.getValuesArrayPosition();
            return aggregateValuesArrayPositions;
        }
        if (parent instanceof Fetch && parent instanceof EmbeddableResultGraphNode) {
            return AggregateEmbeddableResultGraphNode.determineAggregateValuesArrayPositions(((Fetch)((Object)parent)).getFetchParent(), structSelection);
        }
        return new int[]{structSelection.getValuesArrayPosition()};
    }
}

