/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.IllegalDataException;
import nu.xom.Node;
import nu.xom.Text;
import nu.xom.Verifier;

public class Comment
extends Node {
    private String data;

    public Comment(String string) {
        this._setValue(string);
    }

    public Comment(Comment comment) {
        this.data = comment.data;
    }

    private Comment() {
    }

    static Comment build(String string) {
        Comment comment = new Comment();
        comment.data = string;
        return comment;
    }

    public final String getValue() {
        return this.data;
    }

    public void setValue(String string) {
        this._setValue(string);
    }

    private void _setValue(String string) {
        if (string == null) {
            string = "";
        } else {
            Verifier.checkPCDATA(string);
            if (string.indexOf("--") != -1) {
                IllegalDataException illegalDataException = new IllegalDataException("Comment data contains a double hyphen (--).");
                illegalDataException.setData(string);
                throw illegalDataException;
            }
            if (string.indexOf(13) != -1) {
                IllegalDataException illegalDataException = new IllegalDataException("Comment data cannot contain carriage returns.");
                illegalDataException.setData(string);
                throw illegalDataException;
            }
            if (string.endsWith("-")) {
                IllegalDataException illegalDataException = new IllegalDataException("Comment data ends with a hyphen.");
                illegalDataException.setData(string);
                throw illegalDataException;
            }
        }
        this.data = string;
    }

    public final Node getChild(int n) {
        throw new IndexOutOfBoundsException("LeafNodes do not have children");
    }

    public final int getChildCount() {
        return 0;
    }

    public Node copy() {
        return new Comment(this.data);
    }

    public final String toXML() {
        StringBuffer stringBuffer = new StringBuffer("<!--");
        stringBuffer.append(this.data);
        stringBuffer.append("-->");
        return stringBuffer.toString();
    }

    public final String toString() {
        String string = this.getValue();
        if (string.length() <= 40) {
            return "[" + this.getClass().getName() + ": " + Text.escapeLineBreaksAndTruncate(string) + "]";
        }
        return "[" + this.getClass().getName() + ": " + Text.escapeLineBreaksAndTruncate(string.substring(0, 35)) + "...]";
    }

    boolean isComment() {
        return true;
    }
}

