/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.util.ui;

import com.almworks.util.Log;
import java.awt.Color;

public class ColorUtil {
    public static final Color ERROR_COLOR = Color.RED;
    public static final Color SEARCH_HIGLIGHT_BACKCOLOR = ColorUtil.between(Color.GREEN, Color.BLACK, 0.1f);
    public static final String SEARCH_HIGLIGHT_BACKCOLOR_LITERAL = ColorUtil.colorToHtmlLiteral(SEARCH_HIGLIGHT_BACKCOLOR);
    public static final Color SEARCH_HIGLIGHT_FORECOLOR = Color.WHITE;
    public static final String SEARCH_HIGLIGHT_FORECOLOR_LITERAL = ColorUtil.colorToHtmlLiteral(SEARCH_HIGLIGHT_FORECOLOR);
    private static final float BRED = 0.213f;
    private static final float BGREEN = 0.715f;
    private static final float BBLUE = 0.072f;

    public static String colorToHtmlLiteral(Color clr) {
        StringBuffer result = new StringBuffer("#");
        int[] rgb = new int[]{clr.getRed(), clr.getGreen(), clr.getBlue()};
        for (int i = 0; i < rgb.length; ++i) {
            String hex = Integer.toHexString(rgb[i]);
            if (hex.length() < 2) {
                result.append(0);
            }
            result.append(hex);
        }
        return result.toString();
    }

    public static Color transform(Color color, int tuneRed, int tuneGreen, int tuneBlue, int tuneBright) {
        float r = ColorUtil.floatify(color.getRed());
        float g = ColorUtil.floatify(color.getGreen());
        float b = ColorUtil.floatify(color.getBlue());
        float y = ColorUtil.getBrightness(r, g, b);
        float nr = r * ColorUtil.coef(tuneRed);
        float ng = g * ColorUtil.coef(tuneGreen);
        float nb = b * ColorUtil.coef(tuneBlue);
        float ny = y * ColorUtil.coef(tuneBright);
        ny = Math.min(Math.max(ny, 0.0f), 1.0f);
        float ry = ColorUtil.getBrightness(nr, ng, nb);
        float diff = ry - ny;
        nr = Math.min(Math.max(nr - diff * 0.213f, 0.0f), 1.0f);
        ng = Math.min(Math.max(ng - diff * 0.715f, 0.0f), 1.0f);
        nb = Math.min(Math.max(nb - diff * 0.072f, 0.0f), 1.0f);
        assert ((double)Math.abs(ColorUtil.getBrightness(nr, ng, nb) - ny) < 0.01);
        return new Color(nr, ng, nb);
    }

    private static float coef(int tune) {
        if (tune == 0) {
            return 1.0f;
        }
        if (tune < 0) {
            if (tune < -9) {
                tune = -9;
            }
            return (float)(10 + tune) / 10.0f;
        }
        if (tune > 9) {
            tune = 9;
        }
        return 10.0f / (float)(10 - tune);
    }

    private static float floatify(int v) {
        if (v < 0) {
            v = 0;
        } else if (v > 255) {
            v = 255;
        }
        return ((float)v + 1.0f) / 256.0f;
    }

    private static float getBrightness(float r, float g, float b) {
        return r * 0.213f + g * 0.715f + b * 0.072f;
    }

    public static Color adjustHSB(Color color, float hue, float saturation, float brightness) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        if (hue >= 0.0f) {
            hsb[0] = hue;
        }
        if (saturation >= 0.0f) {
            hsb[1] = saturation;
        }
        if (brightness >= 0.0f) {
            hsb[2] = brightness;
        }
        color = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
        return color;
    }

    public static Color between(Color from, Color to, float percent) {
        if (to == null && from == null) {
            assert (false);
            return null;
        }
        if (to == null) {
            assert (false);
            Log.debug("to null");
            return from;
        }
        if (from == null) {
            assert (false);
            Log.debug("from null");
            return to;
        }
        if (percent < 0.0f) {
            percent = 0.0f;
        }
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        int red = ColorUtil.normalize(from.getRed() + Math.round(percent * (float)(to.getRed() - from.getRed())));
        int green = ColorUtil.normalize(from.getGreen() + Math.round(percent * (float)(to.getGreen() - from.getGreen())));
        int blue = ColorUtil.normalize(from.getBlue() + Math.round(percent * (float)(to.getBlue() - from.getBlue())));
        return new Color(red, green, blue);
    }

    private static int normalize(int colorComponent) {
        if (colorComponent < 0) {
            colorComponent = 0;
        }
        if (colorComponent > 255) {
            colorComponent = 255;
        }
        return colorComponent;
    }
}

