;;; uiso8859-13.el --- tables between UCS and ISO-8859-13   -*- coding: iso-2022-7bit  -*-

;; Copyright (C) 2005 Aidan Kehoe

;; Author: Aidan Kehoe <kehoea@parhasard.net>
;; Keywords: i18n

;; This file is a contribution to Mule-UCS.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(put 'latin-iso8859-13 'unicode-assoc 'iso-8859-13-vs-unicode-assoc)

(defvar
  iso-8859-13-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      ((?\,_ (B . "0x00A0")		; NO-BREAK SPACE
       (?,Y!(B . "0x201D")		; RIGHT DOUBLE QUOTATION MARK
       (?,Y"(B . "0x00A2")		; CENT SIGN
       (?,Y#(B . "0x00A3")		; POUND SIGN
       (?,Y#(B . "0x00A3")		; POUND SIGN
       (?,Y$(B . "0x00A4")		; CURRENCY SIGN
       (?,Y%(B . "0x201E")		; DOUBLE LOW-9 QUOTATION MARK
       (?,Y&(B . "0x00A6")		; BROKEN BAR
       (?,Y'(B . "0x00A7")		; SECTION SIGN
       (?,Y((B . "0x00D8")		; LATIN CAPITAL LETTER O WITH STROKE
       (?,Y)(B . "0x00A9")		; COPYRIGHT SIGN
       (?,Y*(B . "0x0156")		; LATIN CAPITAL LETTER R WITH CEDILLA
       (?,Y+(B . "0x00AB")		; LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
       (?,Y,(B . "0x00AC")		; NOT SIGN
       (?,Y-(B . "0x00AD")		; SOFT HYPHEN
       (?,Y.(B . "0x00AE")		; REGISTERED SIGN
       (?,Y/(B . "0x00C6")		; LATIN CAPITAL LETTER AE
       (?,Y0(B . "0x00B0")		; DEGREE SIGN
       (?,Y1(B . "0x00B1")		; PLUS-MINUS SIGN
       (?,Y2(B . "0x00B2")		; SUPERSCRIPT TWO
       (?,Y3(B . "0x00B3")		; SUPERSCRIPT THREE
       (?,Y4(B . "0x201C")		; LEFT DOUBLE QUOTATION MARK
       (?,Y5(B . "0x00B5")		; MICRO SIGN
       (?,Y6(B . "0x00B6")		; PILCROW SIGN
       (?,Y7(B . "0x00B7")		; MIDDLE DOT
       (?,Y8(B . "0x00F8")		; LATIN SMALL LETTER O WITH STROKE
       (?,Y9(B . "0x00B9")		; SUPERSCRIPT ONE
       (?,Y:(B . "0x0157")		; LATIN SMALL LETTER R WITH CEDILLA
       (?,Y;(B . "0x00BB")		; RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
       (?,Y<(B . "0x00BC")		; VULGAR FRACTION ONE QUARTER
       (?,Y=(B . "0x00BD")		; VULGAR FRACTION ONE HALF
       (?,Y>(B . "0x00BE")		; VULGAR FRACTION THREE QUARTERS
       (?,Y?(B . "0x00E6")		; LATIN SMALL LETTER AE
       (?,Y@(B . "0x0104")		; LATIN CAPITAL LETTER A WITH OGONEK
       (?,YA(B . "0x012E")		; LATIN CAPITAL LETTER I WITH OGONEK
       (?,YB(B . "0x0100")		; LATIN CAPITAL LETTER A WITH MACRON
       (?,YC(B . "0x0106")		; LATIN CAPITAL LETTER C WITH ACUTE
       (?,YD(B . "0x00C4")		; LATIN CAPITAL LETTER A WITH DIAERESIS
       (?,YE(B . "0x00C5")		; LATIN CAPITAL LETTER A WITH RING ABOVE
       (?,YF(B . "0x0118")		; LATIN CAPITAL LETTER E WITH OGONEK
       (?,YG(B . "0x0112")		; LATIN CAPITAL LETTER E WITH MACRON
       (?,YH(B . "0x010C")		; LATIN CAPITAL LETTER C WITH CARON
       (?,YI(B . "0x00C9")		; LATIN CAPITAL LETTER E WITH ACUTE
       (?,YJ(B . "0x0179")		; LATIN CAPITAL LETTER Z WITH ACUTE
       (?,YK(B . "0x0116")		; LATIN CAPITAL LETTER E WITH DOT ABOVE
       (?,YL(B . "0x0122")		; LATIN CAPITAL LETTER G WITH CEDILLA
       (?,YM(B . "0x0136")		; LATIN CAPITAL LETTER K WITH CEDILLA
       (?,YN(B . "0x012A")		; LATIN CAPITAL LETTER I WITH MACRON
       (?,YO(B . "0x013B")		; LATIN CAPITAL LETTER L WITH CEDILLA
       (?,YP(B . "0x0160")		; LATIN CAPITAL LETTER S WITH CARON
       (?,YQ(B . "0x0143")		; LATIN CAPITAL LETTER N WITH ACUTE
       (?,YR(B . "0x0145")		; LATIN CAPITAL LETTER N WITH CEDILLA
       (?,YS(B . "0x00D3")		; LATIN CAPITAL LETTER O WITH ACUTE
       (?,YT(B . "0x014C")		; LATIN CAPITAL LETTER O WITH MACRON
       (?,YU(B . "0x00D5")		; LATIN CAPITAL LETTER O WITH TILDE
       (?,YV(B . "0x00D6")		; LATIN CAPITAL LETTER O WITH DIAERESIS
       (?,YW(B . "0x00D7")		; MULTIPLICATION SIGN
       (?,YX(B . "0x0172")		; LATIN CAPITAL LETTER U WITH OGONEK
       (?,YY(B . "0x0141")		; LATIN CAPITAL LETTER L WITH STROKE
       (?,YZ(B . "0x015A")		; LATIN CAPITAL LETTER S WITH ACUTE
       (?,Y[(B . "0x016A")		; LATIN CAPITAL LETTER U WITH MACRON
       (?,Y\(B . "0x00DC")		; LATIN CAPITAL LETTER U WITH DIAERESIS
       (?,Y](B . "0x017B")		; LATIN CAPITAL LETTER Z WITH DOT ABOVE
       (?,Y^(B . "0x017D")		; LATIN CAPITAL LETTER Z WITH CARON
       (?,Y_(B . "0x00DF")		; LATIN SMALL LETTER SHARP S (German)
       (?,Y`(B . "0x0105")		; LATIN SMALL LETTER A WITH OGONEK
       (?,Ya(B . "0x012F")		; LATIN SMALL LETTER I WITH OGONEK
       (?,Yb(B . "0x0101")		; LATIN SMALL LETTER A WITH MACRON
       (?,Yc(B . "0x0107")		; LATIN SMALL LETTER C WITH ACUTE
       (?,Yd(B . "0x00E4")		; LATIN SMALL LETTER A WITH DIAERESIS
       (?,Ye(B . "0x00E5")		; LATIN SMALL LETTER A WITH RING ABOVE
       (?,Yf(B . "0x0119")		; LATIN SMALL LETTER E WITH OGONEK
       (?,Yg(B . "0x0113")		; LATIN SMALL LETTER E WITH MACRON
       (?,Yh(B . "0x010D")		; LATIN SMALL LETTER C WITH CARON
       (?,Yi(B . "0x00E9")		; LATIN SMALL LETTER E WITH ACUTE
       (?,Yj(B . "0x017A")		; LATIN SMALL LETTER Z WITH ACUTE
       (?,Yk(B . "0x0117")		; LATIN SMALL LETTER E WITH DOT ABOVE
       (?,Yl(B . "0x0123")		; LATIN SMALL LETTER G WITH CEDILLA
       (?,Ym(B . "0x0137")		; LATIN SMALL LETTER K WITH CEDILLA
       (?,Yn(B . "0x012B")		; LATIN SMALL LETTER I WITH MACRON
       (?,Yo(B . "0x013C")		; LATIN SMALL LETTER L WITH CEDILLA
       (?,Yp(B . "0x0161")		; LATIN SMALL LETTER S WITH CARON
       (?,Yq(B . "0x0144")		; LATIN SMALL LETTER N WITH ACUTE
       (?,Yr(B . "0x0146")		; LATIN SMALL LETTER N WITH CEDILLA
       (?,Ys(B . "0x00F3")		; LATIN SMALL LETTER O WITH ACUTE
       (?,Yt(B . "0x014D")		; LATIN SMALL LETTER O WITH MACRON
       (?,Yu(B . "0x00F5")		; LATIN SMALL LETTER O WITH TILDE
       (?,Yv(B . "0x00F6")		; LATIN SMALL LETTER O WITH DIAERESIS
       (?,Yw(B . "0x00F7")		; DIVISION SIGN
       (?,Yx(B . "0x0173")		; LATIN SMALL LETTER U WITH OGONEK
       (?,Yy(B . "0x0142")		; LATIN SMALL LETTER L WITH STROKE
       (?,Yz(B . "0x015B")		; LATIN SMALL LETTER S WITH ACUTE
       (?,Y{(B . "0x016B")		; LATIN SMALL LETTER U WITH MACRON
       (?,Y|(B . "0x00FC")		; LATIN SMALL LETTER U WITH DIAERESIS
       (?,Y}(B . "0x017C")		; LATIN SMALL LETTER Z WITH DOT ABOVE
       (?,Y~(B . "0x017E")		; LATIN SMALL LETTER Z WITH CARON
       (?,Y(B . "0x2019")		; RIGHT SINGLE QUOTATION MARK
       ))))

(provide 'uiso8859-13)

;;; uiso8859-13.el ends here
