"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitions = void 0;
const fz = __importStar(require("../converters/fromZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const m = __importStar(require("../lib/modernExtend"));
const reporting = __importStar(require("../lib/reporting"));
const utils = __importStar(require("../lib/utils"));
const e = exposes.presets;
const ea = exposes.access;
const bituo_fz = {
    // To resolve the [https://github.com/Koenkk/zigbee2mqtt/issues/19705] issue, multiply all power attributes, except for powerFactor, by acPowerdivisor in advance.
    // To avoid future adjustments of acPowerdivisor to 1 in the firmware, the power attributes are not directly multiplied by 1000.
    electrical_measurement: {
        ...fz.electrical_measurement,
        convert: (model, msg, publish, options, meta) => {
            const divisor = msg.endpoint.getClusterAttributeValue("haElectricalMeasurement", "acPowerDivisor") || 1;
            for (const field of Object.keys(msg.data)) {
                const lowerField = field.toLowerCase();
                if (lowerField.includes("power") && // Fields containing "power" are included
                    !lowerField.includes("powerfactor") // excluding "powerFactor" (case-sensitive, lowercase comparison）
                ) {
                    if (msg.data[field] !== undefined) {
                        msg.data[field] = msg.data[field] * divisor;
                    }
                }
            }
            return fz.electrical_measurement.convert(model, msg, publish, options, meta);
        },
    },
    total_power: {
        cluster: "haElectricalMeasurement",
        type: ["attributeReport", "readResponse"],
        convert: (model, msg, publish, options, meta) => {
            const result = {};
            if (msg.data.totalActivePower !== undefined) {
                result[utils.postfixWithEndpointName("total_power", msg, model, meta)] = msg.data.totalActivePower;
            }
            if (msg.data.totalReactivePower !== undefined) {
                result[utils.postfixWithEndpointName("total_power_reactive", msg, model, meta)] = msg.data.totalReactivePower;
            }
            if (msg.data.totalApparentPower !== undefined) {
                result[utils.postfixWithEndpointName("total_power_apparent", msg, model, meta)] = msg.data.totalApparentPower;
            }
            return result;
        },
    },
};
exports.definitions = [
    {
        zigbeeModel: ["SPM01X001", "SPM01X"],
        model: "SPM01-U01",
        vendor: "BITUO TECHNIK",
        description: "Smart energy monitor for 1P+N system",
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.readEletricalMeasurementMultiplierDivisors(endpoint);
            await reporting.readMeteringMultiplierDivisor(endpoint);
            await reporting.bind(endpoint, coordinatorEndpoint, ["haElectricalMeasurement", "seMetering"]);
        },
        extend: [
            m.electricityMeter({
                fzElectricalMeasurement: bituo_fz.electrical_measurement,
                producedEnergy: true,
                acFrequency: true,
                powerFactor: true,
                configureReporting: false,
            }),
        ],
        meta: {},
        exposes: [e.power_apparent()],
    },
    {
        zigbeeModel: ["SDM01W"],
        model: "SDM01W-U01",
        vendor: "BITUO TECHNIK",
        description: "Smart energy monitor for 3P+N system",
        fromZigbee: [bituo_fz.total_power],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.readEletricalMeasurementMultiplierDivisors(endpoint);
            await reporting.readMeteringMultiplierDivisor(endpoint);
            await reporting.bind(endpoint, coordinatorEndpoint, ["haElectricalMeasurement", "seMetering"]);
        },
        extend: [
            m.identify(),
            m.onOff({ powerOnBehavior: false, description: "Toggle to 'On' to Zero the energy" }),
            m.electricityMeter({
                fzElectricalMeasurement: bituo_fz.electrical_measurement,
                threePhase: true,
                producedEnergy: true,
                acFrequency: true,
                powerFactor: true,
                configureReporting: false,
            }),
        ],
        meta: {},
        exposes: [
            e.power_reactive(),
            e.power_reactive_phase_b(),
            e.power_reactive_phase_c(),
            e.power_apparent(),
            e.power_apparent_phase_b(),
            e.power_apparent_phase_c(),
            e.power_factor_phase_b(),
            e.power_factor_phase_c(),
            e.numeric("total_power", ea.STATE).withUnit("W").withDescription("Total Active Power"),
            e.numeric("total_power_reactive", ea.STATE).withUnit("VAR").withDescription("Total Reactive Power"),
            e.numeric("total_power_apparent", ea.STATE).withUnit("VA").withDescription("Total Apparent Power"),
        ],
    },
    {
        zigbeeModel: ["SDM01B"],
        model: "SDM01B-U01",
        vendor: "BITUO TECHNIK",
        description: "Smart energy monitor for 1P+N system",
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.readEletricalMeasurementMultiplierDivisors(endpoint);
            await reporting.readMeteringMultiplierDivisor(endpoint);
            await reporting.bind(endpoint, coordinatorEndpoint, ["haElectricalMeasurement", "seMetering"]);
        },
        extend: [
            m.identify(),
            m.onOff({ powerOnBehavior: false, description: "Toggle to 'On' to Zero the energy" }),
            m.electricityMeter({
                fzElectricalMeasurement: bituo_fz.electrical_measurement,
                producedEnergy: true,
                acFrequency: true,
                powerFactor: true,
                configureReporting: false,
            }),
        ],
        meta: {},
        exposes: [e.power_apparent()],
    },
    {
        zigbeeModel: ["SDM02X"],
        model: "SDM02-U01",
        vendor: "BITUO TECHNIK",
        description: "Smart energy monitor for 2P+N system",
        fromZigbee: [bituo_fz.total_power],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.readEletricalMeasurementMultiplierDivisors(endpoint);
            await reporting.readMeteringMultiplierDivisor(endpoint);
            await reporting.bind(endpoint, coordinatorEndpoint, ["haElectricalMeasurement", "seMetering"]);
        },
        extend: [
            m.electricityMeter({
                fzElectricalMeasurement: bituo_fz.electrical_measurement,
                acFrequency: true,
                powerFactor: true,
                configureReporting: false,
                producedEnergy: true,
            }),
        ],
        exposes: [
            e.power_phase_b(),
            e.power_reactive(),
            e.power_reactive_phase_b(),
            e.power_apparent(),
            e.power_apparent_phase_b(),
            e.current_phase_b(),
            e.voltage_phase_b(),
            e.power_factor_phase_b(),
            e.numeric("total_power", ea.STATE).withUnit("W").withDescription("Total Active Power"),
            e.numeric("total_power_reactive", ea.STATE).withUnit("VAR").withDescription("Total Reactive Power"),
            e.numeric("total_power_apparent", ea.STATE).withUnit("VA").withDescription("Total Apparent Power"),
        ],
    },
    {
        zigbeeModel: ["SPM02X001", "SPM02X"],
        model: "SPM02-U01",
        vendor: "BITUO TECHNIK",
        description: "Smart energy monitor for 3P+N system",
        fromZigbee: [bituo_fz.total_power],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(1);
            await reporting.readEletricalMeasurementMultiplierDivisors(endpoint);
            await reporting.readMeteringMultiplierDivisor(endpoint);
            await reporting.bind(endpoint, coordinatorEndpoint, ["haElectricalMeasurement", "seMetering"]);
        },
        extend: [
            m.electricityMeter({
                fzElectricalMeasurement: bituo_fz.electrical_measurement,
                threePhase: true,
                producedEnergy: true,
                acFrequency: true,
                powerFactor: true,
                configureReporting: false,
            }),
        ],
        meta: {},
        exposes: [
            e.power_reactive(),
            e.power_reactive_phase_b(),
            e.power_reactive_phase_c(),
            e.power_apparent(),
            e.power_apparent_phase_b(),
            e.power_apparent_phase_c(),
            e.power_factor_phase_b(),
            e.power_factor_phase_c(),
            e.numeric("total_power", ea.STATE).withUnit("W").withDescription("Total Active Power"),
            e.numeric("total_power_reactive", ea.STATE).withUnit("VAR").withDescription("Total Reactive Power"),
            e.numeric("total_power_apparent", ea.STATE).withUnit("VA").withDescription("Total Apparent Power"),
        ],
    },
    {
        zigbeeModel: ["SPM01"],
        model: "SPM01-U02",
        vendor: "BITUO TECHNIK",
        description: "Smart energy monitor for 1P+N system",
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(11);
            await reporting.readEletricalMeasurementMultiplierDivisors(endpoint);
            await reporting.readMeteringMultiplierDivisor(endpoint);
            await reporting.bind(endpoint, coordinatorEndpoint, ["haElectricalMeasurement", "seMetering"]);
        },
        extend: [
            m.electricityMeter({
                fzMetering: fz.metering,
                fzElectricalMeasurement: bituo_fz.electrical_measurement,
                acFrequency: true,
                powerFactor: true,
                configureReporting: false,
                producedEnergy: true,
            }),
        ],
        exposes: [e.power_apparent()],
    },
    {
        zigbeeModel: ["SDM02"],
        model: "SDM02-U02",
        vendor: "BITUO TECHNIK",
        description: "Smart energy monitor for 2P+N system",
        fromZigbee: [bituo_fz.total_power],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(11);
            await reporting.readEletricalMeasurementMultiplierDivisors(endpoint);
            await reporting.readMeteringMultiplierDivisor(endpoint);
            await reporting.bind(endpoint, coordinatorEndpoint, ["haElectricalMeasurement", "seMetering"]);
        },
        extend: [
            m.electricityMeter({
                fzElectricalMeasurement: bituo_fz.electrical_measurement,
                acFrequency: true,
                powerFactor: true,
                configureReporting: false,
                producedEnergy: true,
            }),
        ],
        exposes: [
            e.power_phase_b(),
            e.power_reactive(),
            e.power_reactive_phase_b(),
            e.power_apparent(),
            e.power_apparent_phase_b(),
            e.current_phase_b(),
            e.voltage_phase_b(),
            e.power_factor_phase_b(),
            e.numeric("total_power", ea.STATE).withUnit("W").withDescription("Total Active Power"),
            e.numeric("total_power_reactive", ea.STATE).withUnit("VAR").withDescription("Total Reactive Power"),
            e.numeric("total_power_apparent", ea.STATE).withUnit("VA").withDescription("Total Apparent Power"),
        ],
    },
    {
        zigbeeModel: ["SPM02"],
        model: "SPM02-U02",
        vendor: "BITUO TECHNIK",
        description: "Smart energy monitor for 3P+N system",
        fromZigbee: [bituo_fz.total_power],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(11);
            await reporting.readEletricalMeasurementMultiplierDivisors(endpoint);
            await reporting.readMeteringMultiplierDivisor(endpoint);
            await reporting.bind(endpoint, coordinatorEndpoint, ["haElectricalMeasurement", "seMetering"]);
        },
        extend: [
            m.electricityMeter({
                fzElectricalMeasurement: bituo_fz.electrical_measurement,
                acFrequency: true,
                powerFactor: true,
                configureReporting: false,
                producedEnergy: true,
                threePhase: true,
            }),
        ],
        exposes: [
            e.power_reactive(),
            e.power_reactive_phase_b(),
            e.power_reactive_phase_c(),
            e.power_apparent(),
            e.power_apparent_phase_b(),
            e.power_apparent_phase_c(),
            e.power_factor_phase_b(),
            e.power_factor_phase_c(),
            e.numeric("total_power", ea.STATE).withUnit("W").withDescription("Total Active Power"),
            e.numeric("total_power_reactive", ea.STATE).withUnit("VAR").withDescription("Total Reactive Power"),
            e.numeric("total_power_apparent", ea.STATE).withUnit("VA").withDescription("Total Apparent Power"),
        ],
    },
    {
        zigbeeModel: ["SPM01-E0"],
        model: "SPM01-U00",
        vendor: "BITUO TECHNIK",
        description: "Smart energy monitor for 1P+N system",
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(10);
            await reporting.readEletricalMeasurementMultiplierDivisors(endpoint);
            await reporting.readMeteringMultiplierDivisor(endpoint);
            await reporting.bind(endpoint, coordinatorEndpoint, ["haElectricalMeasurement", "seMetering"]);
        },
        extend: [
            m.identify(),
            m.onOff({ powerOnBehavior: false, description: "Toggle to 'On' to Zero the energy" }),
            m.electricityMeter({
                fzMetering: fz.metering,
                fzElectricalMeasurement: bituo_fz.electrical_measurement,
                acFrequency: true,
                powerFactor: true,
                configureReporting: false,
                producedEnergy: true,
            }),
        ],
        exposes: [e.power_apparent()],
    },
    {
        zigbeeModel: ["SDM02-E0"],
        model: "SDM02-U00",
        vendor: "BITUO TECHNIK",
        description: "Smart energy monitor for 2P+N system",
        fromZigbee: [bituo_fz.total_power],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(10);
            await reporting.readEletricalMeasurementMultiplierDivisors(endpoint);
            await reporting.readMeteringMultiplierDivisor(endpoint);
            await reporting.bind(endpoint, coordinatorEndpoint, ["haElectricalMeasurement", "seMetering"]);
        },
        extend: [
            m.identify(),
            m.onOff({ powerOnBehavior: false, description: "Toggle to 'On' to Zero the energy" }),
            m.electricityMeter({
                fzElectricalMeasurement: bituo_fz.electrical_measurement,
                acFrequency: true,
                powerFactor: true,
                configureReporting: false,
                producedEnergy: true,
            }),
        ],
        exposes: [
            e.power_phase_b(),
            e.power_reactive(),
            e.power_reactive_phase_b(),
            e.power_apparent(),
            e.power_apparent_phase_b(),
            e.current_phase_b(),
            e.voltage_phase_b(),
            e.power_factor_phase_b(),
            e.numeric("total_power", ea.STATE).withUnit("W").withDescription("Total Active Power"),
            e.numeric("total_power_reactive", ea.STATE).withUnit("VAR").withDescription("Total Reactive Power"),
            e.numeric("total_power_apparent", ea.STATE).withUnit("VA").withDescription("Total Apparent Power"),
        ],
    },
    {
        zigbeeModel: ["SPM02-E0"],
        model: "SPM02-U00",
        vendor: "BITUO TECHNIK",
        description: "Smart energy monitor for 3P+N system",
        fromZigbee: [bituo_fz.total_power],
        configure: async (device, coordinatorEndpoint) => {
            const endpoint = device.getEndpoint(10);
            await reporting.readEletricalMeasurementMultiplierDivisors(endpoint);
            await reporting.readMeteringMultiplierDivisor(endpoint);
            await reporting.bind(endpoint, coordinatorEndpoint, ["haElectricalMeasurement", "seMetering"]);
        },
        extend: [
            m.identify(),
            m.onOff({ powerOnBehavior: false, description: "Toggle to 'On' to Zero the energy" }),
            m.electricityMeter({
                fzElectricalMeasurement: bituo_fz.electrical_measurement,
                acFrequency: true,
                powerFactor: true,
                configureReporting: false,
                producedEnergy: true,
                threePhase: true,
            }),
        ],
        exposes: [
            e.power_reactive(),
            e.power_reactive_phase_b(),
            e.power_reactive_phase_c(),
            e.power_apparent(),
            e.power_apparent_phase_b(),
            e.power_apparent_phase_c(),
            e.power_factor_phase_b(),
            e.power_factor_phase_c(),
            e.numeric("total_power", ea.STATE).withUnit("W").withDescription("Total Active Power"),
            e.numeric("total_power_reactive", ea.STATE).withUnit("VAR").withDescription("Total Reactive Power"),
            e.numeric("total_power_apparent", ea.STATE).withUnit("VA").withDescription("Total Apparent Power"),
        ],
    },
];
//# sourceMappingURL=bituo_technik.js.map