/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.record.cipher.cryptohelper;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.CipherType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.parser.Parser;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyBlockParser
extends Parser<KeySet> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int SEQUENCE_NUMBER_LENGTH = 8;
    public static final int AEAD_IV_LENGTH = 12;
    private final CipherSuite suite;
    private final ProtocolVersion version;

    public KeyBlockParser(byte[] keyBlock, CipherSuite suite, ProtocolVersion version) {
        super(0, keyBlock);
        this.suite = suite;
        this.version = version;
    }

    @Override
    public KeySet parse() {
        KeySet keys = new KeySet();
        if (AlgorithmResolver.getCipherType(this.suite) != CipherType.AEAD) {
            this.parseClientWriteMacSecret(keys);
            this.parseServerWriteMacSecret(keys);
        }
        this.parseClientWriteKey(keys);
        this.parseServerWriteKey(keys);
        if (AlgorithmResolver.getCipherType(this.suite) == CipherType.BLOCK && !this.version.usesExplicitIv() || this.suite.isSteamCipherWithIV()) {
            this.parseClientWriteIvBlock(keys);
            this.parseServerWriteIvBlock(keys);
        } else if (AlgorithmResolver.getCipherType(this.suite) == CipherType.AEAD) {
            this.parseClientWriteIvAead(keys);
            this.parseServerWriteIvAead(keys);
        }
        return keys;
    }

    private int getAeadSaltSize() {
        return 12 - AlgorithmResolver.getCipher(this.suite).getNonceBytesFromRecord();
    }

    private void parseClientWriteIvBlock(KeySet keys) {
        keys.setClientWriteIv(this.parseByteArrayField(this.getIVSize()));
        LOGGER.debug("ClientWriteIV: " + ArrayConverter.bytesToHexString((byte[])keys.getClientWriteIv()));
    }

    private void parseServerWriteIvBlock(KeySet keys) {
        keys.setServerWriteIv(this.parseByteArrayField(this.getIVSize()));
        LOGGER.debug("ServerWriteIV: " + ArrayConverter.bytesToHexString((byte[])keys.getServerWriteIv()));
    }

    private void parseClientWriteIvAead(KeySet keys) {
        keys.setClientWriteIv(this.parseByteArrayField(this.getAeadSaltSize()));
        LOGGER.debug("ClientWriteIV AEAD: " + ArrayConverter.bytesToHexString((byte[])keys.getClientWriteIv()));
    }

    private void parseServerWriteIvAead(KeySet keys) {
        keys.setServerWriteIv(this.parseByteArrayField(this.getAeadSaltSize()));
        LOGGER.debug("ServerWriteIV AEAD: " + ArrayConverter.bytesToHexString((byte[])keys.getServerWriteIv()));
    }

    private void parseClientWriteKey(KeySet keys) {
        keys.setClientWriteKey(this.parseByteArrayField(this.getKeySize()));
        LOGGER.debug("ClientWriteKey: " + ArrayConverter.bytesToHexString((byte[])keys.getClientWriteKey()));
    }

    private void parseServerWriteKey(KeySet keys) {
        keys.setServerWriteKey(this.parseByteArrayField(this.getKeySize()));
        LOGGER.debug("ServerWriteKey: " + ArrayConverter.bytesToHexString((byte[])keys.getServerWriteKey()));
    }

    private void parseClientWriteMacSecret(KeySet keys) {
        keys.setClientWriteMacSecret(this.parseByteArrayField(this.getMacKeySize()));
        LOGGER.debug("ClientMacKey: " + ArrayConverter.bytesToHexString((byte[])keys.getClientWriteMacSecret()));
    }

    private void parseServerWriteMacSecret(KeySet keys) {
        keys.setServerWriteMacSecret(this.parseByteArrayField(this.getMacKeySize()));
        LOGGER.debug("ServerMacKey: " + ArrayConverter.bytesToHexString((byte[])keys.getServerWriteMacSecret()));
    }

    private int getMacKeySize() {
        return AlgorithmResolver.getMacAlgorithm(this.version, this.suite).getKeySize();
    }

    private int getKeySize() {
        if (this.suite.isExportSymmetricCipher()) {
            return 5;
        }
        return AlgorithmResolver.getCipher(this.suite).getKeySize();
    }

    private int getIVSize() {
        return AlgorithmResolver.getCipher(this.suite).getNonceBytesFromHandshake();
    }
}

