/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config;

import de.rub.nds.modifiablevariable.util.XMLPrettyPrinter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.filter.ConfigDisplayFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXB;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.xml.sax.SAXException;

public class ConfigIO {
    public static void write(Config config, File f) {
        try {
            ConfigIO.write(config, new FileOutputStream(f));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void write(Config config, OutputStream os) {
        ByteArrayOutputStream tempStream = new ByteArrayOutputStream();
        JAXB.marshal((Object)config, (OutputStream)tempStream);
        try {
            os.write(XMLPrettyPrinter.prettyPrintXML((String)new String(tempStream.toByteArray())).getBytes());
        }
        catch (IOException | ParserConfigurationException | TransformerException | XPathExpressionException | XPathFactoryConfigurationException | SAXException ex) {
            throw new RuntimeException("Could not format XML");
        }
    }

    public static void write(Config config, File f, ConfigDisplayFilter filter) {
        Config filteredConfig = ConfigIO.copy(config);
        filter.applyFilter(filteredConfig);
        ConfigIO.write(filteredConfig, f);
    }

    public static void write(Config config, OutputStream os, ConfigDisplayFilter filter) {
        Config filteredConfig = ConfigIO.copy(config);
        filter.applyFilter(filteredConfig);
        ConfigIO.write(filteredConfig, os);
    }

    public static Config read(File f) {
        Config config = (Config)JAXB.unmarshal((File)f, Config.class);
        return config;
    }

    public static Config read(InputStream stream) {
        Config config = (Config)JAXB.unmarshal((InputStream)stream, Config.class);
        return config;
    }

    public static Config copy(Config config) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ConfigIO.write(config, byteArrayOutputStream);
        return ConfigIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    private ConfigIO() {
    }
}

