/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.telemetry.VcsBackendTelemetrySpan;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceUtil;
import com.intellij.platform.vcs.impl.shared.telemetry.VcsScopeKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.SmallDataPack;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogJoiner;
import com.intellij.vcs.log.data.VcsLogMultiRepoJoiner;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogRefreshNotEnoughDataException;
import com.intellij.vcs.log.data.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.RequirementsImpl;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public class VcsLogRefresherImpl
implements VcsLogRefresher,
Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogRefresherImpl.class);
    private static final int SMALL_DATA_PACK_COMMITS_COUNT = Registry.intValue((String)"vcs.log.small.data.pack.commits.count");
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myProviders;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final VcsLogModifiableIndex myIndex;
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final VcsLogProgress myProgress;
    private final int myRecentCommitCount;
    @NotNull
    private final SingleTaskController<RefreshRequest, DataPack> mySingleTaskController;
    @NotNull
    private volatile DataPack myDataPack;
    @NotNull
    private final AtomicBoolean myInitialized;
    @NotNull
    private final Tracer myTracer;
    @NotNull
    private final Consumer<? super DataPack> myDataPackUpdateHandler;

    public VcsLogRefresherImpl(@NotNull Project project, @NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsUserRegistryImpl userRegistry, @NotNull VcsLogModifiableIndex index, @NotNull VcsLogProgress progress, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull Consumer<? super DataPack> dataPackUpdateHandler, int recentCommitsCount) {
        if (project == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(1);
        }
        if (providers == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(2);
        }
        if (userRegistry == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(3);
        }
        if (index == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(4);
        }
        if (progress == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(5);
        }
        if (topCommitsDetailsCache == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(6);
        }
        if (dataPackUpdateHandler == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(7);
        }
        this.myDataPack = DataPack.EMPTY;
        this.myInitialized = new AtomicBoolean();
        this.myTracer = TelemetryManager.getInstance().getTracer(VcsScopeKt.VcsScope);
        this.myProject = project;
        this.myStorage = storage;
        this.myProviders = providers;
        this.myUserRegistry = userRegistry;
        this.myIndex = index;
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myRecentCommitCount = recentCommitsCount;
        this.myProgress = progress;
        this.myDataPackUpdateHandler = dataPackUpdateHandler;
        this.mySingleTaskController = new SingleTaskController<RefreshRequest, DataPack>("permanent", (Disposable)this, dataPack -> {
            if (!(dataPack instanceof SmallDataPack)) {
                this.myDataPack = dataPack;
            }
            dataPackUpdateHandler.accept((DataPack)dataPack);
        }){

            @Override
            @NotNull
            protected SingleTaskController.SingleTask startNewBackgroundTask() {
                if (VcsLogRefresherImpl.this.myInitialized.compareAndSet(false, true)) {
                    SingleTaskController.SingleTask singleTask = VcsLogRefresherImpl.this.startNewBackgroundTask(new MyInitializationTask());
                    if (singleTask == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return singleTask;
                }
                SingleTaskController.SingleTask singleTask = VcsLogRefresherImpl.this.startNewBackgroundTask(new MyRefreshTask(VcsLogRefresherImpl.this.myDataPack));
                if (singleTask == null) {
                    1.$$$reportNull$$$0(1);
                }
                return singleTask;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$1", "startNewBackgroundTask"));
            }
        };
    }

    protected SingleTaskController.SingleTask startNewBackgroundTask(@NotNull Task.Backgroundable refreshTask) {
        if (refreshTask == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(8);
        }
        LOG.debug("Starting a background task...");
        ProgressIndicator indicator = this.myProgress.createProgressIndicator(VcsLogData.DATA_PACK_REFRESH);
        Future future = ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(refreshTask, indicator, null);
        return new SingleTaskController.SingleTaskImpl(future, indicator);
    }

    @Override
    @NotNull
    public DataPack getCurrentDataPack() {
        DataPack dataPack = this.myDataPack;
        if (dataPack == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(9);
        }
        return dataPack;
    }

    @NotNull
    private DataPack readFirstBlock() {
        DataPack dataPack;
        try {
            DataPack dataPack2 = (DataPack)TraceUtil.computeWithSpanThrows((SpanBuilder)this.myTracer.spanBuilder(VcsBackendTelemetrySpan.LogData.Initializing.getName()), __ -> this.loadRecentData(new CommitCountRequirements(this.myRecentCommitCount).asMap(this.myProviders.keySet()), this.myRecentCommitCount, false));
            this.mySingleTaskController.request((RefreshRequest[])new RefreshRequest[]{RefreshRequest.RELOAD_ALL});
            dataPack = dataPack2;
        }
        catch (ProcessCanceledException e) {
            this.myInitialized.compareAndSet(true, false);
            throw e;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return new DataPack.ErrorDataPack(e);
        }
        if (dataPack == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(10);
        }
        return dataPack;
    }

    @NotNull
    private DataPack loadRecentData(@NotNull Map<VirtualFile, VcsLogProvider.Requirements> requirements, int commitCount, boolean isSmallPack) throws VcsException {
        if (requirements == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(11);
        }
        LogInfo data = this.loadRecentData(requirements);
        Collection<List<GraphCommit<Integer>>> commits = data.getCommits();
        Map<VirtualFile, CompressedRefs> refs = data.getRefs();
        List compoundList = VcsLogRefresherImpl.multiRepoJoin(commits);
        compoundList = ContainerUtil.getFirstItems(compoundList, (int)commitCount);
        DataPack dataPack = isSmallPack ? SmallDataPack.build(compoundList, refs, this.myProviders, this.myStorage) : DataPack.build(compoundList, refs, this.myProviders, this.myStorage, false);
        if (dataPack == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(12);
        }
        return dataPack;
    }

    @NotNull
    private LogInfo loadRecentData(@NotNull Map<VirtualFile, VcsLogProvider.Requirements> requirements) throws VcsException {
        if (requirements == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(13);
        }
        LogInfo logInfo = (LogInfo)TraceUtil.computeWithSpanThrows((SpanBuilder)this.myTracer.spanBuilder(VcsBackendTelemetrySpan.LogData.ReadingRecentCommits.getName()), __ -> {
            LogInfo logInfo = new LogInfo(this.myStorage);
            for (Map.Entry<VirtualFile, VcsLogProvider> entry : this.getProvidersForRoots(requirements.keySet()).entrySet()) {
                VirtualFile root = entry.getKey();
                VcsLogProvider provider = entry.getValue();
                TraceUtil.runWithSpanThrows((SpanBuilder)this.myTracer.spanBuilder(VcsBackendTelemetrySpan.LogData.ReadingRecentCommitsInRoot.getName()).setAttribute("rootName", root.getName()), ignored -> {
                    VcsLogProvider.DetailedLogData data = provider.readFirstBlock(root, (VcsLogProvider.Requirements)requirements.get(root));
                    logInfo.put(root, this.compactCommits(data.getCommits(), root));
                    logInfo.put(root, data.getRefs());
                    this.storeUsersAndDetails(data.getCommits());
                });
            }
            this.myUserRegistry.flush();
            this.myIndex.scheduleIndex(false);
            return logInfo;
        });
        if (logInfo == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(14);
        }
        return logInfo;
    }

    private @Unmodifiable @NotNull Map<VirtualFile, VcsLogProvider> getProvidersForRoots(@NotNull Set<? extends VirtualFile> roots) {
        if (roots == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(15);
        }
        Map map = ContainerUtil.map2Map(roots, root -> Pair.create((Object)root, (Object)this.myProviders.get(root)));
        if (map == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(16);
        }
        return map;
    }

    @Override
    public void initialize() {
        if (this.myInitialized.get()) {
            return;
        }
        this.mySingleTaskController.request((RefreshRequest[])new RefreshRequest[]{RefreshRequest.INITIALIZE});
    }

    @Override
    public void refresh(@NotNull Collection<VirtualFile> rootsToRefresh, boolean optimize) {
        if (rootsToRefresh == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(17);
        }
        if (!rootsToRefresh.isEmpty()) {
            this.mySingleTaskController.request((RefreshRequest[])new RefreshRequest[]{new RefreshRequest(rootsToRefresh, optimize)});
        }
    }

    @NotNull
    private static <T extends GraphCommit<Integer>> List<T> multiRepoJoin(@NotNull Collection<? extends List<T>> commits) {
        if (commits == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(18);
        }
        Span span = TelemetryManager.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(VcsBackendTelemetrySpan.LogData.JoiningMultiRepoCommits.getName()).startSpan();
        List joined = new VcsLogMultiRepoJoiner().join(commits);
        span.end();
        List list = joined;
        if (list == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    private List<GraphCommit<Integer>> compactCommits(@NotNull List<? extends TimedVcsCommit> commits, @NotNull VirtualFile root) {
        if (commits == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(20);
        }
        if (root == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(21);
        }
        List list = (List)TraceKt.use((SpanBuilder)this.myTracer.spanBuilder(VcsBackendTelemetrySpan.LogData.CompactingCommits.getName()), span -> {
            if (commits.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<GraphCommit<Integer>> list = new ArrayList<GraphCommit<Integer>>(commits.size());
            for (TimedVcsCommit commit : commits) {
                list.add(this.compactCommit(commit, root));
            }
            return list;
        });
        if (list == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    private GraphCommit<Integer> compactCommit(@NotNull TimedVcsCommit commit, @NotNull VirtualFile root) {
        List<Integer> parents;
        List collection;
        if (commit == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(23);
        }
        if (root == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(24);
        }
        if ((collection = commit.getParents()).isEmpty()) {
            parents = Collections.emptyList();
        } else {
            parents = new ArrayList(collection.size());
            for (Hash t : collection) {
                parents.add(this.myStorage.getCommitIndex(t, root));
            }
        }
        int index = this.myStorage.getCommitIndex((Hash)commit.getId(), root);
        this.myIndex.markForIndexing(index, root);
        GraphCommit<Integer> graphCommit = GraphCommitImpl.createIntCommit(index, parents, commit.getTimestamp());
        if (graphCommit == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(25);
        }
        return graphCommit;
    }

    private void storeUsersAndDetails(@NotNull List<? extends VcsCommitMetadata> metadatas) {
        if (metadatas == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(26);
        }
        for (VcsCommitMetadata vcsCommitMetadata : metadatas) {
            this.myUserRegistry.addUser(vcsCommitMetadata.getAuthor());
            this.myUserRegistry.addUser(vcsCommitMetadata.getCommitter());
        }
        this.myTopCommitsDetailsCache.storeDetails(metadatas);
    }

    @NotNull
    public VcsLogProgress getProgress() {
        VcsLogProgress vcsLogProgress = this.myProgress;
        if (vcsLogProgress == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(27);
        }
        return vcsLogProgress;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 12, 14, 16, 19, 22, 25, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userRegistry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topCommitsDetailsCache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPackUpdateHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refreshTask";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogRefresherImpl";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToRefresh";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadatas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogRefresherImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentDataPack";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readFirstBlock";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRecentData";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersForRoots";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "multiRepoJoin";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "compactCommits";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "compactCommit";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startNewBackgroundTask";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: {
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadRecentData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getProvidersForRoots";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "multiRepoJoin";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "compactCommits";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "compactCommit";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "storeUsersAndDetails";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 12, 14, 16, 19, 22, 25, 27 -> new IllegalStateException(string);
        };
    }

    private static class RefreshRequest {
        private static final RefreshRequest RELOAD_ALL = new RefreshRequest((Collection)Collections.emptyList(), false){

            @Override
            @NonNls
            public String toString() {
                return "RELOAD_ALL";
            }
        };
        private static final RefreshRequest INITIALIZE = new RefreshRequest((Collection)Collections.emptyList(), false){

            @Override
            @NonNls
            public String toString() {
                return "INITIALIZE";
            }
        };
        private final Collection<VirtualFile> myRootsToRefresh;
        private final boolean myOptimize;

        RefreshRequest(@NotNull Collection<VirtualFile> rootsToRefresh, boolean optimize) {
            if (rootsToRefresh == null) {
                RefreshRequest.$$$reportNull$$$0(0);
            }
            this.myRootsToRefresh = rootsToRefresh;
            this.myOptimize = optimize;
        }

        public String toString() {
            return "{" + String.valueOf(this.myRootsToRefresh) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToRefresh", "com/intellij/vcs/log/data/VcsLogRefresherImpl$RefreshRequest", "<init>"));
        }
    }

    private static final class LogInfo {
        private final VcsLogStorage myStorage;
        private final Map<VirtualFile, CompressedRefs> myRefs = new HashMap<VirtualFile, CompressedRefs>();
        private final Map<VirtualFile, List<GraphCommit<Integer>>> myCommits = new HashMap<VirtualFile, List<GraphCommit<Integer>>>();

        LogInfo(VcsLogStorage storage) {
            this.myStorage = storage;
        }

        void put(@NotNull VirtualFile root, @NotNull List<GraphCommit<Integer>> commits) {
            if (root == null) {
                LogInfo.$$$reportNull$$$0(0);
            }
            if (commits == null) {
                LogInfo.$$$reportNull$$$0(1);
            }
            this.myCommits.put(root, commits);
        }

        void put(@NotNull VirtualFile root, @NotNull Set<VcsRef> refs) {
            if (root == null) {
                LogInfo.$$$reportNull$$$0(2);
            }
            if (refs == null) {
                LogInfo.$$$reportNull$$$0(3);
            }
            this.myRefs.put(root, new CompressedRefs(refs, this.myStorage));
        }

        @NotNull
        Collection<List<GraphCommit<Integer>>> getCommits() {
            Collection<List<GraphCommit<Integer>>> collection = this.myCommits.values();
            if (collection == null) {
                LogInfo.$$$reportNull$$$0(4);
            }
            return collection;
        }

        List<GraphCommit<Integer>> getCommits(@NotNull VirtualFile root) {
            if (root == null) {
                LogInfo.$$$reportNull$$$0(5);
            }
            return this.myCommits.get(root);
        }

        @NotNull
        Map<VirtualFile, CompressedRefs> getRefs() {
            Map<VirtualFile, CompressedRefs> map = this.myRefs;
            if (map == null) {
                LogInfo.$$$reportNull$$$0(6);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commits";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refs";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$LogInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$LogInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommits";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRefs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "put";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommits";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class CommitCountRequirements
    implements VcsLogProvider.Requirements {
        private final int myCommitCount;

        CommitCountRequirements(int commitCount) {
            this.myCommitCount = commitCount;
        }

        public int getCommitCount() {
            return this.myCommitCount;
        }

        @NotNull
        @Unmodifiable Map<VirtualFile, // Could not load outer class - annotation placement on inner may be incorrect
        VcsLogProvider.Requirements> asMap(@NotNull Collection<? extends VirtualFile> roots) {
            if (roots == null) {
                CommitCountRequirements.$$$reportNull$$$0(0);
            }
            Map map = ContainerUtil.map2Map(roots, root -> Pair.create((Object)root, (Object)this));
            if (map == null) {
                CommitCountRequirements.$$$reportNull$$$0(1);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$CommitCountRequirements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$CommitCountRequirements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "asMap";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class MyRefreshTask
    extends Task.Backgroundable {
        @NotNull
        private DataPack myCurrentDataPack;
        @NotNull
        private final LogInfo myLoadedInfo;

        MyRefreshTask(DataPack currentDataPack) {
            if (currentDataPack == null) {
                MyRefreshTask.$$$reportNull$$$0(0);
            }
            super(VcsLogRefresherImpl.this.myProject, VcsLogBundle.message("vcs.log.refreshing.process", new Object[0]), false);
            this.myLoadedInfo = new LogInfo(VcsLogRefresherImpl.this.myStorage);
            this.myCurrentDataPack = currentDataPack;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyRefreshTask.$$$reportNull$$$0(1);
            }
            LOG.debug("Refresh task started");
            indicator.setIndeterminate(true);
            DataPack dataPack = this.myCurrentDataPack;
            while (true) {
                List<RefreshRequest> requests = VcsLogRefresherImpl.this.mySingleTaskController.popRequests();
                boolean optimize = ContainerUtil.exists(requests, request -> request.myOptimize);
                Collection<VirtualFile> rootsToRefresh = this.getRootsToRefresh(requests);
                LOG.debug("Requests: " + String.valueOf(requests) + ". roots to refresh: " + String.valueOf(rootsToRefresh));
                if (rootsToRefresh.isEmpty()) break;
                try {
                    DataPack smallDataPack;
                    Collection providers = ContainerUtil.filter(VcsLogRefresherImpl.this.myProviders, rootsToRefresh::contains).values();
                    boolean supportsIncrementalRefresh = ContainerUtil.all(providers, provider -> (Boolean)VcsLogProperties.SUPPORTS_INCREMENTAL_REFRESH.getOrDefault(provider));
                    DataPack dataPack2 = smallDataPack = optimize && supportsIncrementalRefresh && MyRefreshTask.isSmallDataPackEnabled() ? this.buildSmallDataPack() : DataPack.EMPTY;
                    if (smallDataPack != DataPack.EMPTY) {
                        VcsLogRefresherImpl.this.myDataPackUpdateHandler.accept(smallDataPack);
                    }
                    dataPack = this.doRefresh(rootsToRefresh, supportsIncrementalRefresh);
                }
                catch (ProcessCanceledException e) {
                    VcsLogRefresherImpl.this.mySingleTaskController.taskCompleted(null);
                    throw e;
                }
            }
            VcsLogRefresherImpl.this.mySingleTaskController.taskCompleted(dataPack);
        }

        private static boolean isSmallDataPackEnabled() {
            return SMALL_DATA_PACK_COMMITS_COUNT > 0 && !ApplicationManager.getApplication().isUnitTestMode();
        }

        @NotNull
        private Collection<VirtualFile> getRootsToRefresh(@NotNull List<? extends RefreshRequest> requests) {
            if (requests == null) {
                MyRefreshTask.$$$reportNull$$$0(2);
            }
            ArrayList<VirtualFile> rootsToRefresh = new ArrayList<VirtualFile>();
            for (RefreshRequest refreshRequest : requests) {
                if (refreshRequest == RefreshRequest.RELOAD_ALL) {
                    this.myCurrentDataPack = DataPack.EMPTY;
                    Set<VirtualFile> set = VcsLogRefresherImpl.this.myProviders.keySet();
                    if (set == null) {
                        MyRefreshTask.$$$reportNull$$$0(3);
                    }
                    return set;
                }
                rootsToRefresh.addAll(refreshRequest.myRootsToRefresh);
            }
            ArrayList<VirtualFile> arrayList = rootsToRefresh;
            if (arrayList == null) {
                MyRefreshTask.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @NotNull
        private DataPack doRefresh(@NotNull Collection<? extends VirtualFile> roots, boolean supportsIncrementalRefresh) {
            DataPack dataPack;
            if (roots == null) {
                MyRefreshTask.$$$reportNull$$$0(5);
            }
            try {
                PermanentGraph<Integer> permanentGraph;
                PermanentGraph<Integer> permanentGraph2 = permanentGraph = this.myCurrentDataPack.isFull() ? this.myCurrentDataPack.getPermanentGraph() : null;
                if (permanentGraph == null || !supportsIncrementalRefresh) {
                    return this.loadFullLog();
                }
                dataPack = (DataPack)TraceUtil.computeWithSpanThrows((SpanBuilder)VcsLogRefresherImpl.this.myTracer.spanBuilder(VcsBackendTelemetrySpan.LogData.Refreshing.getName()), __ -> {
                    Map<VirtualFile, CompressedRefs> currentRefs = this.myCurrentDataPack.getRefsModel().getAllRefsByRoot();
                    int commitCount = VcsLogRefresherImpl.this.myRecentCommitCount;
                    for (int attempt = 0; attempt <= 1; ++attempt) {
                        this.loadLogAndRefs(roots, currentRefs, commitCount);
                        List<GraphCommit<Integer>> compoundLog = VcsLogRefresherImpl.multiRepoJoin(this.myLoadedInfo.getCommits());
                        Map<VirtualFile, CompressedRefs> allNewRefs = MyRefreshTask.getAllNewRefs(this.myLoadedInfo, currentRefs);
                        List<? extends GraphCommit<Integer>> joinedFullLog = this.join(compoundLog, new ArrayList(permanentGraph.getAllCommits()), currentRefs, allNewRefs);
                        if (joinedFullLog != null) {
                            return DataPack.build(joinedFullLog, allNewRefs, VcsLogRefresherImpl.this.myProviders, VcsLogRefresherImpl.this.myStorage, true);
                        }
                        commitCount *= 5;
                    }
                    LOG.info("Couldn't join " + commitCount / 5 + " recent commits to the log (" + permanentGraph.getAllCommits().size() + " commits)");
                    return this.loadFullLog();
                });
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                return new DataPack.ErrorDataPack(e);
            }
            if (dataPack == null) {
                MyRefreshTask.$$$reportNull$$$0(6);
            }
            return dataPack;
        }

        @NotNull
        private static Map<VirtualFile, CompressedRefs> getAllNewRefs(@NotNull LogInfo newInfo, @NotNull Map<VirtualFile, CompressedRefs> previousRefs) {
            if (newInfo == null) {
                MyRefreshTask.$$$reportNull$$$0(7);
            }
            if (previousRefs == null) {
                MyRefreshTask.$$$reportNull$$$0(8);
            }
            HashMap<VirtualFile, CompressedRefs> result = new HashMap<VirtualFile, CompressedRefs>();
            for (VirtualFile root : previousRefs.keySet()) {
                CompressedRefs newInfoRefs = newInfo.getRefs().get(root);
                result.put(root, newInfoRefs != null ? newInfoRefs : previousRefs.get(root));
            }
            HashMap<VirtualFile, CompressedRefs> hashMap = result;
            if (hashMap == null) {
                MyRefreshTask.$$$reportNull$$$0(9);
            }
            return hashMap;
        }

        private void loadLogAndRefs(@NotNull Collection<? extends VirtualFile> roots, @NotNull Map<VirtualFile, CompressedRefs> prevRefs, int commitCount) throws VcsException {
            if (roots == null) {
                MyRefreshTask.$$$reportNull$$$0(10);
            }
            if (prevRefs == null) {
                MyRefreshTask.$$$reportNull$$$0(11);
            }
            LogInfo logInfo = VcsLogRefresherImpl.this.loadRecentData(MyRefreshTask.prepareRequirements(roots, commitCount, prevRefs));
            for (VirtualFile virtualFile : roots) {
                this.myLoadedInfo.put(virtualFile, logInfo.getCommits(virtualFile));
                this.myLoadedInfo.myRefs.put(virtualFile, logInfo.getRefs().get(virtualFile));
            }
        }

        @NotNull
        private static Map<VirtualFile, VcsLogProvider.Requirements> prepareRequirements(@NotNull Collection<? extends VirtualFile> roots, int commitCount, @Nullable Map<VirtualFile, CompressedRefs> prevRefs) {
            if (roots == null) {
                MyRefreshTask.$$$reportNull$$$0(12);
            }
            HashMap<VirtualFile, VcsLogProvider.Requirements> requirements = new HashMap<VirtualFile, VcsLogProvider.Requirements>();
            for (VirtualFile virtualFile : roots) {
                requirements.put(virtualFile, (VcsLogProvider.Requirements)(prevRefs == null ? new RequirementsImpl(commitCount, true, Collections.emptyList(), false) : new RequirementsImpl(commitCount, true, prevRefs.get(virtualFile).getRefs())));
            }
            HashMap<VirtualFile, VcsLogProvider.Requirements> hashMap = requirements;
            if (hashMap == null) {
                MyRefreshTask.$$$reportNull$$$0(13);
            }
            return hashMap;
        }

        @Nullable
        private List<? extends GraphCommit<Integer>> join(@NotNull List<? extends GraphCommit<Integer>> recentCommits, @NotNull List<? extends GraphCommit<Integer>> fullLog, @NotNull Map<VirtualFile, CompressedRefs> previousRefs, @NotNull Map<VirtualFile, CompressedRefs> newRefs) {
            if (recentCommits == null) {
                MyRefreshTask.$$$reportNull$$$0(14);
            }
            if (fullLog == null) {
                MyRefreshTask.$$$reportNull$$$0(15);
            }
            if (previousRefs == null) {
                MyRefreshTask.$$$reportNull$$$0(16);
            }
            if (newRefs == null) {
                MyRefreshTask.$$$reportNull$$$0(17);
            }
            if (fullLog.isEmpty()) {
                return recentCommits;
            }
            return (List)TraceKt.use((SpanBuilder)VcsLogRefresherImpl.this.myTracer.spanBuilder(VcsBackendTelemetrySpan.LogData.JoiningNewAndOldCommits.getName()), span -> {
                Collection prevRefIndices = previousRefs.values().stream().flatMap(refs -> refs.getCommits().stream()).collect(Collectors.toSet());
                Collection newRefIndices = newRefs.values().stream().flatMap(refs -> refs.getCommits().stream()).collect(Collectors.toSet());
                try {
                    return (List)new VcsLogJoiner<CommitId, Commit>().addCommits(fullLog, prevRefIndices, recentCommits, newRefIndices).first;
                }
                catch (VcsLogRefreshNotEnoughDataException e) {
                    LOG.info((Throwable)e);
                }
                catch (IllegalStateException e) {
                    LOG.info((Throwable)e);
                }
                return null;
            });
        }

        @NotNull
        private DataPack loadFullLog() throws VcsException {
            DataPack dataPack = (DataPack)TraceUtil.computeWithSpanThrows((SpanBuilder)VcsLogRefresherImpl.this.myTracer.spanBuilder(VcsBackendTelemetrySpan.LogData.LoadingFullLog.getName()), __ -> {
                LogInfo logInfo = this.readFullLogFromVcs();
                List<GraphCommit<Integer>> graphCommits = VcsLogRefresherImpl.multiRepoJoin(logInfo.getCommits());
                return DataPack.build(graphCommits, logInfo.getRefs(), VcsLogRefresherImpl.this.myProviders, VcsLogRefresherImpl.this.myStorage, true);
            });
            if (dataPack == null) {
                MyRefreshTask.$$$reportNull$$$0(18);
            }
            return dataPack;
        }

        @NotNull
        private LogInfo readFullLogFromVcs() throws VcsException {
            LogInfo logInfo = (LogInfo)TraceUtil.computeWithSpanThrows((SpanBuilder)VcsLogRefresherImpl.this.myTracer.spanBuilder(VcsBackendTelemetrySpan.LogData.ReadingAllCommits.getName()), __ -> {
                LogInfo logInfo = new LogInfo(VcsLogRefresherImpl.this.myStorage);
                for (Map.Entry<VirtualFile, VcsLogProvider> entry : VcsLogRefresherImpl.this.myProviders.entrySet()) {
                    VirtualFile root = entry.getKey();
                    VcsLogProvider provider = entry.getValue();
                    TraceUtil.runWithSpanThrows((SpanBuilder)VcsLogRefresherImpl.this.myTracer.spanBuilder(VcsBackendTelemetrySpan.LogData.ReadingAllCommitsInRoot.getName()).setAttribute("rootName", root.getName()), ignored -> {
                        ArrayList<GraphCommit<Integer>> graphCommits = new ArrayList<GraphCommit<Integer>>();
                        VcsLogProvider.LogData data = provider.readAllHashes(root, commit -> graphCommits.add(VcsLogRefresherImpl.this.compactCommit((TimedVcsCommit)commit, root)));
                        logInfo.put(root, graphCommits);
                        logInfo.put(root, data.getRefs());
                        VcsLogRefresherImpl.this.myUserRegistry.addUsers(data.getUsers());
                    });
                }
                VcsLogRefresherImpl.this.myUserRegistry.flush();
                VcsLogRefresherImpl.this.myIndex.scheduleIndex(true);
                return logInfo;
            });
            if (logInfo == null) {
                MyRefreshTask.$$$reportNull$$$0(19);
            }
            return logInfo;
        }

        @NotNull
        private DataPack buildSmallDataPack() {
            DataPack dataPack = (DataPack)TraceUtil.computeWithSpanThrows((SpanBuilder)VcsLogRefresherImpl.this.myTracer.spanBuilder(VcsBackendTelemetrySpan.LogData.PartialRefreshing.getName()), __ -> {
                try {
                    int commitCount = SMALL_DATA_PACK_COMMITS_COUNT;
                    Map<VirtualFile, VcsLogProvider.Requirements> requirements = MyRefreshTask.prepareRequirements(VcsLogRefresherImpl.this.myProviders.keySet(), commitCount, null);
                    return VcsLogRefresherImpl.this.loadRecentData(requirements, commitCount, true);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                    return DataPack.EMPTY;
                }
            });
            if (dataPack == null) {
                MyRefreshTask.$$$reportNull$$$0(20);
            }
            return dataPack;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 6, 9, 13, 18, 19, 20 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentDataPack";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requests";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 9: 
                case 13: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask";
                    break;
                }
                case 5: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newInfo";
                    break;
                }
                case 8: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previousRefs";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prevRefs";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recentCommits";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullLog";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRefs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootsToRefresh";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doRefresh";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllNewRefs";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareRequirements";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadFullLog";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readFullLogFromVcs";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildSmallDataPack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getRootsToRefresh";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 9: 
                case 13: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "doRefresh";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllNewRefs";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "loadLogAndRefs";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareRequirements";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 6, 9, 13, 18, 19, 20 -> new IllegalStateException(string);
            };
        }
    }

    private class MyInitializationTask
    extends Task.Backgroundable {
        private MyInitializationTask() {
            super(VcsLogRefresherImpl.this.myProject, VcsLogBundle.message("vcs.log.initial.loading.process", new Object[0]), false);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyInitializationTask.$$$reportNull$$$0(0);
            }
            VcsLogRefresherImpl.this.mySingleTaskController.removeRequests(Collections.singletonList(RefreshRequest.INITIALIZE));
            try {
                DataPack result = VcsLogRefresherImpl.this.readFirstBlock();
                VcsLogRefresherImpl.this.mySingleTaskController.taskCompleted(result);
            }
            catch (ProcessCanceledException e) {
                VcsLogRefresherImpl.this.mySingleTaskController.taskCompleted(null);
                throw e;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyInitializationTask", "run"));
        }
    }
}

