/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.requirementsTxt;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.jetbrains.python.packaging.PyPackageRequirementsSettings;
import com.jetbrains.python.packaging.requirementsTxt.PythonRequirementTxtSdkUtils;
import com.jetbrains.python.packaging.utils.PyPackageCoroutine;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/packaging/requirementsTxt/PythonRequirementTxtSdkUtils;", "", "<init>", "()V", "findRequirementsTxt", "Lcom/intellij/openapi/vfs/VirtualFile;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "saveRequirementsTxtPath", "", "project", "Lcom/intellij/openapi/project/Project;", "path", "Ljava/nio/file/Path;", "createRequirementsTxtPath", "module", "Lcom/intellij/openapi/module/Module;", "migrateRequirementsTxtPathFromModuleToSdk", "detectRequirementsTxtInModule", "getRequirementsTxtFromModule", "", "intellij.python.community.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPythonRequirementTxtSdkUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonRequirementTxtSdkUtils.kt\ncom/jetbrains/python/packaging/requirementsTxt/PythonRequirementTxtSdkUtils\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,128:1\n24#2:129\n*S KotlinDebug\n*F\n+ 1 PythonRequirementTxtSdkUtils.kt\ncom/jetbrains/python/packaging/requirementsTxt/PythonRequirementTxtSdkUtils\n*L\n93#1:129\n*E\n"})
public final class PythonRequirementTxtSdkUtils {
    @NotNull
    public static final PythonRequirementTxtSdkUtils INSTANCE = new PythonRequirementTxtSdkUtils();

    private PythonRequirementTxtSdkUtils() {
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile findRequirementsTxt(@NotNull Sdk sdk2) {
        Path requirementsPath;
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        SdkAdditionalData sdkAdditionalData = sdk2.getSdkAdditionalData();
        PythonSdkAdditionalData pythonSdkAdditionalData = sdkAdditionalData instanceof PythonSdkAdditionalData ? (PythonSdkAdditionalData)sdkAdditionalData : null;
        if (pythonSdkAdditionalData == null) {
            return null;
        }
        PythonSdkAdditionalData data = pythonSdkAdditionalData;
        Path path2 = data.getRequiredTxtPath();
        if (path2 == null) {
            path2 = Path.of("requirements.txt", new String[0]);
        }
        if ((requirementsPath = path2).isAbsolute()) {
            return VirtualFileManager.getInstance().findFileByNioPath(requirementsPath);
        }
        VirtualFile virtualFile = PySdkExtKt.getAssociatedModuleDir(sdk2);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile associatedModuleFile = virtualFile;
        return associatedModuleFile.findFileByRelativePath(((Object)requirementsPath).toString());
    }

    @JvmStatic
    public static final void saveRequirementsTxtPath(@NotNull Project project, @NotNull Sdk sdk2, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        SdkModificator sdkModificator = sdk2.getSdkModificator();
        Intrinsics.checkNotNullExpressionValue((Object)sdkModificator, (String)"getSdkModificator(...)");
        SdkModificator sdkModificator2 = sdkModificator;
        SdkAdditionalData sdkAdditionalData = sdkModificator2.getSdkAdditionalData();
        PythonSdkAdditionalData pythonSdkAdditionalData = sdkAdditionalData instanceof PythonSdkAdditionalData ? (PythonSdkAdditionalData)sdkAdditionalData : null;
        if (pythonSdkAdditionalData == null) {
            return;
        }
        PythonSdkAdditionalData modifiedData = pythonSdkAdditionalData;
        Path associatedModulePath = PySdkExtKt.getAssociatedModuleNioPath(sdk2);
        Path realPath = path2.isAbsolute() && associatedModulePath != null && path2.startsWith(associatedModulePath) ? associatedModulePath.relativize(path2) : path2;
        modifiedData.setRequiredTxtPath(realPath);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ActionsKt.runWriteAction(() -> PythonRequirementTxtSdkUtils.saveRequirementsTxtPath$lambda$0(sdkModificator2));
        } else {
            PyPackageCoroutine.Companion.launch$default(PyPackageCoroutine.Companion, project, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(sdkModificator2, null){
                int label;
                final /* synthetic */ SdkModificator $sdkModificator;
                {
                    this.$sdkModificator = $sdkModificator;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = CoroutinesKt.writeAction(() -> saveRequirementsTxtPath.2.invokeSuspend$lambda$0(this.$sdkModificator), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Unit invokeSuspend$lambda$0(SdkModificator $sdkModificator) {
                    $sdkModificator.commitChanges();
                    return Unit.INSTANCE;
                }
            }, 2, null);
        }
    }

    @Nullable
    public final VirtualFile createRequirementsTxtPath(@NotNull Module module2, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        VirtualFile virtualFile = PySdkExtKt.getAssociatedModuleDir(sdk2);
        if (virtualFile == null && (virtualFile = BasePySdkExtKt.getBaseDir(module2)) == null) {
            return null;
        }
        VirtualFile basePathString = virtualFile;
        VirtualFile requirementsFile = VirtualFileUtil.findOrCreateFile((VirtualFile)basePathString, (String)"requirements.txt");
        Path path2 = VirtualFileUtil.toNioPathOrNull((VirtualFile)requirementsFile);
        if (path2 == null) {
            path2 = Path.of(requirementsFile.getPath(), new String[0]);
        }
        Path requirementFilePath = path2;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Intrinsics.checkNotNull((Object)requirementFilePath);
        PythonRequirementTxtSdkUtils.saveRequirementsTxtPath(project, sdk2, requirementFilePath);
        return requirementsFile;
    }

    public final void migrateRequirementsTxtPathFromModuleToSdk(@NotNull Project project, @NotNull Sdk sdk2) {
        Path path2;
        String string;
        block7: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
            SdkAdditionalData sdkAdditionalData = sdk2.getSdkAdditionalData();
            PythonSdkAdditionalData pythonSdkAdditionalData = sdkAdditionalData instanceof PythonSdkAdditionalData ? (PythonSdkAdditionalData)sdkAdditionalData : null;
            if (pythonSdkAdditionalData == null) {
                return;
            }
            PythonSdkAdditionalData sdkAdditionalData2 = pythonSdkAdditionalData;
            Path newPath = sdkAdditionalData2.getRequiredTxtPath();
            if (newPath != null) {
                return;
            }
            for (Module it : ProjectUtil.getModules((Project)project)) {
                boolean bl = false;
                string = INSTANCE.getRequirementsTxtFromModule(it);
                if (string == null) {
                    continue;
                }
                break block7;
            }
            string = null;
        }
        if (string == null) {
            return;
        }
        String originalPath = string;
        try {
            path2 = Path.of(originalPath, new String[0]);
        }
        catch (Throwable t) {
            PythonRequirementTxtSdkUtils $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PythonRequirementTxtSdkUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(t);
            return;
        }
        Path path22 = path2;
        Intrinsics.checkNotNull((Object)path22);
        PythonRequirementTxtSdkUtils.saveRequirementsTxtPath(project, sdk2, path22);
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile detectRequirementsTxtInModule(@NotNull Module module2) {
        VirtualFile virtualFile;
        block2: {
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            VirtualFile[] virtualFileArray = BasePySdkExtKt.getRootManager(module2).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            Object[] objectArray = virtualFileArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile it = (VirtualFile)objectArray[i];
                boolean bl = false;
                virtualFile = it.findChild("requirements.txt");
                if (virtualFile == null) {
                    continue;
                }
                break block2;
            }
            virtualFile = null;
        }
        VirtualFile requirementsPath = virtualFile;
        return requirementsPath;
    }

    private final String getRequirementsTxtFromModule(Module module2) {
        PyPackageRequirementsSettings pyPackageRequirementsSettings = PyPackageRequirementsSettings.getInstance(module2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)pyPackageRequirementsSettings), (String)"getInstance(...)");
        PyPackageRequirementsSettings settings = pyPackageRequirementsSettings;
        if (PySdkExtKt.getPythonSdk(module2) == null) {
            return null;
        }
        String string = ((PyPackageRequirementsSettings.ServiceState)settings.getState()).myRequirementsPath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myRequirementsPath");
        String requirementsPath = string;
        return !StringsKt.isBlank((CharSequence)requirementsPath) && !Intrinsics.areEqual((Object)requirementsPath, (Object)"requirements.txt") ? requirementsPath : null;
    }

    private static final Unit saveRequirementsTxtPath$lambda$0(SdkModificator $sdkModificator) {
        $sdkModificator.commitChanges();
        return Unit.INSTANCE;
    }
}

