/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.diagnostics;

import com.intellij.util.SmartList;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.diagnostics.UpdateOp;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ValueContainerImplWithChecks<V>
extends ValueContainerImpl<V> {
    private Int2ObjectMap<Object> presentInputIds = new Int2ObjectOpenHashMap<Object>();
    private List<UpdateOp> updateOps = new SmartList<UpdateOp>();

    @Override
    @NotNull
    protected String getDebugMessage() {
        String string = "Actual value container = \n" + this + (this.presentInputIds == null ? "" : "\nExpected value container = " + this.presentInputIds) + (this.updateOps == null ? "" : "\nUpdate operations = " + this.updateOps);
        if (string == null) {
            ValueContainerImplWithChecks.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public ValueContainerImpl<V> clone() {
        ValueContainerImplWithChecks clone = (ValueContainerImplWithChecks)super.clone();
        clone.presentInputIds = new Int2ObjectOpenHashMap<Object>(this.presentInputIds);
        clone.updateOps = new SmartList<UpdateOp>((Collection<UpdateOp>)this.updateOps);
        return clone;
    }

    @Override
    protected void ensureInputIdIsntAssociatedWithAnotherValue(int inputId, Object value, boolean isDirect) {
        Object normalizedValue = ValueContainerImplWithChecks.wrapValue(value);
        Object previousValue = this.presentInputIds.put(inputId, normalizedValue);
        this.updateOps.add(new UpdateOp(isDirect ? UpdateOp.Type.ADD_DIRECT : UpdateOp.Type.ADD, inputId, normalizedValue));
        if (previousValue != null && !previousValue.equals(normalizedValue)) {
            LOG.error("Can't add value '" + normalizedValue + "'; input id " + inputId + " is already present in:\n" + this.getDebugMessage());
        }
    }

    @Override
    protected void ensureInputIdAssociatedWithValue(int inputId, Object value) {
        Object normalizedValue = ValueContainerImplWithChecks.wrapValue(value);
        Object previousValue = this.presentInputIds.remove(inputId);
        this.updateOps.add(new UpdateOp(UpdateOp.Type.REMOVE, inputId, normalizedValue));
        if (previousValue != null && !previousValue.equals(normalizedValue)) {
            LOG.error("Can't remove value '" + normalizedValue + "'; input id " + inputId + " is not present for the specified value in:\n" + this.getDebugMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/diagnostics/ValueContainerImplWithChecks", "getDebugMessage"));
    }
}

