/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.security.bearerauth.oauth;

import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OauthTokenCache {
    public static final float CACHE_EXPIRY_THRESHOLD = 0.8f;
    private static final Logger log = LoggerFactory.getLogger(OauthTokenCache.class);
    private final short cacheExpiryBufferSeconds;
    private OAuthBearerToken currentToken;
    private long cacheExpiryMs = 0L;

    public OauthTokenCache(short cacheExpiryBufferSeconds) {
        this.cacheExpiryBufferSeconds = cacheExpiryBufferSeconds;
    }

    public OAuthBearerToken getCurrentToken() {
        return this.currentToken;
    }

    public void setCurrentToken(OAuthBearerToken currentToken) {
        if (currentToken == null) {
            this.cacheExpiryMs = 0L;
            return;
        }
        this.cacheExpiryMs = this.calculateTokenExpiryTime(currentToken);
        this.currentToken = currentToken;
    }

    protected long calculateTokenExpiryTime(OAuthBearerToken currentToken) {
        long tokenExpiryMs;
        long nowMs = Instant.now().toEpochMilli();
        if (nowMs > (tokenExpiryMs = currentToken.lifetimeMs())) {
            log.warn("Schema Registry OAuth Token [Principal={}]: Current clock: {} is later than expiry {}. This may indicate a clock skew problem. Check that this host's and remote host's clocks are in sync. This process is likely unable to authenticate SASL connections (for example, it is unlikely to be able to authenticate a connection with a Schema Registry).", new Object[]{currentToken.principalName(), new Date(nowMs), new Date(tokenExpiryMs)});
            return tokenExpiryMs;
        }
        Long optionalStartTime = currentToken.startTimeMs();
        long startMs = optionalStartTime != null ? optionalStartTime : nowMs;
        long cacheExpiryBufferMs = TimeUnit.MILLISECONDS.convert(this.cacheExpiryBufferSeconds, TimeUnit.SECONDS);
        if (nowMs + cacheExpiryBufferMs > tokenExpiryMs) {
            long cacheExpiryMs = nowMs + (long)Math.floor((float)(tokenExpiryMs - nowMs) * 0.8f);
            log.warn("Schema Registry OAuth Token [Principal={}]: OAuth token expires at {}, so buffer times {} seconds cannot be accommodated.  OAuth token cache expires at {}.", new Object[]{currentToken.principalName(), new Date(tokenExpiryMs), this.cacheExpiryBufferSeconds, cacheExpiryMs});
            return cacheExpiryMs;
        }
        long cacheExpiryMs = startMs + (long)((float)(tokenExpiryMs - startMs) * 0.8f);
        long beginningOfEndBufferTimeMs = tokenExpiryMs - cacheExpiryBufferMs;
        if (cacheExpiryMs > beginningOfEndBufferTimeMs) {
            log.info("Schema Registry OAuth Token [Principal={}]: Proposed token Cache expiry time of {} extends into the desired buffer time of {} seconds before token expiration, so invalidate token cache at the desired buffer begin point, at {}", new Object[]{currentToken.principalName(), new Date(cacheExpiryMs), this.cacheExpiryBufferSeconds, new Date(beginningOfEndBufferTimeMs)});
            return beginningOfEndBufferTimeMs;
        }
        return cacheExpiryMs;
    }

    public boolean isTokenExpired() {
        return Instant.now().toEpochMilli() >= this.cacheExpiryMs;
    }
}

