/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.preferences.server.UserNameValidator;
import org.openstreetmap.josm.gui.widgets.JosmPasswordField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class BasicAuthenticationPreferencesPanel
extends JPanel {
    private final JosmTextField tfOsmUserName = new JosmTextField();
    private final JosmPasswordField tfOsmPassword = new JosmPasswordField();
    private JPanel decorationPanel;

    public BasicAuthenticationPreferencesPanel() {
        this.build();
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.anchor = 18;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 3, 3);
        this.add((Component)new JLabel(I18n.tr("OSM username:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)this.tfOsmUserName, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfOsmUserName);
        UserNameValidator valUserName = new UserNameValidator(this.tfOsmUserName);
        valUserName.validate();
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("OSM password:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)this.tfOsmPassword, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfOsmPassword);
        this.tfOsmPassword.setToolTipText(I18n.tr("Please enter your OSM password", new Object[0]));
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.insets = new Insets(5, 0, 0, 0);
        gc.fill = 1;
        this.decorationPanel = new JPanel(new BorderLayout());
        this.add((Component)this.decorationPanel, gc);
    }

    public void initFromPreferences() {
        CredentialsManager cm = CredentialsManager.getInstance();
        try {
            this.decorationPanel.removeAll();
            this.decorationPanel.add(cm.getPreferencesDecorationPanel(), "Center");
            PasswordAuthentication pa = cm.lookup(Authenticator.RequestorType.SERVER, OsmApi.getOsmApi().getHost());
            if (pa == null) {
                this.tfOsmUserName.setText("");
                this.tfOsmPassword.setText("");
            } else {
                this.tfOsmUserName.setText(pa.getUserName() == null ? "" : pa.getUserName());
                this.tfOsmPassword.setText(pa.getPassword() == null ? "" : String.valueOf(pa.getPassword()));
            }
        }
        catch (CredentialsAgentException e) {
            Logging.error(e);
            Logging.warn(I18n.tr("Failed to retrieve OSM credentials from credential manager.", new Object[0]));
            Logging.warn(I18n.tr("Current credential manager is of type ''{0}''", cm.getClass().getName()));
            this.tfOsmUserName.setText("");
            this.tfOsmPassword.setText("");
        }
    }

    public void saveToPreferences() {
        CredentialsManager cm = CredentialsManager.getInstance();
        try {
            PasswordAuthentication pa = new PasswordAuthentication(this.tfOsmUserName.getText().trim(), this.tfOsmPassword.getPassword());
            cm.store(Authenticator.RequestorType.SERVER, OsmApi.getOsmApi().getHost(), pa);
        }
        catch (CredentialsAgentException e) {
            Logging.error(e);
            Logging.warn(I18n.tr("Failed to save OSM credentials to credential manager.", new Object[0]));
            Logging.warn(I18n.tr("Current credential manager is of type ''{0}''", cm.getClass().getName()));
        }
    }

    public void clearPassword() {
        this.tfOsmPassword.setText("");
    }
}

