/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven.repo;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;

public interface MavenRepoManager
extends RepositoryArtifactResolver {
    public static final String REPOSITORY_ID = "repository.maven";

    @Override
    default public String getRepositoryId() {
        return REPOSITORY_ID;
    }

    @Override
    default public Path resolve(String location) throws ProvisioningException {
        MavenArtifact artifact = MavenArtifact.fromString(location);
        this.resolve(artifact);
        return artifact.getPath();
    }

    public void resolve(MavenArtifact var1) throws MavenUniverseException;

    default public void resolveAll(Collection<MavenArtifact> artifacts) throws MavenUniverseException {
        for (MavenArtifact artifact : artifacts) {
            this.resolve(artifact);
        }
    }

    public boolean isResolved(MavenArtifact var1) throws MavenUniverseException;

    public boolean isLatestVersionResolved(MavenArtifact var1, String var2) throws MavenUniverseException;

    default public void resolveLatestVersion(MavenArtifact artifact) throws MavenUniverseException {
        this.resolveLatestVersion(artifact, false);
    }

    default public void resolveLatestVersion(MavenArtifact artifact, boolean locallyAvailable) throws MavenUniverseException {
        this.resolveLatestVersion(artifact, null, locallyAvailable);
    }

    default public void resolveLatestVersion(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        this.resolveLatestVersion(artifact, lowestQualifier, false);
    }

    public void resolveLatestVersion(MavenArtifact var1, String var2, Pattern var3, Pattern var4) throws MavenUniverseException;

    public void resolveLatestVersion(MavenArtifact var1, String var2, boolean var3) throws MavenUniverseException;

    default public String getLatestFinalVersion(MavenArtifact artifact) throws MavenUniverseException {
        return this.getLatestVersion(artifact, null);
    }

    public String getLatestVersion(MavenArtifact var1) throws MavenUniverseException;

    public String getLatestVersion(MavenArtifact var1, String var2) throws MavenUniverseException;

    public String getLatestVersion(MavenArtifact var1, String var2, Pattern var3, Pattern var4) throws MavenUniverseException;

    public List<String> getAllVersions(MavenArtifact var1) throws MavenUniverseException;

    public List<String> getAllVersions(MavenArtifact var1, Pattern var2, Pattern var3) throws MavenUniverseException;

    public void install(MavenArtifact var1, Path var2) throws MavenUniverseException;
}

