/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.examples;

import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;

public class SpellCheckExample
implements SpellCheckListener {
    private static String dictFile = "dict/english.0";
    private static String phonetFile = "dict/phonet.en";
    private SpellChecker spellCheck = null;

    public SpellCheckExample() {
        try {
            SpellDictionaryHashMap spellDictionaryHashMap = new SpellDictionaryHashMap(new File(dictFile), new File(phonetFile));
            this.spellCheck = new SpellChecker(spellDictionaryHashMap);
            this.spellCheck.addSpellCheckListener(this);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                System.out.print("Enter text to spell check: ");
                String string = bufferedReader.readLine();
                if (string.length() > 0) {
                    this.spellCheck.checkSpelling(new StringWordTokenizer(string));
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void spellingError(SpellCheckEvent spellCheckEvent) {
        List list = spellCheckEvent.getSuggestions();
        if (list.size() > 0) {
            System.out.println("MISSPELT WORD: " + spellCheckEvent.getInvalidWord());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                System.out.println("\tSuggested Word: " + iterator.next());
            }
        } else {
            System.out.println("MISSPELT WORD: " + spellCheckEvent.getInvalidWord());
            System.out.println("\tNo suggestions");
        }
    }

    public static void main(String[] stringArray) {
        new SpellCheckExample();
    }
}

