/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.checkin;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.GenericKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkCheckMap {
    private final Map<ArtifactInfo, Boolean> myMap;
    private final List<Runnable> myListeners = new ArrayList<Runnable>();
    private static final Comparator<ArtifactInfo> myComparator = new Comparator<ArtifactInfo>(){

        @Override
        public int compare(ArtifactInfo o1, ArtifactInfo o2) {
            String id2;
            String id1 = (String)o1.getPresentation(GenericKeys.ID);
            if (id1 == null ^ (id2 = (String)o2.getPresentation(GenericKeys.ID)) == null) {
                return id1 != null ? 1 : -1;
            }
            return GenericKeys.ID.getComparator().compare(id1, id2);
        }
    };

    public LinkCheckMap() {
        this.myMap = new TreeMap<ArtifactInfo, Boolean>(myComparator);
    }

    public boolean isSelected(ArtifactInfo info) {
        Boolean value = this.myMap.get(info);
        if (value == null) {
            return false;
        }
        return value;
    }

    public List<ArtifactInfo> getSelectedInfos() {
        ArrayList<ArtifactInfo> result = new ArrayList<ArtifactInfo>();
        Set<ArtifactInfo> infos = this.myMap.keySet();
        for (ArtifactInfo info : infos) {
            if (!this.isSelected(info)) continue;
            result.add(info);
        }
        return result;
    }

    public void setSelected(Collection<ArtifactInfo> infos, boolean selected) {
        HashMap<ArtifactInfo, Boolean> tmp = new HashMap<ArtifactInfo, Boolean>(infos.size());
        for (ArtifactInfo info : infos) {
            tmp.put(info, selected);
        }
        this.myMap.putAll(tmp);
        this.fireUpdate();
    }

    public void setSelected(ArtifactInfo item, boolean selected) {
        this.myMap.put(item, selected);
        this.fireUpdate();
    }

    private void fireUpdate() {
        for (Runnable runnable : this.myListeners) {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void addListener(Runnable runnable) {
        this.myListeners.add(runnable);
    }

    public void removeListener(Runnable runnable) {
        this.myListeners.remove(runnable);
    }
}

