/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.locks;

import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.view.JFRViewTab;
import org.graalvm.visualvm.jfr.views.locks.JFRSnapshotLocksViewProvider;
import org.graalvm.visualvm.jfr.views.locks.LocksNode;
import org.graalvm.visualvm.jfr.views.locks.LocksViewSupport;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.openide.util.RequestProcessor;

final class JFRSnapshotLocksView
extends JFRViewTab {
    private DataViewComponent dvc;
    private LocksViewSupport.MasterViewSupport masterView;
    private LocksViewSupport.DataViewSupport dataView;

    JFRSnapshotLocksView(JFRSnapshot jfrSnapshot) {
        super(jfrSnapshot, "Locks", Icons.getImage((String)"ProfilerIcons.WindowLocks"), 32);
    }

    @Override
    protected DataViewComponent createComponent() {
        JFRModel model = this.getModel();
        this.masterView = new LocksViewSupport.MasterViewSupport(model){

            @Override
            void firstShown() {
                this.changeAggregation(0, LocksViewSupport.Aggregation.CLASS, LocksViewSupport.Aggregation.NONE);
            }

            @Override
            void changeAggregation(int mode, LocksViewSupport.Aggregation primary, LocksViewSupport.Aggregation secondary) {
                JFRSnapshotLocksView.this.setAggregation(mode, primary, secondary);
            }
        };
        boolean hasEvents = model != null && model.containsEvent(JFRSnapshotLocksViewProvider.EventChecker.class);
        this.dvc = new DataViewComponent(this.masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(!hasEvents));
        if (hasEvents) {
            this.dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration("Data", false), 1);
            this.dataView = new LocksViewSupport.DataViewSupport();
            this.dvc.addDetailsView(this.dataView.getDetailsView(), 1);
        }
        return this.dvc;
    }

    private void setAggregation(final int mode, final LocksViewSupport.Aggregation primary, final LocksViewSupport.Aggregation secondary) {
        this.masterView.showProgress();
        this.dataView.setData(new LocksNode.Root(), false);
        new RequestProcessor("JFR Locks Initializer").post(new Runnable(){

            @Override
            public void run() {
                final LocksNode.Root root = new LocksNode.Root(mode, primary, secondary);
                JFRSnapshotLocksView.this.getModel().visitEvents(root);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (root.getNChildren() == 0) {
                            root.addChild(LocksNode.Label.createNoData(root));
                        }
                        JFRSnapshotLocksView.this.dataView.setData(root, !LocksViewSupport.Aggregation.NONE.equals((Object)secondary));
                        JFRSnapshotLocksView.this.masterView.hideProgress();
                    }
                });
            }
        });
    }
}

