/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableScalarXMap;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableConcatMap<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int prefetch;
    final ErrorMode errorMode;

    public FlowableConcatMap(Flowable<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
        super(source);
        this.mapper = mapper;
        this.prefetch = prefetch;
        this.errorMode = errorMode;
    }

    public static <T, R> Subscriber<T> subscribe(Subscriber<? super R> s, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
        switch (errorMode) {
            case BOUNDARY: {
                return new ConcatMapDelayed<T, R>(s, mapper, prefetch, false);
            }
            case END: {
                return new ConcatMapDelayed<T, R>(s, mapper, prefetch, true);
            }
        }
        return new ConcatMapImmediate<T, R>(s, mapper, prefetch);
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        if (FlowableScalarXMap.tryScalarXMapSubscribe(this.source, s, this.mapper)) {
            return;
        }
        this.source.subscribe(FlowableConcatMap.subscribe(s, this.mapper, this.prefetch, this.errorMode));
    }

    static final class ConcatMapInner<R>
    extends SubscriptionArbiter
    implements FlowableSubscriber<R> {
        private static final long serialVersionUID = 897683679971470653L;
        final ConcatMapSupport<R> parent;
        long produced;

        ConcatMapInner(ConcatMapSupport<R> parent) {
            super(false);
            this.parent = parent;
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.setSubscription(s);
        }

        public void onNext(R t) {
            ++this.produced;
            this.parent.innerNext(t);
        }

        public void onError(Throwable t) {
            long p = this.produced;
            if (p != 0L) {
                this.produced = 0L;
                this.produced(p);
            }
            this.parent.innerError(t);
        }

        public void onComplete() {
            long p = this.produced;
            if (p != 0L) {
                this.produced = 0L;
                this.produced(p);
            }
            this.parent.innerComplete();
        }
    }

    static interface ConcatMapSupport<T> {
        public void innerNext(T var1);

        public void innerComplete();

        public void innerError(Throwable var1);
    }

    static final class ConcatMapDelayed<T, R>
    extends BaseConcatMapSubscriber<T, R> {
        private static final long serialVersionUID = -2945777694260521066L;
        final Subscriber<? super R> downstream;
        final boolean veryEnd;

        ConcatMapDelayed(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, boolean veryEnd) {
            super(mapper, prefetch);
            this.downstream = actual;
            this.veryEnd = veryEnd;
        }

        @Override
        void subscribeActual() {
            this.downstream.onSubscribe((Subscription)this);
        }

        public void onError(Throwable t) {
            if (this.errors.addThrowable(t)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void innerNext(R value) {
            this.downstream.onNext(value);
        }

        @Override
        public void innerError(Throwable e) {
            if (this.errors.addThrowable(e)) {
                if (!this.veryEnd) {
                    this.upstream.cancel();
                    this.done = true;
                }
                this.active = false;
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        public void request(long n) {
            this.inner.request(n);
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.inner.cancel();
                this.upstream.cancel();
            }
        }

        @Override
        void drain() {
            block21: {
                if (this.getAndIncrement() != 0) break block21;
                while (true) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.active) {
                        boolean empty;
                        Object v;
                        Throwable ex;
                        boolean d = this.done;
                        if (d && !this.veryEnd && (ex = (Throwable)this.errors.get()) != null) {
                            this.downstream.onError(this.errors.terminate());
                            return;
                        }
                        try {
                            v = this.queue.poll();
                        }
                        catch (Throwable e) {
                            Exceptions.throwIfFatal(e);
                            this.upstream.cancel();
                            this.errors.addThrowable(e);
                            this.downstream.onError(this.errors.terminate());
                            return;
                        }
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            Throwable ex2 = this.errors.terminate();
                            if (ex2 != null) {
                                this.downstream.onError(ex2);
                            } else {
                                this.downstream.onComplete();
                            }
                            return;
                        }
                        if (!empty) {
                            Publisher p;
                            try {
                                p = (Publisher)ObjectHelper.requireNonNull(this.mapper.apply(v), "The mapper returned a null Publisher");
                            }
                            catch (Throwable e) {
                                Exceptions.throwIfFatal(e);
                                this.upstream.cancel();
                                this.errors.addThrowable(e);
                                this.downstream.onError(this.errors.terminate());
                                return;
                            }
                            if (this.sourceMode != 1) {
                                int c = this.consumed + 1;
                                if (c == this.limit) {
                                    this.consumed = 0;
                                    this.upstream.request((long)c);
                                } else {
                                    this.consumed = c;
                                }
                            }
                            if (p instanceof Callable) {
                                Object vr;
                                Callable supplier = (Callable)p;
                                try {
                                    vr = supplier.call();
                                }
                                catch (Throwable e) {
                                    Exceptions.throwIfFatal(e);
                                    this.errors.addThrowable(e);
                                    if (!this.veryEnd) {
                                        this.upstream.cancel();
                                        this.downstream.onError(this.errors.terminate());
                                        return;
                                    }
                                    vr = null;
                                }
                                if (vr == null) continue;
                                if (this.inner.isUnbounded()) {
                                    this.downstream.onNext(vr);
                                    continue;
                                }
                                this.active = true;
                                this.inner.setSubscription(new SimpleScalarSubscription(vr, this.inner));
                            } else {
                                this.active = true;
                                p.subscribe((Subscriber)this.inner);
                            }
                        }
                    }
                    if (this.decrementAndGet() == 0) break;
                }
            }
        }
    }

    static final class SimpleScalarSubscription<T>
    extends AtomicBoolean
    implements Subscription {
        final Subscriber<? super T> downstream;
        final T value;

        SimpleScalarSubscription(T value, Subscriber<? super T> downstream) {
            this.value = value;
            this.downstream = downstream;
        }

        public void request(long n) {
            if (n > 0L && this.compareAndSet(false, true)) {
                Subscriber<? super T> a = this.downstream;
                a.onNext(this.value);
                a.onComplete();
            }
        }

        public void cancel() {
        }
    }

    static final class ConcatMapImmediate<T, R>
    extends BaseConcatMapSubscriber<T, R> {
        private static final long serialVersionUID = 7898995095634264146L;
        final Subscriber<? super R> downstream;
        final AtomicInteger wip;

        ConcatMapImmediate(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch) {
            super(mapper, prefetch);
            this.downstream = actual;
            this.wip = new AtomicInteger();
        }

        @Override
        void subscribeActual() {
            this.downstream.onSubscribe((Subscription)this);
        }

        public void onError(Throwable t) {
            if (this.errors.addThrowable(t)) {
                this.inner.cancel();
                if (this.getAndIncrement() == 0) {
                    this.downstream.onError(this.errors.terminate());
                }
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void innerNext(R value) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.downstream.onNext(value);
                if (this.compareAndSet(1, 0)) {
                    return;
                }
                this.downstream.onError(this.errors.terminate());
            }
        }

        @Override
        public void innerError(Throwable e) {
            if (this.errors.addThrowable(e)) {
                this.upstream.cancel();
                if (this.getAndIncrement() == 0) {
                    this.downstream.onError(this.errors.terminate());
                }
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        public void request(long n) {
            this.inner.request(n);
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.inner.cancel();
                this.upstream.cancel();
            }
        }

        @Override
        void drain() {
            block17: {
                if (this.wip.getAndIncrement() != 0) break block17;
                while (true) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.active) {
                        boolean empty;
                        Object v;
                        boolean d = this.done;
                        try {
                            v = this.queue.poll();
                        }
                        catch (Throwable e) {
                            Exceptions.throwIfFatal(e);
                            this.upstream.cancel();
                            this.errors.addThrowable(e);
                            this.downstream.onError(this.errors.terminate());
                            return;
                        }
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            this.downstream.onComplete();
                            return;
                        }
                        if (!empty) {
                            Publisher p;
                            try {
                                p = (Publisher)ObjectHelper.requireNonNull(this.mapper.apply(v), "The mapper returned a null Publisher");
                            }
                            catch (Throwable e) {
                                Exceptions.throwIfFatal(e);
                                this.upstream.cancel();
                                this.errors.addThrowable(e);
                                this.downstream.onError(this.errors.terminate());
                                return;
                            }
                            if (this.sourceMode != 1) {
                                int c = this.consumed + 1;
                                if (c == this.limit) {
                                    this.consumed = 0;
                                    this.upstream.request((long)c);
                                } else {
                                    this.consumed = c;
                                }
                            }
                            if (p instanceof Callable) {
                                Object vr;
                                Callable callable = (Callable)p;
                                try {
                                    vr = callable.call();
                                }
                                catch (Throwable e) {
                                    Exceptions.throwIfFatal(e);
                                    this.upstream.cancel();
                                    this.errors.addThrowable(e);
                                    this.downstream.onError(this.errors.terminate());
                                    return;
                                }
                                if (vr == null) continue;
                                if (this.inner.isUnbounded()) {
                                    if (this.get() != 0 || !this.compareAndSet(0, 1)) continue;
                                    this.downstream.onNext(vr);
                                    if (this.compareAndSet(1, 0)) continue;
                                    this.downstream.onError(this.errors.terminate());
                                    return;
                                }
                                this.active = true;
                                this.inner.setSubscription(new SimpleScalarSubscription(vr, this.inner));
                            } else {
                                this.active = true;
                                p.subscribe((Subscriber)this.inner);
                            }
                        }
                    }
                    if (this.wip.decrementAndGet() == 0) break;
                }
            }
        }
    }

    static abstract class BaseConcatMapSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    ConcatMapSupport<R>,
    Subscription {
        private static final long serialVersionUID = -3511336836796789179L;
        final ConcatMapInner<R> inner;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final int prefetch;
        final int limit;
        Subscription upstream;
        int consumed;
        SimpleQueue<T> queue;
        volatile boolean done;
        volatile boolean cancelled;
        final AtomicThrowable errors;
        volatile boolean active;
        int sourceMode;

        BaseConcatMapSubscriber(Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch) {
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.inner = new ConcatMapInner(this);
            this.errors = new AtomicThrowable();
        }

        @Override
        public final void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                if (s instanceof QueueSubscription) {
                    QueueSubscription f = (QueueSubscription)s;
                    int m = f.requestFusion(7);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = f;
                        this.done = true;
                        this.subscribeActual();
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = f;
                        this.subscribeActual();
                        s.request((long)this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.subscribeActual();
                s.request((long)this.prefetch);
            }
        }

        abstract void drain();

        abstract void subscribeActual();

        public final void onNext(T t) {
            if (this.sourceMode != 2 && !this.queue.offer(t)) {
                this.upstream.cancel();
                this.onError(new IllegalStateException("Queue full?!"));
                return;
            }
            this.drain();
        }

        public final void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public final void innerComplete() {
            this.active = false;
            this.drain();
        }
    }
}

