/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import jakarta.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.helper.model.PositionUtil;
import org.traccar.model.Device;
import org.traccar.model.Geofence;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;
import org.traccar.session.state.OverspeedProcessor;
import org.traccar.session.state.OverspeedState;
import org.traccar.storage.Storage;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public class OverspeedEventHandler
extends BaseEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OverspeedEventHandler.class);
    private final CacheManager cacheManager;
    private final Storage storage;
    private final long minimalDuration;
    private final boolean preferLowest;
    private final double multiplier;

    @Inject
    public OverspeedEventHandler(Config config, CacheManager cacheManager, Storage storage) {
        this.cacheManager = cacheManager;
        this.storage = storage;
        this.minimalDuration = config.getLong(Keys.EVENT_OVERSPEED_MINIMAL_DURATION) * 1000L;
        this.preferLowest = config.getBoolean(Keys.EVENT_OVERSPEED_PREFER_LOWEST);
        this.multiplier = config.getDouble(Keys.EVENT_OVERSPEED_THRESHOLD_MULTIPLIER);
    }

    @Override
    public void onPosition(Position position, BaseEventHandler.Callback callback) {
        long deviceId = position.getDeviceId();
        Device device = this.cacheManager.getObject(Device.class, position.getDeviceId());
        if (device == null) {
            return;
        }
        if (!PositionUtil.isLatest(this.cacheManager, position) || !position.getValid()) {
            return;
        }
        double speedLimit = AttributeUtil.lookup(this.cacheManager, Keys.EVENT_OVERSPEED_LIMIT, deviceId);
        double positionSpeedLimit = position.getDouble("speedLimit");
        if (positionSpeedLimit > 0.0) {
            speedLimit = positionSpeedLimit;
        }
        double geofenceSpeedLimit = 0.0;
        long overspeedGeofenceId = 0L;
        if (position.getGeofenceIds() != null) {
            for (long geofenceId : position.getGeofenceIds()) {
                double currentSpeedLimit;
                Geofence geofence = this.cacheManager.getObject(Geofence.class, geofenceId);
                if (geofence == null || !((currentSpeedLimit = geofence.getDouble(Keys.EVENT_OVERSPEED_LIMIT.getKey())) > 0.0 && geofenceSpeedLimit == 0.0 || this.preferLowest && currentSpeedLimit < geofenceSpeedLimit) && (this.preferLowest || !(currentSpeedLimit > geofenceSpeedLimit))) continue;
                geofenceSpeedLimit = currentSpeedLimit;
                overspeedGeofenceId = geofenceId;
            }
        }
        if (geofenceSpeedLimit > 0.0) {
            speedLimit = geofenceSpeedLimit;
        }
        if (speedLimit == 0.0) {
            return;
        }
        OverspeedState state = OverspeedState.fromDevice(device);
        OverspeedProcessor.updateState(state, position, speedLimit, this.multiplier, this.minimalDuration, overspeedGeofenceId);
        if (state.isChanged()) {
            state.toDevice(device);
            try {
                this.storage.updateObject(device, new Request((Columns)new Columns.Include("overspeedState", "overspeedTime", "overspeedGeofenceId"), new Condition.Equals("id", device.getId())));
            }
            catch (StorageException e) {
                LOGGER.warn("Update device overspeed error", (Throwable)e);
            }
        }
        if (state.getEvent() != null) {
            callback.eventDetected(state.getEvent());
        }
    }
}

