/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeGraphLayout<N, E>
extends GraphLayout<N, E> {
    private int originX;
    private int originY;
    private int verticalGap;
    private int horizontalGap;
    private boolean vertical;
    private N rootNode;

    public TreeGraphLayout(int n, int n2, int n3, int n4, boolean bl) {
        this.originX = n;
        this.originY = n2;
        this.verticalGap = n3;
        this.horizontalGap = n4;
        this.vertical = bl;
    }

    public void setRootNode(N n) {
        this.rootNode = n;
    }

    public void setProperties(int n, int n2, int n3, int n4, boolean bl) {
        this.originX = n;
        this.originY = n2;
        this.verticalGap = n3;
        this.horizontalGap = n4;
        this.vertical = bl;
    }

    @Override
    protected void performGraphLayout(UniversalGraph<N, E> universalGraph) {
        if (this.rootNode == null) {
            return;
        }
        Collection<N> collection = universalGraph.getNodes();
        if (!collection.contains(this.rootNode)) {
            return;
        }
        ArrayList<N> arrayList = new ArrayList<N>(collection);
        HashSet hashSet = new HashSet();
        Node node = new Node(universalGraph, this.rootNode, hashSet);
        arrayList.removeAll(hashSet);
        if (this.vertical) {
            node.allocateHorizontally(universalGraph);
            node.resolveVertically(this.originX, this.originY);
        } else {
            node.allocateVertically(universalGraph);
            node.resolveHorizontally(this.originX, this.originY);
        }
        HashMap<N, Point> hashMap = new HashMap<N, Point>();
        node.upload(hashMap);
        for (N object : arrayList) {
            Point point = new Point();
            hashMap.put(object, point);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.setResolvedNodeLocation(universalGraph, entry.getKey(), (Point)entry.getValue());
        }
    }

    @Override
    protected void performNodesLayout(UniversalGraph<N, E> universalGraph, Collection<N> collection) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node {
        private N node;
        private ArrayList<Node> children;
        private Rectangle relativeBounds;
        private int space;
        private int totalSpace;
        private Point point;

        private Node(UniversalGraph<N, E> universalGraph, N n, HashSet<N> hashSet) {
            this.node = n;
            hashSet.add(n);
            this.children = new ArrayList();
            for (Object e : universalGraph.findNodeEdges(n, true, false)) {
                Object n2 = universalGraph.getEdgeTarget(e);
                if (n2 == null || hashSet.contains(n2)) continue;
                this.children.add(new Node(universalGraph, n2, hashSet));
            }
        }

        private int allocateHorizontally(UniversalGraph<N, E> universalGraph) {
            Widget widget = universalGraph.getScene().findWidget(this.node);
            widget.getLayout().layout(widget);
            this.relativeBounds = widget.getPreferredBounds();
            this.space = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                if (i > 0) {
                    this.space += TreeGraphLayout.this.horizontalGap;
                }
                this.space += this.children.get(i).allocateHorizontally(universalGraph);
            }
            this.totalSpace = Math.max(this.space, this.relativeBounds.width);
            return this.totalSpace;
        }

        private void resolveVertically(int n, int n2) {
            this.point = new Point(n + this.totalSpace / 2, n2 - this.relativeBounds.y);
            n += (this.totalSpace - this.space) / 2;
            n2 += this.relativeBounds.height + TreeGraphLayout.this.verticalGap;
            for (Node node : this.children) {
                node.resolveVertically(n, n2);
                n += node.totalSpace + TreeGraphLayout.this.horizontalGap;
            }
        }

        private int allocateVertically(UniversalGraph<N, E> universalGraph) {
            Widget widget = universalGraph.getScene().findWidget(this.node);
            widget.getLayout().layout(widget);
            this.relativeBounds = widget.getPreferredBounds();
            this.space = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                if (i > 0) {
                    this.space += TreeGraphLayout.this.verticalGap;
                }
                this.space += this.children.get(i).allocateVertically(universalGraph);
            }
            this.totalSpace = Math.max(this.space, this.relativeBounds.height);
            return this.totalSpace;
        }

        private void resolveHorizontally(int n, int n2) {
            this.point = new Point(n - this.relativeBounds.x, n2 + this.totalSpace / 2);
            n += this.relativeBounds.width + TreeGraphLayout.this.horizontalGap;
            n2 += (this.totalSpace - this.space) / 2;
            for (Node node : this.children) {
                node.resolveHorizontally(n, n2);
                n2 += node.totalSpace + TreeGraphLayout.this.verticalGap;
            }
        }

        private void upload(HashMap<N, Point> hashMap) {
            hashMap.put(this.node, this.point);
            for (Node node : this.children) {
                node.upload(hashMap);
            }
        }
    }
}

