/*
 * Decompiled with CFR 0.152.
 */
package liqp.filters;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import liqp.TemplateContext;
import liqp.filters.Filter;
import liqp.parser.Inspectable;
import liqp.parser.LiquidSupport;

public class Relative_Url
extends Filter {
    public static final String site = "site";
    public static final String baseurl = "baseurl";

    @Override
    public Object apply(Object value, TemplateContext context, Object ... params) {
        String valAsString = this.asString(value, context);
        if (this.isValidAbsoluteUrl(valAsString)) {
            return valAsString;
        }
        Map<String, Object> siteMap = this.objectToMap(context.get(site), context);
        String baseUrl = this.asString(siteMap.get(baseurl), context);
        return this.getRelativeUrl(context, baseUrl, valAsString);
    }

    protected String getRelativeUrl(TemplateContext context, String baseUrl, String valAsString) {
        String baseUrlString;
        if (!valAsString.startsWith("/")) {
            valAsString = "/" + valAsString;
        }
        if ((baseUrlString = this.asString(baseUrl, context)).isEmpty()) {
            return valAsString;
        }
        if (!baseUrlString.startsWith("/")) {
            baseUrlString = "/" + baseUrlString;
        }
        String res = "/".equals(valAsString) ? ("/".equals(baseUrlString) ? "/" : baseUrlString) : baseUrlString + valAsString;
        try {
            String path;
            String[] parts;
            String query = null;
            String anchor = null;
            String[] anchorParts = res.split("#", 2);
            if (anchorParts.length > 1) {
                anchor = anchorParts[1];
                res = anchorParts[0];
            }
            if ((parts = res.split("\\?", 2)).length > 1) {
                path = parts[0];
                query = parts[1];
            } else {
                path = res;
            }
            URI uri = new URI(null, null, null, -1, path, query, anchor);
            String afterDecoding = uri.normalize().toASCIIString();
            if (afterDecoding.isEmpty()) {
                afterDecoding = "/";
            }
            return afterDecoding;
        }
        catch (URISyntaxException e) {
            if (context.renderSettings.raiseExceptionsInStrictMode) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return res;
        }
    }

    protected Map<String, Object> objectToMap(Object configRoot, TemplateContext context) {
        if (configRoot instanceof Inspectable) {
            LiquidSupport evaluated = context.renderSettings.evaluate(context.parseSettings.mapper, (Object)configRoot);
            configRoot = evaluated.toLiquid();
        }
        Map<String, Object> siteMap = this.isMap(configRoot) ? this.asMap(configRoot) : Collections.emptyMap();
        return siteMap;
    }

    protected boolean isValidAbsoluteUrl(String valAsString) {
        try {
            URI uri = new URI(valAsString);
            if (uri.getScheme() != null) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return false;
    }
}

