/**
 * Copyright (c) 2011-2013 by Andrew Mustun. All rights reserved.
 * 
 * This file is part of the QCAD project.
 *
 * QCAD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QCAD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QCAD.
 */
// Auto generated by Testing Dashboard
// File        : scripts/Modify/Rotate2/Tests/Rotate2Test04.js
// Timestamp   : 2011-08-08 14:58:56
// Description : Rotate 2 using a spline

include('scripts/Pro/Developer/TestingDashboard/TdbTest.js');

function Rotate2Test04() {
    TdbTest.call(this, 'scripts/Modify/Rotate2/Tests/Rotate2Test04.js');
}

Rotate2Test04.prototype = new TdbTest();

Rotate2Test04.prototype.test00 = function() {
    qDebug('running Rotate2Test04.test00()...');
    this.setUp();
    var w = objectFromPath('MainWindow::CadToolBar::MainToolsPanel');
    this.sendMouseEvent(w, QEvent.MouseButtonPress, new QPoint(44, 433), Qt.LeftButton, 1, 0);
    var w = objectFromPath('MainWindow::CadToolBar::MainToolsPanel');
    this.sendMouseEvent(w, QEvent.MouseButtonRelease, new QPoint(44, 433), Qt.LeftButton, 0, 0);
    this.importFile('scripts/Modify/Rotate2/Tests/data/spline.dxf');
    this.setZoom(8.504910963276966, new RVector(29.7475, 25.2795, 0) );
    var p = new RVector(6.584431, 9.053593);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.triggerCommand('rotate2');
    this.setToolOption('TranslateRotate/PrimaryAngle',  [ 30, 0 ] );
    this.setToolOption('TranslateRotate/SecondaryAngle',  [ 1, 0 ] );
    this.setToolOption('TranslateRotate/NumberOfCopies',  [ 11, 0 ] );
    this.updateToolOptions();
    this.setZoom(8.504910963276966, new RVector(29.7475, 25.2795, 0) );
    var p = new RVector(0, 0.117579);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.setZoom(8.504910963276966, new RVector(29.7475, 25.2795, 0) );
    var p = new RVector(19.870872, 13.051283);
    this.sendMouseEventModelPos(QEvent.MouseButtonPress, p, Qt.LeftButton, 1, 0);
    this.dlgStart();
    this.dlgAppendCode('var map = new Map()');
    this.dlgAppendCode("map.put('DialogOpenedByTdb/groupBox', 'MultipleCopies')");
    this.dlgAppendCode("map.put('DialogOpenedByTdb/NumberOfCopies',  [ 11, 0 ] )");
    this.dlgAppendCode("map.put('DialogOpenedByTdb/PrimaryAngle',  [ 30, 0 ] )");
    this.dlgAppendCode("map.put('DialogOpenedByTdb/SecondaryAngle',  [ 1, 0 ] )");
    this.dlgAppendCode("map.put('DialogOpenedByTdb/UseCurrentAttributes', false)");
    this.dlgAppendCode("WidgetFactory.restoreState(dialog, 'DialogOpenedByTdb', undefined, false, undefined, map)");
    this.dlgEnd();
    this.sendMouseEventModelPos(QEvent.MouseButtonRelease, p, Qt.LeftButton, 0, 0);
    this.verifyDrawing('Rotate2Test04_000.dxf');
    this.tearDown();
    qDebug('finished Rotate2Test04.test00()');
};

