/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Map;
import org.keycloak.common.util.Time;
import org.keycloak.models.UserSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;

public interface AuthenticatedClientSessionModel
extends CommonClientSessionModel {
    public static final String STARTED_AT_NOTE = "startedAt";
    public static final String USER_SESSION_STARTED_AT_NOTE = "userSessionStartedAt";
    public static final String USER_SESSION_REMEMBER_ME_NOTE = "userSessionRememberMe";
    public static final String REFRESH_TOKEN_PREFIX = "refreshTokenPrefix";
    public static final String REFRESH_TOKEN_USE_PREFIX = "refreshTokenUsePrefix";
    public static final String REFRESH_TOKEN_LAST_REFRESH_PREFIX = "refreshTokenLastRefreshPrefix";

    public String getId();

    default public int getStarted() {
        String started = this.getNote(STARTED_AT_NOTE);
        if (started == null) {
            return this.getUserSession().isOffline() ? this.getUserSessionStarted() : 0;
        }
        return Integer.parseInt(started);
    }

    default public int getUserSessionStarted() {
        String started = this.getNote(USER_SESSION_STARTED_AT_NOTE);
        return started == null ? this.getUserSession().getStarted() : Integer.parseInt(started);
    }

    default public boolean isUserSessionRememberMe() {
        return Boolean.parseBoolean(this.getNote(USER_SESSION_REMEMBER_ME_NOTE));
    }

    public int getTimestamp();

    public void setTimestamp(int var1);

    public void detachFromUserSession();

    public UserSessionModel getUserSession();

    @Deprecated
    default public String getCurrentRefreshToken() {
        return null;
    }

    @Deprecated
    default public void setCurrentRefreshToken(String currentRefreshToken) {
    }

    @Deprecated
    default public int getCurrentRefreshTokenUseCount() {
        return 0;
    }

    @Deprecated
    default public void setCurrentRefreshTokenUseCount(int currentRefreshTokenUseCount) {
    }

    default public String getRefreshToken(String reuseId) {
        return this.getNote(REFRESH_TOKEN_PREFIX + reuseId);
    }

    default public void setRefreshToken(String reuseId, String refreshTokenId) {
        this.setNote(REFRESH_TOKEN_PREFIX + reuseId, refreshTokenId);
    }

    default public int getRefreshTokenUseCount(String reuseId) {
        String count = this.getNote(REFRESH_TOKEN_USE_PREFIX + reuseId);
        return count == null ? 0 : Integer.parseInt(count);
    }

    default public void setRefreshTokenUseCount(String reuseId, int refreshTokenUseCount) {
        this.setNote(REFRESH_TOKEN_USE_PREFIX + reuseId, String.valueOf(refreshTokenUseCount));
    }

    default public int getRefreshTokenLastRefresh(String reuseId) {
        String timestamp = this.getNote(REFRESH_TOKEN_LAST_REFRESH_PREFIX + reuseId);
        return timestamp == null ? 0 : Integer.parseInt(timestamp);
    }

    default public void setRefreshTokenLastRefresh(String reuseId, int refreshTokenLastRefresh) {
        this.setNote(REFRESH_TOKEN_LAST_REFRESH_PREFIX + reuseId, String.valueOf(refreshTokenLastRefresh));
    }

    public String getNote(String var1);

    public void setNote(String var1, String var2);

    public void removeNote(String var1);

    public Map<String, String> getNotes();

    default public void restartClientSession() {
        this.setAction(null);
        this.setRedirectUri(null);
        this.setTimestamp(Time.currentTime());
        for (String note : this.getNotes().keySet()) {
            if (USER_SESSION_STARTED_AT_NOTE.equals(note) || STARTED_AT_NOTE.equals(note) || USER_SESSION_REMEMBER_ME_NOTE.equals(note)) continue;
            this.removeNote(note);
        }
        this.getNotes().put(STARTED_AT_NOTE, String.valueOf(this.getTimestamp()));
    }
}

