/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.relay;

import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.nlj.Features;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpSender;
import org.jitsi.nlj.RtpSenderImpl;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtcp.RtcpEventNotifier;
import org.jitsi.nlj.rtcp.RtcpListener;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.srtp.SrtpTransformers;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.stats.PacketStreamStats;
import org.jitsi.nlj.util.PacketInfoQueue;
import org.jitsi.nlj.util.StreamInformationStore;
import org.jitsi.nlj.util.StreamInformationStoreImpl;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.queue.CountingErrorHandler;
import org.jitsi.videobridge.TransportConfig;
import org.jitsi.videobridge.metrics.QueueMetrics;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.util.TaskPools;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 82\u00020\u0001:\u00018B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001cJ\u000e\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+J\u0016\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001cJ\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u000205J\u0006\u00106\u001a\u00020\u001eJ\b\u00107\u001a\u00020\u001eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jitsi/videobridge/relay/RelayEndpointSender;", "", "relay", "Lorg/jitsi/videobridge/relay/Relay;", "id", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "<init>", "(Lorg/jitsi/videobridge/relay/Relay;Ljava/lang/String;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;)V", "getRelay", "()Lorg/jitsi/videobridge/relay/Relay;", "getId", "()Ljava/lang/String;", "logger", "streamInformationStore", "Lorg/jitsi/nlj/util/StreamInformationStore;", "rtcpEventNotifier", "Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "getRtcpEventNotifier", "()Lorg/jitsi/nlj/rtcp/RtcpEventNotifier;", "rtpSender", "Lorg/jitsi/nlj/RtpSender;", "outgoingSrtpPacketQueue", "Lorg/jitsi/nlj/util/PacketInfoQueue;", "expired", "", "addPayloadType", "", "payloadType", "Lorg/jitsi/nlj/format/PayloadType;", "addRtpExtension", "rtpExtension", "Lorg/jitsi/nlj/rtp/RtpExtension;", "setExtmapAllowMixed", "allow", "setSrtpInformation", "srtpTransformers", "Lorg/jitsi/nlj/srtp/SrtpTransformers;", "sendPacket", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "setFeature", "feature", "Lorg/jitsi/nlj/Features;", "enabled", "getOutgoingStats", "Lorg/jitsi/nlj/stats/PacketStreamStats$Snapshot;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getDebugState", "Lorg/json/simple/JSONObject;", "expire", "updateStatsOnExpire", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nRelayEndpointSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelayEndpointSender.kt\norg/jitsi/videobridge/relay/RelayEndpointSender\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n*L\n1#1,195:1\n63#2,4:196\n*S KotlinDebug\n*F\n+ 1 RelayEndpointSender.kt\norg/jitsi/videobridge/relay/RelayEndpointSender\n*L\n149#1:196,4\n*E\n"})
public final class RelayEndpointSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Relay relay;
    @NotNull
    private final String id;
    @NotNull
    private final Logger logger;
    @NotNull
    private final StreamInformationStore streamInformationStore;
    @NotNull
    private final RtcpEventNotifier rtcpEventNotifier;
    @NotNull
    private final RtpSender rtpSender;
    @NotNull
    private final PacketInfoQueue outgoingSrtpPacketQueue;
    private boolean expired;
    @NotNull
    private static final CounterMetric droppedPacketsMetric = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "relay_endpoint_srtp_send_queue_dropped_packets", "Number of packets dropped out of the Relay SRTP send queue.", 0L, null, 12, null);
    @NotNull
    private static final CounterMetric exceptionsMetric = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "relay_endpoint_srtp_send_queue_exceptions", "Number of exceptions from the Relay SRTP send queue.", 0L, null, 12, null);
    @JvmField
    @NotNull
    public static final CountingErrorHandler queueErrorCounter = new CountingErrorHandler(){

        public void packetDropped() {
            Unit unit;
            super.packetDropped();
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            CounterMetric.inc$default(RelayEndpointSender.access$getDroppedPacketsMetric$cp(), null, 1, null);
            CounterMetric.inc$default(QueueMetrics.INSTANCE.getDroppedPackets(), null, 1, null);
        }

        public void packetHandlingFailed(Throwable t2) {
            Unit unit;
            super.packetHandlingFailed(t2);
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            CounterMetric.inc$default(RelayEndpointSender.access$getExceptionsMetric$cp(), null, 1, null);
            CounterMetric.inc$default(QueueMetrics.INSTANCE.getExceptions(), null, 1, null);
        }
    };
    @NotNull
    private static final String SRTP_QUEUE_ENTRY_EVENT = "Entered RelayEndpointSender SRTP sender outgoing queue";

    /*
     * WARNING - void declaration
     */
    public RelayEndpointSender(@NotNull Relay relay, @NotNull String id, @NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext) {
        void $this$outgoingSrtpPacketQueue_u24lambda_u243;
        Object $this$rtpSender_u24lambda_u241;
        Object $this$rtcpEventNotifier_u24lambda_u240;
        Intrinsics.checkNotNullParameter(relay, "relay");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        this.relay = relay;
        this.id = id;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.streamInformationStore = new StreamInformationStoreImpl();
        Object object = new RtcpEventNotifier();
        RtcpEventNotifier rtcpEventNotifier2 = object;
        RelayEndpointSender relayEndpointSender = this;
        boolean bl = false;
        ((RtcpEventNotifier)$this$rtcpEventNotifier_u24lambda_u240).addRtcpEventListener(new RtcpListener(this){
            final /* synthetic */ RelayEndpointSender this$0;
            {
                this.this$0 = $receiver;
            }

            public void rtcpPacketReceived(RtcpPacket packet, Instant receivedTime) {
                Intrinsics.checkNotNullParameter(packet, "packet");
                throw new IllegalStateException("got rtcpPacketReceived callback from a sender");
            }

            public void rtcpPacketSent(RtcpPacket packet) {
                Intrinsics.checkNotNullParameter(packet, "packet");
                this.this$0.getRelay().rtcpPacketSent(packet, this.this$0.getId());
            }
        }, true);
        relayEndpointSender.rtcpEventNotifier = object;
        String string = this.relay.getId() + "-" + this.id;
        ExecutorService executorService = TaskPools.CPU_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService, "CPU_POOL");
        ScheduledExecutorService scheduledExecutorService = TaskPools.SCHEDULED_POOL;
        Intrinsics.checkNotNullExpressionValue(scheduledExecutorService, "SCHEDULED_POOL");
        $this$rtcpEventNotifier_u24lambda_u240 = object = new RtpSenderImpl(string, this.rtcpEventNotifier, executorService, scheduledExecutorService, this.streamInformationStore, this.logger, diagnosticContext);
        relayEndpointSender = this;
        boolean bl2 = false;
        ((RtpSenderImpl)$this$rtpSender_u24lambda_u241).onOutgoingPacket(new PacketHandler(this){
            final /* synthetic */ RelayEndpointSender this$0;
            {
                this.this$0 = $receiver;
            }

            public void processPacket(PacketInfo packetInfo) {
                Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                packetInfo.addEvent("Entered RelayEndpointSender SRTP sender outgoing queue");
                RelayEndpointSender.access$getOutgoingSrtpPacketQueue$p(this.this$0).add(packetInfo);
            }
        });
        relayEndpointSender.rtpSender = (RtpSender)object;
        String string2 = this.getClass().getSimpleName() + "-outgoing-packet-queue";
        ExecutorService executorService2 = TaskPools.IO_POOL;
        Intrinsics.checkNotNullExpressionValue(executorService2, "IO_POOL");
        $this$rtpSender_u24lambda_u241 = object = new PacketInfoQueue(string2, executorService2, arg_0 -> RelayEndpointSender.outgoingSrtpPacketQueue$lambda$2(this, arg_0), TransportConfig.Companion.getQueueSize());
        relayEndpointSender = this;
        boolean bl3 = false;
        $this$outgoingSrtpPacketQueue_u24lambda_u243.setErrorHandler(queueErrorCounter);
        relayEndpointSender.outgoingSrtpPacketQueue = object;
    }

    @NotNull
    public final Relay getRelay() {
        return this.relay;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final RtcpEventNotifier getRtcpEventNotifier() {
        return this.rtcpEventNotifier;
    }

    public final void addPayloadType(@NotNull PayloadType payloadType) {
        Intrinsics.checkNotNullParameter(payloadType, "payloadType");
        this.streamInformationStore.addRtpPayloadType(payloadType);
    }

    public final void addRtpExtension(@NotNull RtpExtension rtpExtension) {
        Intrinsics.checkNotNullParameter(rtpExtension, "rtpExtension");
        this.streamInformationStore.addRtpExtensionMapping(rtpExtension);
    }

    public final void setExtmapAllowMixed(boolean allow) {
        this.streamInformationStore.setExtmapAllowMixed(allow);
    }

    public final void setSrtpInformation(@NotNull SrtpTransformers srtpTransformers) {
        Intrinsics.checkNotNullParameter(srtpTransformers, "srtpTransformers");
        this.rtpSender.setSrtpTransformers(srtpTransformers);
    }

    public final void sendPacket(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        this.rtpSender.processPacket(packetInfo);
    }

    public final void setFeature(@NotNull Features feature, boolean enabled2) {
        Intrinsics.checkNotNullParameter((Object)feature, "feature");
        this.rtpSender.setFeature(feature, enabled2);
    }

    @NotNull
    public final PacketStreamStats.Snapshot getOutgoingStats() {
        return this.rtpSender.getPacketStreamStats();
    }

    @NotNull
    public final NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u244 = nodeStatsBlock = new NodeStatsBlock("Remote Endpoint " + this.id);
        boolean bl = false;
        $this$getNodeStats_u24lambda_u244.addBlock(this.streamInformationStore.getNodeStats());
        $this$getNodeStats_u24lambda_u244.addBlock(this.rtpSender.getNodeStats());
        return nodeStatsBlock;
    }

    @NotNull
    public final JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        ((Map)debugState).put("expired", this.expired);
        NodeStatsBlock block = this.getNodeStats();
        ((Map)debugState).put(block.getName(), block.toJson());
        return debugState;
    }

    public final void expire() {
        if (this.expired) {
            return;
        }
        this.expired = true;
        try {
            this.updateStatsOnExpire();
            this.rtpSender.stop();
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug(this.getNodeStats().prettyPrint(0));
            }
            this.rtpSender.tearDown();
        }
        catch (Throwable t2) {
            this.logger.error("Exception while expiring: ", t2);
        }
        this.outgoingSrtpPacketQueue.close();
    }

    private final void updateStatsOnExpire() {
        Relay.Statistics statistics;
        Relay.Statistics relayStats = this.relay.getStatistics();
        PacketStreamStats.Snapshot outgoingStats = this.rtpSender.getPacketStreamStats();
        Relay.Statistics $this$updateStatsOnExpire_u24lambda_u246 = statistics = relayStats;
        boolean bl = false;
        $this$updateStatsOnExpire_u24lambda_u246.getBytesSent().getAndAdd(outgoingStats.getBytes());
        $this$updateStatsOnExpire_u24lambda_u246.getPacketsSent().getAndAdd(outgoingStats.getPackets());
    }

    private static final boolean outgoingSrtpPacketQueue$lambda$2(RelayEndpointSender this$0, PacketInfo packet) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(packet, "packet");
        return this$0.relay.doSendSrtp(packet);
    }

    public static final /* synthetic */ PacketInfoQueue access$getOutgoingSrtpPacketQueue$p(RelayEndpointSender $this) {
        return $this.outgoingSrtpPacketQueue;
    }

    public static final /* synthetic */ CounterMetric access$getDroppedPacketsMetric$cp() {
        return droppedPacketsMetric;
    }

    public static final /* synthetic */ CounterMetric access$getExceptionsMetric$cp() {
        return exceptionsMetric;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jitsi/videobridge/relay/RelayEndpointSender$Companion;", "", "<init>", "()V", "droppedPacketsMetric", "Lorg/jitsi/metrics/CounterMetric;", "exceptionsMetric", "queueErrorCounter", "Lorg/jitsi/utils/queue/CountingErrorHandler;", "SRTP_QUEUE_ENTRY_EVENT", "", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

