/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.metrics;

import io.sentry.IMetricsAggregator;
import io.sentry.ISpan;
import io.sentry.MeasurementUnit;
import io.sentry.SentryDate;
import io.sentry.SentryNanotimeDate;
import io.sentry.metrics.LocalMetricsAggregator;
import io.sentry.metrics.MetricsHelper;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetricsApi {
    @NotNull
    private final IMetricsInterface aggregator;

    public MetricsApi(@NotNull IMetricsInterface aggregator) {
        this.aggregator = aggregator;
    }

    public void increment(@NotNull String key) {
        this.increment(key, 1.0, null, null, null);
    }

    public void increment(@NotNull String key, double value2) {
        this.increment(key, value2, null, null, null);
    }

    public void increment(@NotNull String key, double value2, @Nullable MeasurementUnit unit) {
        this.increment(key, value2, unit, null, null);
    }

    public void increment(@NotNull String key, double value2, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags) {
        this.increment(key, value2, unit, tags, null);
    }

    public void increment(@NotNull String key, double value2, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @Nullable Long timestampMs) {
        long timestamp = timestampMs != null ? timestampMs : System.currentTimeMillis();
        @NotNull Map<String, String> enrichedTags = MetricsHelper.mergeTags(tags, this.aggregator.getDefaultTagsForMetrics());
        @Nullable LocalMetricsAggregator localMetricsAggregator = this.aggregator.getLocalMetricsAggregator();
        this.aggregator.getMetricsAggregator().increment(key, value2, unit, enrichedTags, timestamp, localMetricsAggregator);
    }

    public void gauge(@NotNull String key, double value2) {
        this.gauge(key, value2, null, null, null);
    }

    public void gauge(@NotNull String key, double value2, @Nullable MeasurementUnit unit) {
        this.gauge(key, value2, unit, null, null);
    }

    public void gauge(@NotNull String key, double value2, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags) {
        this.gauge(key, value2, unit, tags, null);
    }

    public void gauge(@NotNull String key, double value2, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @Nullable Long timestampMs) {
        long timestamp = timestampMs != null ? timestampMs : System.currentTimeMillis();
        @NotNull Map<String, String> enrichedTags = MetricsHelper.mergeTags(tags, this.aggregator.getDefaultTagsForMetrics());
        @Nullable LocalMetricsAggregator localMetricsAggregator = this.aggregator.getLocalMetricsAggregator();
        this.aggregator.getMetricsAggregator().gauge(key, value2, unit, enrichedTags, timestamp, localMetricsAggregator);
    }

    public void distribution(@NotNull String key, double value2) {
        this.distribution(key, value2, null, null, null);
    }

    public void distribution(@NotNull String key, double value2, @Nullable MeasurementUnit unit) {
        this.distribution(key, value2, unit, null, null);
    }

    public void distribution(@NotNull String key, double value2, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags) {
        this.distribution(key, value2, unit, tags, null);
    }

    public void distribution(@NotNull String key, double value2, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @Nullable Long timestampMs) {
        long timestamp = timestampMs != null ? timestampMs : System.currentTimeMillis();
        @NotNull Map<String, String> enrichedTags = MetricsHelper.mergeTags(tags, this.aggregator.getDefaultTagsForMetrics());
        @Nullable LocalMetricsAggregator localMetricsAggregator = this.aggregator.getLocalMetricsAggregator();
        this.aggregator.getMetricsAggregator().distribution(key, value2, unit, enrichedTags, timestamp, localMetricsAggregator);
    }

    public void set(@NotNull String key, int value2) {
        this.set(key, value2, null, null, null);
    }

    public void set(@NotNull String key, int value2, @Nullable MeasurementUnit unit) {
        this.set(key, value2, unit, null, null);
    }

    public void set(@NotNull String key, int value2, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags) {
        this.set(key, value2, unit, tags, null);
    }

    public void set(@NotNull String key, int value2, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @Nullable Long timestampMs) {
        long timestamp = timestampMs != null ? timestampMs : System.currentTimeMillis();
        @NotNull Map<String, String> enrichedTags = MetricsHelper.mergeTags(tags, this.aggregator.getDefaultTagsForMetrics());
        @Nullable LocalMetricsAggregator localMetricsAggregator = this.aggregator.getLocalMetricsAggregator();
        this.aggregator.getMetricsAggregator().set(key, value2, unit, enrichedTags, timestamp, localMetricsAggregator);
    }

    public void set(@NotNull String key, @NotNull String value2) {
        this.set(key, value2, null, null, null);
    }

    public void set(@NotNull String key, @NotNull String value2, @Nullable MeasurementUnit unit) {
        this.set(key, value2, unit, null, null);
    }

    public void set(@NotNull String key, @NotNull String value2, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags) {
        this.set(key, value2, unit, tags, null);
    }

    public void set(@NotNull String key, @NotNull String value2, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @Nullable Long timestampMs) {
        long timestamp = timestampMs != null ? timestampMs : System.currentTimeMillis();
        @NotNull Map<String, String> enrichedTags = MetricsHelper.mergeTags(tags, this.aggregator.getDefaultTagsForMetrics());
        @Nullable LocalMetricsAggregator localMetricsAggregator = this.aggregator.getLocalMetricsAggregator();
        this.aggregator.getMetricsAggregator().set(key, value2, unit, enrichedTags, timestamp, localMetricsAggregator);
    }

    public void timing(@NotNull String key, @NotNull Runnable callback) {
        this.timing(key, callback, null, null);
    }

    public void timing(@NotNull String key, @NotNull Runnable callback, @NotNull MeasurementUnit.Duration unit) {
        this.timing(key, callback, unit, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timing(@NotNull String key, @NotNull Runnable callback, @Nullable MeasurementUnit.Duration unit, @Nullable Map<String, String> tags) {
        long durationNanos;
        long timestamp;
        LocalMetricsAggregator localMetricsAggregator;
        Map<String, String> enrichedTags;
        MeasurementUnit.Duration durationUnit;
        block7: {
            long startNanos;
            block6: {
                SentryDate spanFinishDate;
                durationUnit = unit != null ? unit : MeasurementUnit.Duration.SECOND;
                enrichedTags = MetricsHelper.mergeTags(tags, this.aggregator.getDefaultTagsForMetrics());
                @Nullable ISpan span = this.aggregator.startSpanForMetric("metric.timing", key);
                LocalMetricsAggregator localMetricsAggregator2 = localMetricsAggregator = span != null ? span.getLocalMetricsAggregator() : this.aggregator.getLocalMetricsAggregator();
                if (span != null && tags != null) {
                    for (Map.Entry<String, String> entry : tags.entrySet()) {
                        span.setTag(entry.getKey(), entry.getValue());
                    }
                }
                timestamp = System.currentTimeMillis();
                startNanos = System.nanoTime();
                try {
                    callback.run();
                    if (span == null) break block6;
                    span.finish();
                    spanFinishDate = span.getFinishDate() != null ? span.getFinishDate() : new SentryNanotimeDate();
                }
                catch (Throwable throwable) {
                    long durationNanos2;
                    if (span != null) {
                        span.finish();
                        @NotNull SentryDate spanFinishDate2 = span.getFinishDate() != null ? span.getFinishDate() : new SentryNanotimeDate();
                        durationNanos2 = spanFinishDate2.diff(span.getStartDate());
                    } else {
                        durationNanos2 = System.nanoTime() - startNanos;
                    }
                    double value2 = MetricsHelper.convertNanosTo(durationUnit, durationNanos2);
                    this.aggregator.getMetricsAggregator().distribution(key, value2, durationUnit, enrichedTags, timestamp, localMetricsAggregator);
                    throw throwable;
                }
                durationNanos = spanFinishDate.diff(span.getStartDate());
                break block7;
            }
            durationNanos = System.nanoTime() - startNanos;
        }
        double value3 = MetricsHelper.convertNanosTo(durationUnit, durationNanos);
        this.aggregator.getMetricsAggregator().distribution(key, value3, durationUnit, enrichedTags, timestamp, localMetricsAggregator);
    }

    @ApiStatus.Internal
    public static interface IMetricsInterface {
        @NotNull
        public IMetricsAggregator getMetricsAggregator();

        @Nullable
        public LocalMetricsAggregator getLocalMetricsAggregator();

        @NotNull
        public Map<String, String> getDefaultTagsForMetrics();

        @Nullable
        public ISpan startSpanForMetric(@NotNull String var1, @NotNull String var2);
    }
}

