/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.mission;

import java.util.Comparator;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.MissionAIPlayer;
import net.sf.freecol.server.ai.TransportableAIObject;
import net.sf.freecol.server.ai.mission.TransportMission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;

public abstract class Mission
extends AIObject {
    private static final Logger logger = Logger.getLogger(Mission.class.getName());
    protected static final int MINIMUM_TRANSPORT_PRIORITY = 60;
    protected static final int NORMAL_TRANSPORT_PRIORITY = 100;
    protected static final int NO_PATH_TO_TARGET = -2;
    protected static final int NO_MORE_MOVES_LEFT = -1;
    protected static final String AIUNITNULL = "aiUnit-null";
    protected static final String AIUNITDIED = "aiUnit-died";
    protected static final String TARGETNULL = "target-null";
    protected static final String TARGETINVALID = "target-invalid";
    protected static final String TARGETOWNERSHIP = "target-ownership";
    protected static final String TARGETNOTFOUND = "target-not-found";
    protected static final String UNITNOTAPERSON = "unit-not-a-person";
    protected static final String UNITNOTOFFENSIVE = "unit-not-offensive";
    protected static final String UNITNOTOFREQUIREDTYPE = "unit-not-required-type";
    protected static final String UNITNOTONMAP = "unit-not-on-map";
    private final AIUnit aiUnit;

    protected Mission(AIMain aiMain, AIUnit aiUnit) {
        super(aiMain);
        this.aiUnit = aiUnit;
        this.setInitialized();
        if (aiUnit != null && aiUnit.getMission() != this) {
            aiUnit.changeMission(this);
        }
    }

    @Override
    public final void setInitialized() {
        this.initialized = this.getAIUnit() != null;
    }

    public final AIUnit getAIUnit() {
        return this.aiUnit;
    }

    public final Unit getUnit() {
        return this.aiUnit == null ? null : this.aiUnit.getUnit();
    }

    protected final Player getPlayer() {
        return this.getUnit() == null ? null : this.getUnit().getOwner();
    }

    protected final MissionAIPlayer getAIPlayer() {
        return (MissionAIPlayer)this.getAIMain().getAIPlayer(this.getUnit().getOwner());
    }

    protected final EuropeanAIPlayer getEuropeanAIPlayer() {
        Player player = this.getUnit().getOwner();
        if (!player.isEuropean()) {
            throw new IllegalArgumentException("Not a European player: " + player);
        }
        return (EuropeanAIPlayer)this.getAIMain().getAIPlayer(player);
    }

    protected final Random getAIRandom() {
        return this.aiUnit.getAIRandom();
    }

    public final boolean isValid() {
        return this.invalidReason() == null;
    }

    public static boolean isTargetReason(String reason) {
        return reason != null && reason.startsWith("target-");
    }

    private static String invalidUnitReason(Unit unit) {
        return unit == null ? "unit-null" : (!unit.isInitialized() ? "unit-uninitialized" : (unit.isDisposed() ? "unit-disposed" : (unit.isDamagedAndUnderForcedRepair() ? "unit-under-repair" : null)));
    }

    public static String invalidAIUnitReason(AIUnit aiUnit) {
        String reason;
        return aiUnit == null ? AIUNITNULL : ((reason = Mission.invalidUnitReason(aiUnit.getUnit())) != null ? reason : null);
    }

    public static String invalidNewMissionReason(AIUnit aiUnit) {
        return aiUnit == null ? AIUNITNULL : (aiUnit.hasMission() && !aiUnit.getMission().isOneTime() && aiUnit.getMission().isValid() ? "mission-exists" : null);
    }

    public static String invalidTargetReason(Location target) {
        return target == null ? TARGETNULL : (((FreeColGameObject)((Object)target)).isDisposed() ? "target-disposed" : null);
    }

    public static String invalidTargetReason(Location target, Player owner) {
        String reason = Mission.invalidTargetReason(target);
        return reason != null ? reason : (target instanceof Europe && !owner.owns((Europe)target) ? TARGETOWNERSHIP : (target instanceof Settlement && !owner.owns((Settlement)target) ? TARGETOWNERSHIP : null));
    }

    public static String invalidTransportableReason(TransportableAIObject t) {
        boolean checkSrc;
        if (t == null) {
            return "null-transportable";
        }
        Locatable l = t.getTransportLocatable();
        if (l == null) {
            return "null-locatable";
        }
        Unit carrier = l.getLocation() instanceof Unit ? (Unit)l.getLocation() : null;
        AIUnit transport = t.getTransport();
        boolean bl = checkSrc = transport == null;
        if (carrier != null && transport != null && carrier != transport.getUnit()) {
            return "transportable-on-other-carrier";
        }
        if (checkSrc) {
            Location loc = t.getTransportSource();
            if (loc == null) {
                return "transportable-source-missing-" + t;
            }
            if (((FreeColGameObject)((Object)loc)).isDisposed()) {
                return "transportable-source-disposed";
            }
            if (loc instanceof Settlement && l instanceof Ownable) {
                Settlement s = (Settlement)loc;
                if (!((Ownable)((Object)l)).getOwner().owns(s)) {
                    return "transportable-source-" + s.getName() + "-captured-by-" + s.getOwner().getDebugName();
                }
            }
        } else {
            Location loc = t.getTransportDestination();
            if (loc != null && ((FreeColGameObject)((Object)loc)).isDisposed()) {
                return "transportable-destination-disposed";
            }
        }
        return null;
    }

    public static String invalidAttackReason(AIUnit aiUnit, Player other) {
        Unit unit = aiUnit.getUnit();
        Player player = unit.getOwner();
        return player == other ? TARGETOWNERSHIP : (player.isIndian() && player.getTension(other).getLevel().compareTo(Tension.Level.CONTENT) <= 0 ? "target-native-tension-too-low" : (player.isEuropean() && player.getStance(other) != Stance.WAR && (!unit.hasAbility("model.ability.piracy") || player.getStance(other) == Stance.ALLIANCE) ? "target-european-war-absent" : null));
    }

    public static String invalidMissionReason(AIUnit aiUnit) {
        return Mission.invalidAIUnitReason(aiUnit);
    }

    public static String invalidMissionReason(AIUnit aiUnit, Location loc) {
        String reason = Mission.invalidAIUnitReason(aiUnit);
        return reason != null ? reason : Mission.invalidTargetReason(loc);
    }

    protected Mission lbAt(LogBuilder lb) {
        Unit unit = this.getUnit();
        lb.add(", at ", Location.upLoc(unit.getLocation()));
        return this;
    }

    protected Mission lbAttack(LogBuilder lb, Location what) {
        lb.add(", attacking ", what);
        return this;
    }

    protected Mission lbDodge(LogBuilder lb) {
        Unit unit = this.getUnit();
        lb.add(", dodging at ", unit.getLocation());
        unit.setMovesLeft(0);
        return this;
    }

    protected Mission lbDone(LogBuilder lb, boolean cont, Object ... reasons) {
        lb.add(", COMPLETED: ", reasons);
        return cont ? this.aiUnit.getMission() : this.lbDrop(lb, new Object[0]);
    }

    protected Mission lbDrop(LogBuilder lb, Object ... reasons) {
        lb.add(", DROPPED", reasons);
        return this.aiUnit == null ? null : this.aiUnit.changeMission(null);
    }

    protected Mission lbFail(LogBuilder lb, boolean cont, Object ... reasons) {
        lb.add(", FAILED: ", reasons);
        return cont ? this.aiUnit.getMission() : this.lbDrop(lb, new Object[0]);
    }

    protected Mission lbMove(LogBuilder lb, Unit.MoveType mt) {
        lb.add(new Object[]{", bad move type at ", this.getUnit().getLocation(), ": ", mt});
        return this;
    }

    protected Mission lbRetarget(LogBuilder lb) {
        lb.add(", retargeted ", this.getTarget());
        return this;
    }

    protected Mission lbWait(LogBuilder lb, Object ... reasons) {
        lb.add(reasons);
        this.getUnit().setMovesLeft(0);
        return this;
    }

    protected static Location findCircleTarget(AIUnit aiUnit, GoalDecider gd, int radius, boolean deferOK) {
        Unit unit = aiUnit.getUnit();
        Tile start = unit.getTile();
        if (start == null) {
            if (!deferOK) {
                return null;
            }
            Settlement settlement = unit.getOwner().getClosestPortForEurope();
            return settlement == null ? null : settlement;
        }
        return unit.getGame().getMap().searchCircle(start, gd, radius);
    }

    public static Location resolveBlockage(AIUnit aiUnit, Location target) {
        Unit unit = aiUnit.getUnit();
        PathNode path = unit.findPath(target);
        Object d = null;
        if (path != null && path.next != null) {
            Settlement blocker;
            Tile tile = path.next.getTile();
            Settlement settlement = tile.getSettlement();
            GoodsLocation goodsLocation = blocker = settlement != null ? settlement : tile.getDefendingUnit(unit);
            if (UnitSeekAndDestroyMission.invalidMissionReason(aiUnit, blocker) == null) {
                return blocker;
            }
        }
        return null;
    }

    protected Direction moveRandomly(String logMe, Direction direction) {
        Direction[] directions;
        Unit unit = this.getUnit();
        if (unit.getMovesLeft() <= 0 || !unit.hasTile()) {
            return null;
        }
        if (logMe == null) {
            logMe = "moveRandomly";
        }
        Random aiRandom = this.getAIRandom();
        if (direction == null) {
            direction = Direction.getRandomDirection(logMe, logger, aiRandom);
        }
        for (Direction d : directions = direction.getClosestDirections(logMe, logger, aiRandom)) {
            Tile moveTo = unit.getTile().getNeighbourOrNull(d);
            if (moveTo == null || unit.getMoveType(d) != Unit.MoveType.MOVE || !this.aiUnit.move(d)) continue;
            return d;
        }
        return null;
    }

    protected void moveRandomlyTurn(String logMe) {
        Direction direction = null;
        while ((direction = this.moveRandomly(logMe, direction)) != null) {
        }
        this.getUnit().setMovesLeft(0);
    }

    protected static Settlement getBestSettlement(Player player) {
        Comparator<Settlement> comp = CollectionUtils.cachingIntComparator(s -> {
            int value = s.getUnitCount() + s.getTile().getUnitCount();
            if (s instanceof Colony) {
                Colony colony = (Colony)s;
                value += (colony.isConnectedPort() ? 10 : 0) + colony.getAvailableWorkLocationsList().size();
            }
            return value;
        });
        return CollectionUtils.maximize(player.getSettlements(), comp);
    }

    protected Unit.MoveType travelToTarget(Location target, CostDecider costDecider, LogBuilder lb) {
        if (target == null) {
            return Unit.MoveType.MOVE_ILLEGAL;
        }
        Tile targetTile = target.getTile();
        if (!(target instanceof Europe) && targetTile == null) {
            throw new RuntimeException("Target neither Europe nor Tile: " + target);
        }
        Unit unit = this.getUnit();
        AIUnit aiCarrier = this.aiUnit.getTransport();
        Map map = unit.getGame().getMap();
        PathNode path = null;
        boolean useTransport = false;
        target = Location.upLoc(target);
        if (unit.isAtSea()) {
            lb.add(", at sea");
            return Unit.MoveType.MOVE_HIGH_SEAS;
        }
        if (unit.isOnCarrier()) {
            lb.add(", on carrier");
            return Unit.MoveType.MOVE_NO_ACCESS_EMBARK;
        }
        if (unit.isAtLocation(target)) {
            return Unit.MoveType.MOVE;
        }
        if (unit.isInEurope()) {
            if (!unit.getOwner().canMoveToEurope()) {
                lb.add(", impossible move from Europe");
                return Unit.MoveType.MOVE_ILLEGAL;
            }
            if (unit.getType().canMoveToHighSeas()) {
                unit.setDestination(target);
                if (AIMessage.askMoveTo(this.aiUnit, map)) {
                    lb.add(", sailed for ", target);
                    return Unit.MoveType.MOVE_HIGH_SEAS;
                }
                lb.add(", failed to sail for ", target);
                return Unit.MoveType.MOVE_ILLEGAL;
            }
            useTransport = true;
        } else {
            if (!unit.hasTile()) {
                return Unit.MoveType.MOVE_ILLEGAL;
            }
            if (target instanceof Europe) {
                if (!unit.getOwner().canMoveToEurope()) {
                    lb.add(", impossible move to Europe");
                    return Unit.MoveType.MOVE_ILLEGAL;
                }
                if (!unit.getType().canMoveToHighSeas() || aiCarrier != null) {
                    useTransport = true;
                } else {
                    path = unit.findPath(unit.getLocation(), target, null, costDecider, null);
                }
            } else if (aiCarrier != null) {
                useTransport = true;
            } else if (!unit.getType().canMoveToHighSeas() && !Map.isSameContiguity(target, unit.getLocation())) {
                useTransport = true;
            } else {
                path = unit.findPath(unit.getLocation(), target, null, costDecider, null);
            }
        }
        if (useTransport) {
            if (aiCarrier != null) {
                boolean waiting = false;
                TransportMission tm = aiCarrier.getMission(TransportMission.class);
                if (tm == null) {
                    lb.add(", had bogus carrier ", aiCarrier.getUnit());
                    logger.warning(unit + " has transport " + aiCarrier + " without transport mission");
                    this.aiUnit.dropTransport();
                    aiCarrier = null;
                } else {
                    Location pick = tm.getTransportTarget(this.aiUnit);
                    if (pick == null) {
                        lb.add(", had bogus transport on ", aiCarrier.getUnit());
                        logger.warning(unit + " has transport " + aiCarrier + " with transport mission but null transport target\n" + tm.toFullString());
                        this.aiUnit.dropTransport();
                        aiCarrier = null;
                    } else if (Map.isSameLocation(pick, unit.getLocation())) {
                        waiting = true;
                    } else {
                        path = unit.findPath(unit.getLocation(), pick, null, costDecider, null);
                        if (path == null) {
                            this.lbAt(lb);
                            lb.add(", no path to meet ", aiCarrier.getUnit(), " at ", pick);
                            path = unit.findPath(unit.getLocation(), target, null, costDecider, null);
                            if (path == null) {
                                return Unit.MoveType.MOVE_NO_TILE;
                            }
                            lb.add(", dropped carrier");
                            this.aiUnit.dropTransport();
                            aiCarrier = null;
                            useTransport = false;
                        } else {
                            int pathTurns;
                            int ownTurns;
                            PathNode ownPath = unit.findPath(unit.getLocation(), target, null, costDecider, null);
                            if (ownPath == null || (ownTurns = ownPath.getTotalTurns()) > (pathTurns = path.getTotalTurns())) {
                                Unit.MoveType ret = this.followMapPath(path.next, lb);
                                if (ret != Unit.MoveType.MOVE) {
                                    return ret;
                                }
                                waiting = true;
                            } else {
                                lb.add(", dropping carrier", aiCarrier.getUnit(), " as it is faster (", ownTurns, "<", pathTurns, " without it");
                                this.aiUnit.dropTransport();
                                aiCarrier = null;
                                path = ownPath;
                                useTransport = false;
                            }
                        }
                    }
                }
                if (waiting) {
                    this.lbAt(lb);
                    lb.add(", wait for ", aiCarrier.getUnit());
                    return aiCarrier.getUnit().getMovesLeft() > 0 ? Unit.MoveType.MOVE_NO_ACCESS_EMBARK : Unit.MoveType.MOVE_NO_MOVES;
                }
            }
            if (useTransport && aiCarrier == null) {
                lb.add(", needs transport to ", target);
                return Unit.MoveType.MOVE_NO_ACCESS_EMBARK;
            }
        }
        if (path == null) {
            this.lbAt(lb);
            lb.add(", no path to ", target);
            return Unit.MoveType.MOVE_NO_TILE;
        }
        if (path.next == null) {
            throw new IllegalStateException("Trivial path found " + path.fullPathToString() + " from " + unit.getLocation() + " to target " + target + " result=" + unit.isAtLocation(target));
        }
        return this.followMapPath(path.next, lb);
    }

    private Unit.MoveType followMapPath(PathNode path, LogBuilder lb) {
        Unit unit = this.getUnit();
        Location target = path.getLastNode().getLocation();
        while (path != null) {
            if (unit.isDisposed()) {
                lb.add(", died going to ", Location.upLoc(path.getLocation()));
                return Unit.MoveType.MOVE_NO_REPAIR;
            }
            if (unit.getMovesLeft() <= 0) {
                this.lbAt(lb);
                lb.add(", en route to ", Location.upLoc(target));
                return Unit.MoveType.MOVE_NO_MOVES;
            }
            if (path.getLocation() instanceof Europe) {
                if (AIMessage.askMoveTo(this.aiUnit, path.getLocation())) {
                    lb.add(", sailed to Europe");
                    return Unit.MoveType.MOVE_HIGH_SEAS;
                }
                lb.add(", failed to sail for Europe");
                return Unit.MoveType.MOVE_ILLEGAL;
            }
            Unit.MoveType mt = unit.getMoveType(path.getDirection());
            if (mt == Unit.MoveType.MOVE_NO_MOVES) {
                unit.setMovesLeft(0);
                this.lbAt(lb);
                return Unit.MoveType.MOVE_NO_MOVES;
            }
            if (!mt.isProgress()) {
                return mt;
            }
            if (!this.aiUnit.move(path.getDirection())) {
                this.lbAt(lb);
                lb.add(", failed to move to ", Location.upLoc(path.getLocation()));
                return Unit.MoveType.MOVE_ILLEGAL;
            }
            path = path.next;
        }
        return Unit.MoveType.MOVE;
    }

    public Mission retargetMission(String reason, LogBuilder lb) {
        lb.add(", failing(", reason, ")");
        Location newTarget = this.findTarget();
        if (newTarget != null) {
            this.setTarget(newTarget);
            return this.lbRetarget(lb);
        }
        lb.add(", retarget failed");
        return this.lbDrop(lb, new Object[0]);
    }

    @Override
    public void dispose() {
    }

    public int getBaseTransportPriority() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public Location getTransportDestination() {
        void var1_1;
        Location loc;
        return !this.isValid() ? null : ((loc = this.getTarget()) == null ? null : (!this.getUnit().shouldTakeTransportTo(loc) ? null : var1_1));
    }

    public abstract Location getTarget();

    public abstract void setTarget(Location var1);

    public abstract Location findTarget();

    public boolean isOneTime() {
        return false;
    }

    public abstract String invalidReason();

    public abstract Mission doMission(LogBuilder var1);

    @Override
    public final void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        if (this.isValid()) {
            this.toXML(xw, this.getXMLTagName());
        }
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
    }

    @Override
    public String toString() {
        LogBuilder lb = new LogBuilder(64);
        lb.add(StringUtils.lastPart(this.getClass().getName(), "."), "@", this.hashCode(), "-", this.aiUnit.getUnit(), "->", this.getTarget());
        return lb.toString();
    }
}

