%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/broken-crescendo-hairpin.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: a8a85e19654e46d725563e6deba44083ef137a2c
  texidocja = "
クレッシェンドのヘアピンの一部を非表示にするには、@c
白い長方形を対応する部分の上から描画します。@c
長方形は、テキスト マークアップの内部で PostScript コードとして定義します。

マークアップ コマンド @code{with-dimensions} は、スペーシングの際に
(訳注: y 軸方向のバウンディングボックスを @code{#'(0 . 0)} にすることで)
長方形の下端部分のみが考慮されるようにし、@c
@code{staff-padding} プロパティは、長方形がヘアピンと譜の間に配置されないよう@c
にしています。

ヘアピンが長方形によって隠されるために、ヘアピンのレイヤをテキスト
マークアップよりも低く設定してください。
"
  doctitleja = "一部が隠されたクレッシェンドのヘアピン"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
Une portion d'un soufflet de crescendo peut être rendue invisible.
Il suffit pour cela de dessiner un rectangle par dessus ce tronçon, ce
qui aura pour effet de le rendre invisible.  Ce rectangle est défini au
sein d'un @emph{markup} par du code PostScript.

La commande de @emph{markup} @code{with-dimensions} indique à LilyPond
de ne prendre en considération que l'extrémité inférieure du rectangle
lors de son positionnement par rapport au soufflet.  L'ajustement de la
propriété @code{staff-padding} permet d'éviter au rectangle de venir
s'intercaler entre le soufflet et la portée.

Le soufflet doit se trouver à un niveau inférieur à celui du @emph{markup}
afin que le dessin du rectangle puisse effectivement le recouvrir.
"

  doctitlefr = "Soufflet de crescendo partiellement interrompu"

%% Translation of GIT committish: 8ffecf6be17c6ec2ff87cf31873121a8cce29b09
  texidoces = "
Para hacer invisibles partes de un regulador de crescendo, se usa el
método de dibujar un rectángulo blanco encima de la parte respectiva
del regulador, tapándola.  El rectángulo se define como código de
postscript dentro de un elemento de marcado de texto.

La instrucción de marcado @code{with-dimensions} indica a LilyPond que
considere solamente el extremo inferior del rectángulo cuando realice
el espaciado de éste frente al regulador.  La propiedad
@code{staff-padding} evita que el rectángulo quepa entre el regulador
y el pentagrama.

Asegúrse de que el regulador está en una capa más baja que el
elemento de marcado de texto para trazar el rectángulo encima del
regulador.

"
  doctitlees = "Regulador interrumpido"

%% Translation of GIT committish: 8ffecf6be17c6ec2ff87cf31873121a8cce29b09
  texidocca = "
Per fer invisibles parts d'un regulador de crescendo, s'usa el
mètode de dibuixar un rectangle blanc a sobre de la respectiva
del regulador, tapant-la.  El rectangle es defineix com codi de
postscript dins d'un element de marcatge de text.

L'ordre de marcatge @code{with-dimensions} indica al LilyPond que
consideri sols l'extrem inferior del rectangle quan realitzi
l'espaiat d'aquest rectangle frente al regulador.  La propietat
@code{staff-padding} evita que el rectangle càpiga entre el regulador
i el pentagrama.

Assegureu-vos que el regulador està a una capa més baixa que l'element
de marcatge de text per traçar el rectangle a sobre del regulador.

"
  doctitleca = "Regulador interromput"

  lsrtags = "contemporary-notation, expressive-marks, symbols-and-glyphs"

  texidoc = "
In order to make parts of a crescendo hairpin invisible, the following
method is used: A white rectangle is drawn on top of the respective
part of the crescendo hairpin, making it invisible.  The rectangle is
defined as postscript code within a text markup.

The markup command @code{with-dimensions} tells LilyPond to consider
only the bottom edge of the rectangle when spacing it against the
hairpin. The property @code{staff-padding} prevents the rectangle from
fitting between the hairpin and staff.

Make sure the hairpin is in a lower layer than the text markup to draw
the rectangle over the hairpin.
"

  doctitle = "Broken Crescendo Hairpin"
} % begin verbatim


\relative c' {
  <<
    {
      \dynamicUp
      r2 r16 c'8.\pp r4
    }
    \\
    {
      \override DynamicLineSpanner.layer = #0
      des,2\mf\< ~
      \override TextScript.layer = #2
      \once\override TextScript.staff-padding = #6
      \once\override TextScript.vertical-skylines = #'()
      des16_\markup \with-dimensions #'(2 . 7) #'(0 . 0)
                    \with-color #white
                    \filled-box #'(2 . 7) #'(0 . 2) #0
      r8. des4 ~ des16->\sff r8.
    }
  >>
}



% ****************************************************************
% end ly snippet
% ****************************************************************
