/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.CapacityReportInstanceShapeConfig;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CapacityReportShapeAvailability
extends ExplicitlySetBmcModel {
    @JsonProperty(value="faultDomain")
    private final String faultDomain;
    @JsonProperty(value="instanceShape")
    private final String instanceShape;
    @JsonProperty(value="instanceShapeConfig")
    private final CapacityReportInstanceShapeConfig instanceShapeConfig;
    @JsonProperty(value="availableCount")
    private final Long availableCount;
    @JsonProperty(value="availabilityStatus")
    private final AvailabilityStatus availabilityStatus;

    @Deprecated
    @ConstructorProperties(value={"faultDomain", "instanceShape", "instanceShapeConfig", "availableCount", "availabilityStatus"})
    public CapacityReportShapeAvailability(String faultDomain, String instanceShape, CapacityReportInstanceShapeConfig instanceShapeConfig, Long availableCount, AvailabilityStatus availabilityStatus) {
        this.faultDomain = faultDomain;
        this.instanceShape = instanceShape;
        this.instanceShapeConfig = instanceShapeConfig;
        this.availableCount = availableCount;
        this.availabilityStatus = availabilityStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getFaultDomain() {
        return this.faultDomain;
    }

    public String getInstanceShape() {
        return this.instanceShape;
    }

    public CapacityReportInstanceShapeConfig getInstanceShapeConfig() {
        return this.instanceShapeConfig;
    }

    public Long getAvailableCount() {
        return this.availableCount;
    }

    public AvailabilityStatus getAvailabilityStatus() {
        return this.availabilityStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CapacityReportShapeAvailability(");
        sb.append("super=").append(super.toString());
        sb.append("faultDomain=").append(String.valueOf(this.faultDomain));
        sb.append(", instanceShape=").append(String.valueOf(this.instanceShape));
        sb.append(", instanceShapeConfig=").append(String.valueOf((Object)this.instanceShapeConfig));
        sb.append(", availableCount=").append(String.valueOf(this.availableCount));
        sb.append(", availabilityStatus=").append(String.valueOf((Object)this.availabilityStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CapacityReportShapeAvailability)) {
            return false;
        }
        CapacityReportShapeAvailability other = (CapacityReportShapeAvailability)((Object)o);
        return Objects.equals(this.faultDomain, other.faultDomain) && Objects.equals(this.instanceShape, other.instanceShape) && Objects.equals((Object)this.instanceShapeConfig, (Object)other.instanceShapeConfig) && Objects.equals(this.availableCount, other.availableCount) && Objects.equals((Object)this.availabilityStatus, (Object)other.availabilityStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.faultDomain == null ? 43 : this.faultDomain.hashCode());
        result = result * 59 + (this.instanceShape == null ? 43 : this.instanceShape.hashCode());
        result = result * 59 + (this.instanceShapeConfig == null ? 43 : this.instanceShapeConfig.hashCode());
        result = result * 59 + (this.availableCount == null ? 43 : this.availableCount.hashCode());
        result = result * 59 + (this.availabilityStatus == null ? 43 : this.availabilityStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AvailabilityStatus implements BmcEnum
    {
        OutOfHostCapacity("OUT_OF_HOST_CAPACITY"),
        HardwareNotSupported("HARDWARE_NOT_SUPPORTED"),
        Available("AVAILABLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AvailabilityStatus> map;

        private AvailabilityStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AvailabilityStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AvailabilityStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AvailabilityStatus.class);
            map = new HashMap<String, AvailabilityStatus>();
            for (AvailabilityStatus v : AvailabilityStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="faultDomain")
        private String faultDomain;
        @JsonProperty(value="instanceShape")
        private String instanceShape;
        @JsonProperty(value="instanceShapeConfig")
        private CapacityReportInstanceShapeConfig instanceShapeConfig;
        @JsonProperty(value="availableCount")
        private Long availableCount;
        @JsonProperty(value="availabilityStatus")
        private AvailabilityStatus availabilityStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            this.__explicitlySet__.add("faultDomain");
            return this;
        }

        public Builder instanceShape(String instanceShape) {
            this.instanceShape = instanceShape;
            this.__explicitlySet__.add("instanceShape");
            return this;
        }

        public Builder instanceShapeConfig(CapacityReportInstanceShapeConfig instanceShapeConfig) {
            this.instanceShapeConfig = instanceShapeConfig;
            this.__explicitlySet__.add("instanceShapeConfig");
            return this;
        }

        public Builder availableCount(Long availableCount) {
            this.availableCount = availableCount;
            this.__explicitlySet__.add("availableCount");
            return this;
        }

        public Builder availabilityStatus(AvailabilityStatus availabilityStatus) {
            this.availabilityStatus = availabilityStatus;
            this.__explicitlySet__.add("availabilityStatus");
            return this;
        }

        public CapacityReportShapeAvailability build() {
            CapacityReportShapeAvailability model = new CapacityReportShapeAvailability(this.faultDomain, this.instanceShape, this.instanceShapeConfig, this.availableCount, this.availabilityStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CapacityReportShapeAvailability model) {
            if (model.wasPropertyExplicitlySet("faultDomain")) {
                this.faultDomain(model.getFaultDomain());
            }
            if (model.wasPropertyExplicitlySet("instanceShape")) {
                this.instanceShape(model.getInstanceShape());
            }
            if (model.wasPropertyExplicitlySet("instanceShapeConfig")) {
                this.instanceShapeConfig(model.getInstanceShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("availableCount")) {
                this.availableCount(model.getAvailableCount());
            }
            if (model.wasPropertyExplicitlySet("availabilityStatus")) {
                this.availabilityStatus(model.getAvailabilityStatus());
            }
            return this;
        }
    }
}

