/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.document;

import javax.swing.text.BadLocationException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.editor.document.implspi.CharClassifier;

public class TextSearchUtils {
    public static final CharClassifier DEFAULT_CLASSIFIER = new CharClassifier(){

        @Override
        public boolean isIdentifierPart(char ch) {
            return Character.isLetterOrDigit(ch);
        }

        @Override
        public boolean isWhitespace(char ch) {
            return Character.isWhitespace(ch);
        }
    };

    private TextSearchUtils() {
    }

    public static int getWordStart(@NonNull CharSequence text, @NonNull CharClassifier classifier, int offset) throws BadLocationException {
        int limitOffset = 0;
        boolean inIdentifier = false;
        boolean inPunct = false;
        for (int i = offset - 1; i >= limitOffset; --i) {
            char ch = text.charAt(i);
            if (ch == '\n') {
                return i == offset - 1 ? i : i + 1;
            }
            if (classifier.isWhitespace(ch)) {
                if (!inIdentifier && !inPunct) continue;
                return i + 1;
            }
            boolean identifierChar = classifier.isIdentifierPart(ch);
            if (inIdentifier && !identifierChar) {
                return i + 1;
            }
            if (inPunct && identifierChar) {
                return i + 1;
            }
            if (identifierChar) {
                inIdentifier = true;
                continue;
            }
            inPunct = true;
        }
        return limitOffset;
    }

    public static int getWordEnd(@NonNull CharSequence text, @NonNull CharClassifier classifier, int offset) {
        int limitOffset = text.length();
        boolean inWhitespace = false;
        boolean inIdentifier = false;
        boolean inPunct = false;
        for (int i = offset; i < limitOffset; ++i) {
            char ch = text.charAt(i);
            if (ch == '\n') {
                return i == offset && i + 1 < limitOffset ? i + 1 : i;
            }
            if (classifier.isWhitespace(ch)) {
                if (inIdentifier) {
                    return i;
                }
                inWhitespace = true;
                continue;
            }
            if (inWhitespace) {
                return i;
            }
            boolean identifierChar = classifier.isIdentifierPart(ch);
            if (inIdentifier && !identifierChar) {
                return i;
            }
            if (inPunct && identifierChar) {
                return i;
            }
            if (identifierChar) {
                inIdentifier = true;
                continue;
            }
            inPunct = true;
        }
        return limitOffset;
    }

    public static CharSequence getWord(@NonNull CharSequence text, @NonNull CharClassifier classifier, int wordStartOffset) throws BadLocationException {
        int wordEnd = TextSearchUtils.getWordEnd(text, classifier, wordStartOffset);
        return text.subSequence(wordStartOffset, wordEnd);
    }

    public static int getNextWordStart(@NonNull CharSequence text, @NonNull CharClassifier classifier, int offset) {
        int limitOffset = text.length();
        boolean inWhitespace = false;
        boolean inIdentifier = false;
        boolean inPunct = false;
        for (int i = offset; i < limitOffset; ++i) {
            char ch = text.charAt(i);
            if (ch == '\n') {
                return i != offset ? i : i + 1;
            }
            if (classifier.isWhitespace(ch)) {
                inWhitespace = true;
                continue;
            }
            if (inWhitespace) {
                return i;
            }
            boolean identifierChar = classifier.isIdentifierPart(ch);
            if (inIdentifier && !identifierChar) {
                return i;
            }
            if (inPunct && identifierChar) {
                return i;
            }
            if (identifierChar) {
                inIdentifier = true;
                continue;
            }
            inPunct = true;
        }
        return limitOffset;
    }

    public static int getPreviousWordEnd(@NonNull CharSequence text, @NonNull CharClassifier classifier, int offset) {
        int limitOffset = 0;
        boolean inWhitespace = false;
        boolean inIdentifier = false;
        boolean inPunct = false;
        for (int i = offset - 1; i >= limitOffset; --i) {
            char ch = text.charAt(i);
            if (ch == '\n') {
                return i == offset - 1 ? i : i + 1;
            }
            if (classifier.isWhitespace(ch)) {
                inWhitespace = true;
                continue;
            }
            if (inWhitespace) {
                return i + 1;
            }
            boolean identifierChar = classifier.isIdentifierPart(ch);
            if (inIdentifier && !identifierChar) {
                return i + 1;
            }
            if (inPunct && identifierChar) {
                return i + 1;
            }
            if (identifierChar) {
                inIdentifier = true;
                continue;
            }
            inPunct = true;
        }
        return limitOffset;
    }

    public static int getPreviousWordStart(@NonNull CharSequence text, @NonNull CharClassifier classifier, int offset) {
        int limitOffset = 0;
        boolean inWhitespace = false;
        boolean inIdentifier = false;
        boolean inPunct = false;
        for (int i = offset - 1; i >= limitOffset; --i) {
            char ch = text.charAt(i);
            if (ch == '\n') {
                return i == offset - 1 ? i : i + 1;
            }
            if (classifier.isWhitespace(ch)) {
                if (inIdentifier || inPunct) {
                    return i + 1;
                }
                inWhitespace = true;
                continue;
            }
            boolean identifierChar = classifier.isIdentifierPart(ch);
            if (inWhitespace) {
                inWhitespace = false;
                if (identifierChar) {
                    inIdentifier = true;
                    continue;
                }
                inPunct = true;
                continue;
            }
            if (inIdentifier && !identifierChar) {
                return i + 1;
            }
            if (inPunct && identifierChar) {
                return i + 1;
            }
            if (identifierChar) {
                inIdentifier = true;
                continue;
            }
            inPunct = true;
        }
        return limitOffset;
    }

    public static int getNextWhitespace(@NonNull CharSequence text, @NonNull CharClassifier classifier, int offset, int limitOffset) {
        for (int i = offset; i < limitOffset; ++i) {
            char ch = text.charAt(i);
            if (!classifier.isWhitespace(ch)) continue;
            return i;
        }
        return -1;
    }

    public static int getPreviousWhitespace(@NonNull CharSequence text, @NonNull CharClassifier classifier, int offset, int limitOffset) {
        for (int i = offset - 1; i >= limitOffset; --i) {
            char ch = text.charAt(i);
            if (!classifier.isWhitespace(ch)) continue;
            return i;
        }
        return -1;
    }

    public static int getNextNonWhitespace(@NonNull CharSequence text, @NonNull CharClassifier classifier, int offset, int limitOffset) {
        for (int i = offset; i < limitOffset; ++i) {
            char ch = text.charAt(i);
            if (classifier.isWhitespace(ch)) continue;
            return i;
        }
        return -1;
    }

    public static int getPreviousNonWhitespace(@NonNull CharSequence text, @NonNull CharClassifier classifier, int offset, int limitOffset) {
        for (int i = offset - 1; i >= limitOffset; --i) {
            char ch = text.charAt(i);
            if (classifier.isWhitespace(ch)) continue;
            return i;
        }
        return -1;
    }

    public static int getNextNonNewline(@NonNull CharSequence text, int offset, int limitOffset) {
        for (int i = offset; i < limitOffset; ++i) {
            if (text.charAt(i) == '\n') continue;
            return i;
        }
        return -1;
    }

    public static int getPreviousNonNewline(@NonNull CharSequence text, int offset, int limitOffset) {
        for (int i = offset - 1; i >= limitOffset; --i) {
            if (text.charAt(i) == '\n') continue;
            return i;
        }
        return -1;
    }

    public static boolean isLineEmpty(@NonNull CharSequence text, int offset) {
        if (text.charAt(offset) != '\n') {
            return false;
        }
        return offset <= 0 || text.charAt(offset - 1) == '\n';
    }
}

