/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayDimension;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.ConditionalExpression;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantVariable;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.ParenthesisExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Quote;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticStatement;
import org.netbeans.modules.php.editor.parser.astnodes.UnaryOperation;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public final class PHP83UnhandledError
extends UnhandledErrorRule {
    public String getDisplayName() {
        return Bundle.PHP83UnhandledError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Error> errors) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && PHP83UnhandledError.appliesTo(fileObject)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            errors.addAll(checkVisitor.getErrors());
        }
    }

    private static boolean appliesTo(FileObject fileObject) {
        return CodeUtils.isPhpVersionLessThan(fileObject, PhpVersion.PHP_83);
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final List<VerificationError> errors = new ArrayList<VerificationError>();
        private final FileObject fileObject;

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public Collection<VerificationError> getErrors() {
            return Collections.unmodifiableCollection(this.errors);
        }

        @Override
        public void visit(StaticConstantAccess node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.isDynamicName()) {
                this.createError(node.getConstant());
            }
            super.visit(node);
        }

        @Override
        public void visit(ConstantDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.getConstType() != null) {
                this.createError(node.getConstType());
            }
            super.visit(node);
        }

        @Override
        public void visit(StaticStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            for (Expression expression : node.getExpressions()) {
                Assignment assignment;
                Expression rightHandSide;
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (!(expression instanceof Assignment) || this.isStaticScalarValueExpression(rightHandSide = (assignment = (Assignment)expression).getRightHandSide())) continue;
                this.createError(node);
                break;
            }
            super.visit(node);
        }

        private boolean isStaticScalarValueExpression(Expression expression) {
            block20: {
                block18: {
                    block23: {
                        block22: {
                            block21: {
                                block19: {
                                    if (expression != null && !this.isStaticScalarValue(expression) && !this.isStaticOperation(expression)) {
                                        return false;
                                    }
                                    if (!this.isStaticOperation(expression)) break block18;
                                    if (!(expression instanceof InfixExpression)) break block19;
                                    InfixExpression infixExpression = (InfixExpression)expression;
                                    if (!this.isStaticScalarValueExpression(infixExpression.getLeft()) || !this.isStaticScalarValueExpression(infixExpression.getRight())) {
                                        return false;
                                    }
                                    break block20;
                                }
                                if (!(expression instanceof UnaryOperation)) break block21;
                                UnaryOperation unaryOperation = (UnaryOperation)expression;
                                if (!this.isStaticScalarValueExpression(unaryOperation.getExpression())) {
                                    return false;
                                }
                                break block20;
                            }
                            if (!(expression instanceof ConditionalExpression)) break block22;
                            ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
                            if (!(this.isStaticScalarValueExpression(conditionalExpression.getIfTrue()) && this.isStaticScalarValueExpression(conditionalExpression.getIfFalse()) && this.isStaticScalarValueExpression(conditionalExpression.getCondition()))) {
                                return false;
                            }
                            break block20;
                        }
                        if (!(expression instanceof ArrayCreation)) break block23;
                        ArrayCreation arrayCreation = (ArrayCreation)expression;
                        List<ArrayElement> elements = arrayCreation.getElements();
                        for (ArrayElement element : elements) {
                            if (this.isStaticScalarValueExpression(element.getKey()) && this.isStaticScalarValueExpression(element.getValue())) continue;
                            return false;
                        }
                        break block20;
                    }
                    if (!(expression instanceof ExpressionArrayAccess)) break block20;
                    ExpressionArrayAccess expressionArrayAccess = (ExpressionArrayAccess)expression;
                    Expression expr = expressionArrayAccess.getExpression();
                    ArrayDimension dimension = expressionArrayAccess.getDimension();
                    if (!(expr instanceof Identifier) && !this.isStaticScalarValueExpression(expr) || !this.isStaticScalarValueExpression(dimension.getIndex())) {
                        return false;
                    }
                    break block20;
                }
                if (this.isNewExpression(expression)) {
                    ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression;
                    ClassName className = classInstanceCreation.getClassName();
                    if ("static".equals(CodeUtils.extractClassName(className)) || !this.isStaticScalarValueExpression(className.getName()) || className.getName() instanceof ParenthesisExpression) {
                        return false;
                    }
                    for (Expression param : classInstanceCreation.ctorParams()) {
                        if (this.isStaticScalarValueExpression(param)) continue;
                        return false;
                    }
                } else if (expression instanceof FieldAccess) {
                    FieldAccess fieldAccess = (FieldAccess)expression;
                    VariableBase dispatcher = fieldAccess.getDispatcher();
                    if (!(dispatcher instanceof ConstantVariable) && !(dispatcher instanceof StaticConstantAccess)) {
                        return false;
                    }
                } else if (expression instanceof StaticConstantAccess) {
                    StaticConstantAccess staticConstantAccess = (StaticConstantAccess)expression;
                    Expression constant = staticConstantAccess.getConstant();
                    if (!(constant instanceof Identifier) && !this.isStaticScalarValueExpression(constant)) {
                        return false;
                    }
                } else if (expression instanceof Quote) {
                    Quote quote = (Quote)expression;
                    for (Expression expr : quote.getExpressions()) {
                        if (this.isStaticScalarValueExpression(expr)) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        private boolean isStaticScalarValue(Expression expression) {
            return expression instanceof Scalar || expression instanceof NamespaceName || expression instanceof StaticConstantAccess || expression instanceof FieldAccess || expression instanceof Quote && ((Quote)expression).getQuoteType() == Quote.Type.HEREDOC || this.isNewExpression(expression);
        }

        private boolean isNewExpression(Expression expression) {
            return expression instanceof ClassInstanceCreation && !((ClassInstanceCreation)expression).isAnonymous();
        }

        private boolean isStaticOperation(Expression expression) {
            return expression instanceof ExpressionArrayAccess || expression instanceof ArrayCreation || expression instanceof InfixExpression || expression instanceof UnaryOperation || expression instanceof ConditionalExpression;
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
        }

        private void createError(OffsetRange offsetRange) {
            this.errors.add(new PHP83VersionError(this.fileObject, offsetRange.getStart(), offsetRange.getEnd()));
        }

        private void createError(int startOffset, int endOffset) {
            this.errors.add(new PHP83VersionError(this.fileObject, startOffset, endOffset));
        }
    }

    private static final class PHP83VersionError
    extends VerificationError {
        private static final String KEY = "Php.Version.83";

        private PHP83VersionError(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.PHP83VersionError_displayName();
        }

        public String getDescription() {
            return Bundle.PHP83VersionError_description();
        }

        public String getKey() {
            return KEY;
        }
    }
}

