/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class IncorrectNonAbstractMethodHintError
extends HintErrorRule {
    private FileObject fileObject;

    public String getDisplayName() {
        return Bundle.IncorrectNonAbstractMethodHintErrorDisplayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileScope fileScope = context.fileScope;
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && this.fileObject != null) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor();
            phpParseResult.getProgram().accept(checkVisitor);
            Set<MethodDeclaration> incorrectNonAbstractMethods = checkVisitor.getIncorrectNonAbstractMethods();
            this.addIcorrectNonAbstractMethodHints(incorrectNonAbstractMethods, hints, context.doc);
        }
    }

    private void addIcorrectNonAbstractMethodHints(Set<MethodDeclaration> methodDeclarations, List<Hint> hints, BaseDocument doc) {
        for (MethodDeclaration methodDeclaration : methodDeclarations) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            List<HintFix> fixes = Collections.singletonList(new AddBodyFix(doc, methodDeclaration));
            this.addHint(methodDeclaration, Bundle.IncorrectNonAbstractMethodHintErrorHintDesc(CodeUtils.extractMethodName(methodDeclaration)), hints, fixes);
        }
    }

    private void addHint(ASTNode node, String description, List<Hint> hints, List<HintFix> fixes) {
        hints.add(new Hint((Rule)this, description, this.fileObject, new OffsetRange(node.getStartOffset(), node.getEndOffset()), fixes, 500));
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final Set<MethodDeclaration> incorrectNonAbstractMethods = new HashSet<MethodDeclaration>();

        private CheckVisitor() {
        }

        @Override
        public void visit(MethodDeclaration node) {
            FunctionDeclaration function;
            Block body;
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!BodyDeclaration.Modifier.isAbstract(node.getModifier()) && (body = (function = node.getFunction()).getBody()) == null) {
                this.incorrectNonAbstractMethods.add(node);
            }
        }

        public Set<MethodDeclaration> getIncorrectNonAbstractMethods() {
            return Collections.unmodifiableSet(this.incorrectNonAbstractMethods);
        }
    }

    private static final class AddBodyFix
    implements HintFix {
        private final BaseDocument doc;
        private final MethodDeclaration methodDeclaration;

        public AddBodyFix(BaseDocument doc, MethodDeclaration methodDeclaration) {
            this.doc = doc;
            this.methodDeclaration = methodDeclaration;
        }

        public String getDescription() {
            return Bundle.AddBodyFixDesc(CodeUtils.extractMethodName(this.methodDeclaration));
        }

        public void implement() throws Exception {
            EditList edhitList = new EditList(this.doc);
            int startOffset = this.methodDeclaration.getStartOffset();
            int textLength = this.methodDeclaration.getEndOffset() - this.methodDeclaration.getStartOffset();
            String text = this.doc.getText(startOffset, textLength);
            String insertText = text.substring(0, textLength - 1) + "{}";
            edhitList.replace(startOffset, textLength, insertText, true, 0);
            edhitList.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

