/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projectsui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.jpda.projects.FixClassesSupport;
import org.netbeans.modules.debugger.jpda.projects.SourcePathProviderImpl;
import org.netbeans.modules.debugger.jpda.projectsui.MainProjectManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.project.ActionProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class FixActionProvider
extends ActionsProviderSupport {
    private JPDADebugger debugger;
    private SourcePathProvider sp;
    private Listener listener;
    private boolean isFixCommandSupported;

    public FixActionProvider(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.sp = this.getSourcePathProvider(lookupProvider);
        this.listener = new Listener();
        MainProjectManager.getDefault().addPropertyChangeListener(this.listener);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this.listener);
        FixClassesSupport.ClassesToReload.getInstance().addPropertyChangeListener((PropertyChangeListener)this.listener);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-java", (PropertyChangeListener)this.listener);
        this.setEnabled(ActionsManager.ACTION_FIX, this.shouldBeEnabled());
    }

    private SourcePathProvider getSourcePathProvider(ContextProvider lookupProvider) {
        List providers = lookupProvider.lookup(null, SourcePathProvider.class);
        for (SourcePathProvider p : providers) {
            if (!(p instanceof SourcePathProviderImpl)) continue;
            return p;
        }
        return (SourcePathProvider)providers.get(0);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this.listener);
        FixClassesSupport.ClassesToReload.getInstance().removePropertyChangeListener((PropertyChangeListener)this.listener);
        MainProjectManager.getDefault().removePropertyChangeListener(this.listener);
        EditorContextDispatcher.getDefault().removePropertyChangeListener((PropertyChangeListener)this.listener);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_FIX);
    }

    public void doAction(Object action) {
        if (!this.isFixCommandSupported) {
            Set<FileObject> sourceRootsFO = this.getSourceRootsFO(this.sp);
            Map classes = FixClassesSupport.ClassesToReload.getInstance().popClassesToReload(this.debugger, sourceRootsFO);
            FixClassesSupport.reloadClasses((JPDADebugger)this.debugger, (Map)classes);
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        FixActionProvider.this.invokeAction();
                    }
                });
            }
            catch (InterruptedException sourceRootsFO) {
            }
            catch (InvocationTargetException itex) {
                ErrorManager.getDefault().notify((Throwable)itex);
            }
        } else {
            this.invokeAction();
        }
    }

    private Set<FileObject> getSourceRootsFO(SourcePathProvider sp) {
        if (sp instanceof SourcePathProviderImpl) {
            return ((SourcePathProviderImpl)sp).getSourceRootsFO();
        }
        String[] sourceRoots = sp.getSourceRoots();
        HashSet<FileObject> fos = new HashSet<FileObject>();
        for (String root : sourceRoots) {
            FileObject fo;
            int jarIndex = root.indexOf("!/");
            if (jarIndex > 0) {
                fo = FileUtil.toFileObject((File)new File(root.substring(0, jarIndex)));
                fo = fo.getFileObject(root.substring(jarIndex + 2));
            } else {
                fo = FileUtil.toFileObject((File)new File(root));
            }
            if (fo == null) continue;
            fos.add(fo);
        }
        return fos;
    }

    private void invokeAction() {
        ((ActionProvider)this.getCurrentProject().getLookup().lookup(ActionProvider.class)).invokeAction("debug.fix", this.getLookup());
    }

    private Project getCurrentProject() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes == null || nodes.length == 0) {
            return MainProjectManager.getDefault().getMainProject();
        }
        DataObject dao = (DataObject)nodes[0].getLookup().lookup(DataObject.class);
        if (dao == null || !dao.isValid()) {
            return MainProjectManager.getDefault().getMainProject();
        }
        return FileOwnerQuery.getOwner((FileObject)dao.getPrimaryFile());
    }

    private boolean shouldBeEnabled() {
        ActionProvider actionProvider;
        if (!this.debugger.canFixClasses()) {
            return false;
        }
        this.isFixCommandSupported = false;
        Project p = this.getCurrentProject();
        if (p != null && (actionProvider = (ActionProvider)p.getLookup().lookup(ActionProvider.class)) != null) {
            int i;
            String[] sa = actionProvider.getSupportedActions();
            int k = sa.length;
            for (i = 0; i < k && !"debug.fix".equals(sa[i]); ++i) {
            }
            boolean bl = this.isFixCommandSupported = i < k && actionProvider.isActionEnabled("debug.fix", this.getLookup());
        }
        if (!this.isFixCommandSupported) {
            return FixClassesSupport.ClassesToReload.getInstance().hasClassesToReload(this.debugger, this.getSourceRootsFO(this.sp));
        }
        return true;
    }

    private Lookup getLookup() {
        FileObject fo;
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        int k = nodes.length;
        ArrayList<DataObject> l = new ArrayList<DataObject>();
        for (int i = 0; i < k; ++i) {
            DataObject dobj = (DataObject)nodes[i].getLookup().lookup(DataObject.class);
            if (dobj == null || !dobj.isValid()) continue;
            l.add(dobj);
        }
        if (l.isEmpty() && (fo = EditorContextDispatcher.getDefault().getMostRecentFile()) != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                l.add(dobj);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return Lookups.fixed((Object[])l.toArray(new DataObject[0]));
    }

    static void notifyError(String error) {
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)error, 0);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
        StatusDisplayer.getDefault().setStatusText(error);
    }

    private class Listener
    implements PropertyChangeListener,
    DebuggerManagerListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean en = FixActionProvider.this.shouldBeEnabled();
            FixActionProvider.this.setEnabled(ActionsManager.ACTION_FIX, en);
            if (FixActionProvider.this.debugger.getState() == 4) {
                FixActionProvider.this.destroy();
            }
        }

        public void sessionRemoved(Session session) {
        }

        public void breakpointAdded(Breakpoint breakpoint) {
        }

        public void breakpointRemoved(Breakpoint breakpoint) {
        }

        public Breakpoint[] initBreakpoints() {
            return new Breakpoint[0];
        }

        public void initWatches() {
        }

        public void sessionAdded(Session session) {
        }

        public void watchAdded(Watch watch) {
        }

        public void watchRemoved(Watch watch) {
        }

        public void engineAdded(DebuggerEngine engine) {
        }

        public void engineRemoved(DebuggerEngine engine) {
        }
    }
}

