/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.netbeans.validation.localization.LocalizationSupport;

final class EncodableInCharsetValidator
extends StringValidator {
    private final String charsetName;

    EncodableInCharsetValidator(String charsetName) {
        this.charsetName = charsetName;
        Charset.forName(charsetName);
    }

    EncodableInCharsetValidator() {
        this(Charset.defaultCharset().name());
    }

    @Override
    public void validate(Problems problems, String compName, String model) {
        char[] c = model.toCharArray();
        boolean result = true;
        for (int i = 0; i < c.length; ++i) {
            String curr = new String(new char[]{c[i]});
            try {
                String nue = new String(curr.getBytes(this.charsetName));
                boolean bl = result = c[i] == nue.charAt(0);
                if (result) continue;
                problems.append(LocalizationSupport.getMessage(EncodableInCharsetValidator.class, "INVALID_CHARACTER", compName, curr, this.charsetName));
                break;
            }
            catch (UnsupportedEncodingException ex) {
                throw new AssertionError((Object)ex);
            }
        }
    }
}

