/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.annotation;

import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.Operation;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.modeler.annotation.FaultInfo;
import com.sun.tools.ws.processor.modeler.annotation.ModelBuilder;
import com.sun.tools.ws.processor.modeler.annotation.WrapperInfo;
import com.sun.tools.ws.wsdl.document.soap.SOAPUse;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class AnnotationProcessorContext {
    private Map<Name, SeiContext> seiContextMap = new HashMap<Name, SeiContext>();
    private int round = 1;
    private boolean modelCompleted = false;

    public void addSeiContext(Name seiName, SeiContext seiContext) {
        this.seiContextMap.put(seiName, seiContext);
    }

    public SeiContext getSeiContext(Name seiName) {
        SeiContext context = this.seiContextMap.get(seiName);
        if (context == null) {
            context = new SeiContext();
            this.addSeiContext(seiName, context);
        }
        return context;
    }

    public SeiContext getSeiContext(TypeElement d) {
        return this.getSeiContext(d.getQualifiedName());
    }

    public Collection<SeiContext> getSeiContexts() {
        return this.seiContextMap.values();
    }

    public int getRound() {
        return this.round;
    }

    public void incrementRound() {
        ++this.round;
    }

    public static boolean isEncoded(Model model) {
        if (model == null) {
            return false;
        }
        for (Service service : model.getServices()) {
            for (Port port : service.getPorts()) {
                for (Operation operation : port.getOperations()) {
                    if (operation.getUse() == null || !operation.getUse().equals(SOAPUse.LITERAL)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void setModelCompleted(boolean modelCompleted) {
        this.modelCompleted = modelCompleted;
    }

    public boolean isModelCompleted() {
        return this.modelCompleted;
    }

    public static class SeiContext {
        private Map<String, WrapperInfo> reqOperationWrapperMap = new HashMap<String, WrapperInfo>();
        private Map<String, WrapperInfo> resOperationWrapperMap = new HashMap<String, WrapperInfo>();
        private Map<Name, FaultInfo> exceptionBeanMap = new HashMap<Name, FaultInfo>();
        private Name seiImplName;
        private boolean implementsSei;
        private String namespaceUri;

        public SeiContext() {
        }

        public SeiContext(Name seiName) {
        }

        public void setImplementsSei(boolean implementsSei) {
            this.implementsSei = implementsSei;
        }

        public boolean getImplementsSei() {
            return this.implementsSei;
        }

        public void setNamespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
        }

        public String getNamespaceUri() {
            return this.namespaceUri;
        }

        public Name getSeiImplName() {
            return this.seiImplName;
        }

        public void setSeiImplName(Name implName) {
            this.seiImplName = implName;
        }

        public void setReqWrapperOperation(ExecutableElement method, WrapperInfo wrapperInfo) {
            this.reqOperationWrapperMap.put(this.methodToString(method), wrapperInfo);
        }

        public WrapperInfo getReqOperationWrapper(ExecutableElement method) {
            return this.reqOperationWrapperMap.get(this.methodToString(method));
        }

        public void setResWrapperOperation(ExecutableElement method, WrapperInfo wrapperInfo) {
            this.resOperationWrapperMap.put(this.methodToString(method), wrapperInfo);
        }

        public WrapperInfo getResOperationWrapper(ExecutableElement method) {
            return this.resOperationWrapperMap.get(this.methodToString(method));
        }

        public String methodToString(ExecutableElement method) {
            StringBuilder buf = new StringBuilder(method.getSimpleName());
            for (VariableElement variableElement : method.getParameters()) {
                buf.append(';').append(variableElement.asType());
            }
            return buf.toString();
        }

        public void clearExceptionMap() {
            this.exceptionBeanMap.clear();
        }

        public void addExceptionBeanEntry(Name exception, FaultInfo faultInfo, ModelBuilder builder) {
            this.exceptionBeanMap.put(exception, faultInfo);
        }

        public FaultInfo getExceptionBeanName(Name exception) {
            return this.exceptionBeanMap.get(exception);
        }
    }
}

