/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.dashboard;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import org.netbeans.modules.ide.dashboard.Bundle;
import org.netbeans.spi.dashboard.DashboardDisplayer;
import org.netbeans.spi.dashboard.DashboardWidget;
import org.netbeans.spi.dashboard.WidgetElement;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class NetBeansWidget
implements DashboardWidget {
    private final Action showOnStartupAction;
    private final Action checkForUpdatesAction;
    private final List<WidgetElement> elements;

    public NetBeansWidget() {
        FileObject configFolder = FileUtil.getConfigFile((String)"Dashboard/Main");
        this.showOnStartupAction = new ShowOnStartupAction(configFolder);
        this.checkForUpdatesAction = new CheckForUpdatesActions();
        this.elements = List.of(WidgetElement.image((String)"org/netbeans/modules/ide/dashboard/resources/apache-netbeans.png"), WidgetElement.text((String)""), WidgetElement.action((Action)this.checkForUpdatesAction), WidgetElement.component(() -> new JCheckBox(this.showOnStartupAction)));
    }

    public String title(DashboardDisplayer.Panel panel) {
        return "";
    }

    public List<WidgetElement> elements(DashboardDisplayer.Panel panel) {
        return this.elements;
    }

    private static class ShowOnStartupAction
    extends AbstractAction {
        private final FileObject configFile;

        private ShowOnStartupAction(FileObject configFile) {
            super(Bundle.LBL_ShowOnStartup());
            this.configFile = configFile;
            this.putValue("ShortDescription", Bundle.STATUS_ShowOnStartup());
            if (configFile != null) {
                this.putValue("SwingSelectedKey", Boolean.TRUE.equals(configFile.getAttribute("showOnStartup")));
            } else {
                this.putValue("SwingSelectedKey", false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.configFile != null) {
                try {
                    this.configFile.setAttribute("showOnStartup", (Object)Boolean.TRUE.equals(this.getValue("SwingSelectedKey")));
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static class CheckForUpdatesActions
    extends AbstractAction {
        private CheckForUpdatesActions() {
            super(Bundle.LBL_CheckForUpdates());
            this.putValue("ShortDescription", Bundle.STATUS_CheckForUpdates());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Actions.forID((String)"System", (String)"org.netbeans.modules.autoupdate.ui.actions.CheckForUpdatesAction").actionPerformed(e);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

