/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey.io.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LengthLimitedInputStream
extends FilterInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(LengthLimitedInputStream.class);
    private final long length;
    private long remainingBytes;
    private long remainingBytesAtMark;

    public LengthLimitedInputStream(InputStream inputStream, long length) {
        super(inputStream);
        this.length = length;
        this.remainingBytes = length;
        this.remainingBytesAtMark = length;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.remainingBytes <= 0L) {
            LOG.debug("End of the stream has been reached for InputStream with length {}", (Object)this.length);
            return -1;
        }
        int read = super.read();
        if (read >= 0) {
            --this.remainingBytes;
        }
        return read;
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.remainingBytes <= 0L) {
            LOG.debug("End of the stream has been reached for InputStream with length {}", (Object)this.length);
            return -1;
        }
        int lenToRead = Math.min(len, this.convertLongToInt(this.remainingBytes));
        int bytesRead = super.read(b, off, lenToRead);
        if (bytesRead > 0) {
            this.remainingBytes -= (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public long skip(long numberOfBytesToSkip) throws IOException {
        numberOfBytesToSkip = Math.min(numberOfBytesToSkip, this.remainingBytes);
        long bytesSkipped = super.skip(numberOfBytesToSkip);
        this.remainingBytes -= bytesSkipped;
        return bytesSkipped;
    }

    @Override
    public int available() throws IOException {
        int availableBytes = super.available();
        return Math.min(availableBytes, Math.min(Integer.MAX_VALUE, this.convertLongToInt(this.remainingBytes)));
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public synchronized void mark(int ignoredReadlimit) {
        this.remainingBytesAtMark = this.remainingBytes;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.remainingBytes = this.remainingBytesAtMark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    private int convertLongToInt(long value) {
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)value;
    }
}

