/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor2;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProjectXMLCatalogReader
implements CatalogReader,
CatalogDescriptor2 {
    private static final String PREFIX = "http://www.netbeans.org/ns/";
    private static final String EXTENSION = "xsd";
    private static final String CATALOG = "ProjectXMLCatalog";
    private static Schema LAST_USED_SCHEMA;
    private static int LAST_USED_SCHEMA_HASH;

    public String resolveURI(String name) {
        return ProjectXMLCatalogReader._resolveURI(name);
    }

    private static String _resolveURI(String name) {
        FileObject rsrc;
        if (name.startsWith(PREFIX) && (rsrc = FileUtil.getConfigFile((String)("ProjectXMLCatalog/" + name.substring(PREFIX.length()) + "." + EXTENSION))) != null) {
            return rsrc.toURL().toString();
        }
        return null;
    }

    public String resolvePublic(String publicId) {
        return null;
    }

    public String getSystemID(String publicId) {
        return null;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removeCatalogListener(CatalogListener l) {
    }

    public void addCatalogListener(CatalogListener l) {
    }

    public String getIconResource(int type) {
        return "org/netbeans/modules/project/ui/resources/projectTab.png";
    }

    public void refresh() {
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ProjectXMLCatalogReader.class, (String)"HINT_project_xml_schemas");
    }

    public Iterator getPublicIDs() {
        return Collections.EMPTY_SET.iterator();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ProjectXMLCatalogReader.class, (String)"LBL_project_xml_schemas");
    }

    public static void validate(Element dom) throws SAXException {
        if (FileUtil.getConfigFile((String)CATALOG) == null) {
            return;
        }
        XMLUtil.validate((Element)dom, (Schema)ProjectXMLCatalogReader.projectXmlCombinedSchema());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Schema projectXmlCombinedSchema() {
        int hash = 0;
        ArrayList<FileObject> schemas = new ArrayList<FileObject>();
        FileObject root = FileUtil.getConfigFile((String)CATALOG);
        if (root != null) {
            for (FileObject f : NbCollections.iterable((Enumeration)root.getChildren(true))) {
                if (!f.isData() || !f.hasExt(EXTENSION)) continue;
                schemas.add(f);
                hash ^= f.getPath().hashCode();
                hash = (int)((long)hash ^ f.getSize());
            }
        }
        if (LAST_USED_SCHEMA == null || hash != LAST_USED_SCHEMA_HASH) {
            ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
            ArrayList<InputStream> streams = new ArrayList<InputStream>();
            try {
                for (FileObject f : schemas) {
                    try {
                        InputStream is = f.getInputStream();
                        streams.add(is);
                        sources.add(new StreamSource(is, f.toURL().toString()));
                    }
                    catch (IOException x2) {
                        Exceptions.printStackTrace((Throwable)x2);
                    }
                }
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                try {
                    LAST_USED_SCHEMA = schemaFactory.newSchema(sources.toArray(new Source[0]));
                    LAST_USED_SCHEMA_HASH = hash;
                }
                catch (SAXException x) {
                    Schema x2;
                    for (FileObject f : schemas) {
                        try {
                            schemaFactory.newSchema(new StreamSource(f.toURL().toString()));
                        }
                        catch (Exception x22) {
                            Exceptions.attachMessage((Throwable)x22, (String)("While parsing: " + f.getPath()));
                            Exceptions.printStackTrace((Throwable)x22);
                        }
                    }
                    Exceptions.printStackTrace((Throwable)x);
                    try {
                        x2 = schemaFactory.newSchema();
                    }
                    catch (SAXException x23) {
                        throw new AssertionError((Object)x23);
                    }
                    for (InputStream is : streams) {
                        try {
                            is.close();
                        }
                        catch (IOException x3) {
                            Exceptions.printStackTrace((Throwable)x3);
                        }
                    }
                    return x2;
                }
            }
            finally {
                for (InputStream is : streams) {
                    try {
                        is.close();
                    }
                    catch (IOException x) {
                        Exceptions.printStackTrace((Throwable)x);
                    }
                }
            }
        }
        return LAST_USED_SCHEMA;
    }

    public static Element autocorrect(Element dom, SAXException x) {
        Matcher m;
        int slash;
        Element data;
        String ns;
        String error = x.getMessage();
        if (error != null && error.contains("cvc-") && !error.contains("cvc-complex-type.2.4.a:")) {
            return null;
        }
        Element attempt = (Element)dom.cloneNode(true);
        NodeList datas = attempt.getElementsByTagName("data");
        if (datas.getLength() > 0 && (ns = (data = (Element)datas.item(0)).getNamespaceURI()) != null && (slash = ns.lastIndexOf(47)) != -1) {
            try {
                String ns2 = ns.substring(0, slash + 1) + Integer.toString(Integer.parseInt(ns.substring(slash + 1)) + 1);
                if (ProjectXMLCatalogReader._resolveURI(ns2) != null) {
                    Element data2 = XMLUtil.translateXML((Element)data, (String)ns2);
                    data.getParentNode().replaceChild(data2, data);
                    try {
                        ProjectXMLCatalogReader.validate(attempt);
                        return attempt;
                    }
                    catch (SAXException sAXException) {}
                }
            }
            catch (NumberFormatException ns2) {
                // empty catch block
            }
        }
        if ((m = Pattern.compile("cvc-complex-type[.]2[.]4[.]a: Invalid content was found starting with element '(.+)'. One of '.+' is expected.").matcher(error)).matches()) {
            Element data2;
            NodeList stuff;
            int len;
            String misplacedName = m.group(1);
            Element attempt2 = (Element)dom.cloneNode(true);
            NodeList datas2 = attempt2.getElementsByTagName("data");
            if (datas2.getLength() > 0 && (len = (stuff = (data2 = (Element)datas2.item(0)).getChildNodes()).getLength()) > 1) {
                int numberOfMisplaced = 0;
                Node originalFront = stuff.item(0);
                Node misplaced = null;
                for (int i = 0; i < len; ++i) {
                    Node n = stuff.item(i);
                    if (n instanceof Element) {
                        Element e = (Element)n;
                        boolean matches = misplacedName.equals(e.getLocalName());
                        if (misplaced == null && matches) {
                            misplaced = n;
                        } else if (misplaced != null && !matches) break;
                    }
                    if (misplaced == null) continue;
                    ++numberOfMisplaced;
                    data2.insertBefore(n, originalFront);
                }
                try {
                    ProjectXMLCatalogReader.validate(attempt2);
                    return attempt2;
                }
                catch (SAXException i) {
                    for (int i2 = numberOfMisplaced; i2 < len; ++i2) {
                        data2.insertBefore(stuff.item(i2), misplaced);
                        try {
                            ProjectXMLCatalogReader.validate(attempt2);
                            return attempt2;
                        }
                        catch (SAXException sAXException) {
                            continue;
                        }
                    }
                }
            }
        }
        return null;
    }
}

