"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
var _configSchema = require("@osd/config-schema");
var _common = require("../../common");
var _query_assist = require("./query_assist");
var _data_source_connection = require("./data_source_connection");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function defineRoute(logger, router, searchStrategies, searchStrategyId) {
  const path = `${_common.API.SEARCH}/${searchStrategyId}`;
  router.post({
    path,
    validate: {
      body: _configSchema.schema.object({
        query: _configSchema.schema.object({
          qs: _configSchema.schema.string(),
          format: _configSchema.schema.string()
        }),
        df: _configSchema.schema.nullable(_configSchema.schema.object({}, {
          unknowns: 'allow'
        }))
      })
    }
  }, async (context, req, res) => {
    try {
      const queryRes = await searchStrategies[searchStrategyId].search(context, req, {});
      return res.ok({
        body: {
          ...queryRes
        }
      });
    } catch (err) {
      logger.error(err);
      return res.custom({
        statusCode: 500,
        body: err
      });
    }
  });
  router.get({
    path: `${path}/{queryId}`,
    validate: {
      params: _configSchema.schema.object({
        queryId: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    try {
      const queryRes = await searchStrategies[searchStrategyId].search(context, req, {});
      const result = {
        body: {
          ...queryRes
        }
      };
      return res.ok(result);
    } catch (err) {
      logger.error(err);
      return res.custom({
        statusCode: 500,
        body: err
      });
    }
  });
  router.get({
    path: `${path}/{queryId}/{dataSourceId}`,
    validate: {
      params: _configSchema.schema.object({
        queryId: _configSchema.schema.string(),
        dataSourceId: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    try {
      const queryRes = await searchStrategies[searchStrategyId].search(context, req, {});
      const result = {
        body: {
          ...queryRes
        }
      };
      return res.ok(result);
    } catch (err) {
      logger.error(err);
      return res.custom({
        statusCode: 500,
        body: err
      });
    }
  });
}
function defineRoutes(logger, router, client, searchStrategies) {
  defineRoute(logger, router, searchStrategies, _common.SEARCH_STRATEGY.PPL);
  defineRoute(logger, router, searchStrategies, _common.SEARCH_STRATEGY.SQL);
  defineRoute(logger, router, searchStrategies, _common.SEARCH_STRATEGY.SQL_ASYNC);
  (0, _data_source_connection.registerDataSourceConnectionsRoutes)(router, client);
  (0, _query_assist.registerQueryAssistRoutes)(router);
}