"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEEK_IN_MILLI_SECS = exports.STACK_TRACE_PATTERN = exports.SORT_DIRECTION = exports.SEC_IN_MILLI_SECS = exports.SAMPLE_TYPE = exports.REALTIME_TASK_TYPE_PREFIX = exports.REALTIME_TASK_TYPES = exports.OPENSEARCH_EXCEPTION_PREFIX = exports.MODEL_ID_FIELD = exports.MIN_IN_MILLI_SECS = exports.MAX_MONITORS = exports.MAX_DETECTORS = exports.MAX_ANOMALY_GRADE_FIELD = exports.MAX_ALERTS = exports.KEY_FIELD = exports.HOUR_IN_MILLI_SECS = exports.HISTORICAL_TASK_TYPE_PREFIX = exports.HISTORICAL_TASK_TYPES = exports.HEATMAP_CELL_ENTITY_DELIMITER = exports.HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = exports.ENTITY_VALUE_PATH_FIELD = exports.ENTITY_NAME_PATH_FIELD = exports.ENTITY_LIST_FIELD = exports.ENTITY_LIST_DELIMITER = exports.ENTITY_FIELD = exports.DOC_COUNT_FIELD = exports.DETECTOR_STATE = exports.DETECTORS_QUERY_PARAMS = exports.DEFAULT_HEADERS = exports.DAY_IN_MILLI_SECS = exports.CUSTOM_AD_RESULT_INDEX_PREFIX = exports.CLUSTER = exports.API = exports.ALERTING_API_ROUTE_PREFIX = exports.AD_DOC_FIELDS = exports.AD_API_ROUTE_PREFIX = void 0;
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const AD_API_ROUTE_PREFIX = exports.AD_API_ROUTE_PREFIX = '/_plugins/_anomaly_detection';
const ALERTING_API_ROUTE_PREFIX = exports.ALERTING_API_ROUTE_PREFIX = '/_plugins/_alerting';
const API = exports.API = {
  DETECTOR_BASE: `${AD_API_ROUTE_PREFIX}/detectors`,
  ALERTING_BASE: `${ALERTING_API_ROUTE_PREFIX}/monitors`
};
const DEFAULT_HEADERS = exports.DEFAULT_HEADERS = {
  'Content-Type': 'application/json',
  Accept: 'application/json',
  'User-Agent': 'OpenSearch Dashboards'
};
const SEC_IN_MILLI_SECS = exports.SEC_IN_MILLI_SECS = 1000;
const MIN_IN_MILLI_SECS = exports.MIN_IN_MILLI_SECS = 60 * SEC_IN_MILLI_SECS;
const HOUR_IN_MILLI_SECS = exports.HOUR_IN_MILLI_SECS = 60 * MIN_IN_MILLI_SECS;
const DAY_IN_MILLI_SECS = exports.DAY_IN_MILLI_SECS = 24 * HOUR_IN_MILLI_SECS;
const WEEK_IN_MILLI_SECS = exports.WEEK_IN_MILLI_SECS = 7 * DAY_IN_MILLI_SECS;
let CLUSTER = exports.CLUSTER = /*#__PURE__*/function (CLUSTER) {
  CLUSTER["ADMIN"] = "admin";
  CLUSTER["AES_AD"] = "aes_ad";
  CLUSTER["DATA"] = "data";
  return CLUSTER;
}({});
let SORT_DIRECTION = exports.SORT_DIRECTION = /*#__PURE__*/function (SORT_DIRECTION) {
  SORT_DIRECTION["ASC"] = "asc";
  SORT_DIRECTION["DESC"] = "desc";
  return SORT_DIRECTION;
}({});
let DETECTORS_QUERY_PARAMS = exports.DETECTORS_QUERY_PARAMS = /*#__PURE__*/function (DETECTORS_QUERY_PARAMS) {
  DETECTORS_QUERY_PARAMS["FROM"] = "from";
  DETECTORS_QUERY_PARAMS["SIZE"] = "size";
  DETECTORS_QUERY_PARAMS["SEARCH"] = "search";
  DETECTORS_QUERY_PARAMS["INDICES"] = "indices";
  DETECTORS_QUERY_PARAMS["SORT_FIELD"] = "sortField";
  DETECTORS_QUERY_PARAMS["SORT_DIRECTION"] = "sortDirection";
  DETECTORS_QUERY_PARAMS["NAME"] = "name";
  DETECTORS_QUERY_PARAMS["DATASOURCEID"] = "dataSourceId";
  return DETECTORS_QUERY_PARAMS;
}({});
let AD_DOC_FIELDS = exports.AD_DOC_FIELDS = /*#__PURE__*/function (AD_DOC_FIELDS) {
  AD_DOC_FIELDS["DATA_START_TIME"] = "data_start_time";
  AD_DOC_FIELDS["DATA_END_TIME"] = "data_end_time";
  AD_DOC_FIELDS["DETECTOR_ID"] = "detector_id";
  AD_DOC_FIELDS["TASK_ID"] = "task_id";
  AD_DOC_FIELDS["DETECTOR_NAME"] = "name";
  AD_DOC_FIELDS["PLOT_TIME"] = "plot_time";
  AD_DOC_FIELDS["ANOMALY_GRADE"] = "anomaly_grade";
  AD_DOC_FIELDS["ERROR"] = "error";
  AD_DOC_FIELDS["INDICES"] = "indices";
  return AD_DOC_FIELDS;
}({});
const MAX_DETECTORS = exports.MAX_DETECTORS = 1000;
const MAX_MONITORS = exports.MAX_MONITORS = 1000;
const MAX_ALERTS = exports.MAX_ALERTS = 1000;

// TODO: maybe move types/interfaces/constants/helpers shared between client and server
// side as many as possible into single place
let DETECTOR_STATE = exports.DETECTOR_STATE = /*#__PURE__*/function (DETECTOR_STATE) {
  DETECTOR_STATE["DISABLED"] = "Stopped";
  DETECTOR_STATE["INIT"] = "Initializing";
  DETECTOR_STATE["RUNNING"] = "Running";
  DETECTOR_STATE["FINISHED"] = "Finished";
  DETECTOR_STATE["FEATURE_REQUIRED"] = "Feature required";
  DETECTOR_STATE["INIT_FAILURE"] = "Initialization failure";
  DETECTOR_STATE["UNEXPECTED_FAILURE"] = "Unexpected failure";
  DETECTOR_STATE["FAILED"] = "Failed";
  return DETECTOR_STATE;
}({});
let SAMPLE_TYPE = exports.SAMPLE_TYPE = /*#__PURE__*/function (SAMPLE_TYPE) {
  SAMPLE_TYPE["HTTP_RESPONSES"] = "http-responses";
  SAMPLE_TYPE["HOST_HEALTH"] = "host-health";
  SAMPLE_TYPE["ECOMMERCE"] = "ecommerce";
  return SAMPLE_TYPE;
}({});
const ENTITY_FIELD = exports.ENTITY_FIELD = 'entity';
const ENTITY_VALUE_PATH_FIELD = exports.ENTITY_VALUE_PATH_FIELD = 'entity.value';
const ENTITY_NAME_PATH_FIELD = exports.ENTITY_NAME_PATH_FIELD = 'entity.name';
const MODEL_ID_FIELD = exports.MODEL_ID_FIELD = 'model_id';
const DOC_COUNT_FIELD = exports.DOC_COUNT_FIELD = 'doc_count';
const KEY_FIELD = exports.KEY_FIELD = 'key';
const ENTITY_LIST_FIELD = exports.ENTITY_LIST_FIELD = 'entity_list';
const MAX_ANOMALY_GRADE_FIELD = exports.MAX_ANOMALY_GRADE_FIELD = 'max_anomaly_grade';

// y-axis values in the heatmap chart should be in the form:
// <category-field-value-1><br><category-field-value-2>
const ENTITY_LIST_DELIMITER = exports.ENTITY_LIST_DELIMITER = '<br>';

// when hovering over a cell, the entity list should be in the form:
// <category-field-name-1>: <category-field-value-1>, <category-field-name-2>: <category-field-value-2>
const HEATMAP_CELL_ENTITY_DELIMITER = exports.HEATMAP_CELL_ENTITY_DELIMITER = ', ';
const HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = exports.HEATMAP_CALL_ENTITY_KEY_VALUE_DELIMITER = ': ';
const STACK_TRACE_PATTERN = exports.STACK_TRACE_PATTERN = '.java:';
const OPENSEARCH_EXCEPTION_PREFIX = exports.OPENSEARCH_EXCEPTION_PREFIX = 'org.opensearch.OpenSearchException: ';
const REALTIME_TASK_TYPE_PREFIX = exports.REALTIME_TASK_TYPE_PREFIX = 'REALTIME';
const HISTORICAL_TASK_TYPE_PREFIX = exports.HISTORICAL_TASK_TYPE_PREFIX = 'HISTORICAL';
const REALTIME_TASK_TYPES = exports.REALTIME_TASK_TYPES = ['REALTIME_HC_DETECTOR', 'REALTIME_SINGLE_ENTITY'];
const HISTORICAL_TASK_TYPES = exports.HISTORICAL_TASK_TYPES = ['HISTORICAL_SINGLE_ENTITY', 'HISTORICAL_HC_DETECTOR', 'HISTORICAL'];
const CUSTOM_AD_RESULT_INDEX_PREFIX = exports.CUSTOM_AD_RESULT_INDEX_PREFIX = 'opensearch-ad-plugin-result-';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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