"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiLoadingElastic", {
  enumerable: true,
  get: function get() {
    return _loading_elastic.EuiLoadingElastic;
  }
});
exports.OuiLoadingElastic = exports.SIZES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../common");

var _icon = require("../icon");

var _utils = require("../../utils");

var _loading_elastic = require("../../eui_components/loading/loading_elastic");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var sizeToClassNameMap = {
  m: 'ouiLoadingElastic--medium',
  l: 'ouiLoadingElastic--large',
  xl: 'ouiLoadingElastic--xLarge',
  xxl: 'ouiLoadingElastic--xxLarge'
};
var SIZES = (0, _common.keysOf)(sizeToClassNameMap);
exports.SIZES = SIZES;

var OuiLoadingElasticComponent = function OuiLoadingElasticComponent(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["size", "className"]);
  var classes = (0, _classnames.default)('ouiLoadingElastic', sizeToClassNameMap[size], className);
  return /*#__PURE__*/_react.default.createElement("span", (0, _extends2.default)({
    className: classes
  }, rest), /*#__PURE__*/_react.default.createElement(_icon.OuiIcon, {
    type: "logoOpenSearch",
    size: size
  }));
};

OuiLoadingElasticComponent.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  size: _propTypes.default.oneOf(["m", "l", "xl", "xxl"])
};
OuiLoadingElasticComponent.displayName = 'OuiLoadingElastic';
/**
 * @deprecated OuiLoadingElastic is deprecated in favor of OuiLoadingDashboards and will be removed in v2.0.0.
 */

var OuiLoadingElastic = (0, _utils.deprecatedComponentWarning)({
  newComponentName: 'OuiLoadingDashboards',
  version: '2.0.0'
})(OuiLoadingElasticComponent);
/* OUI -> EUI Aliases: Build-Time */

/* OUI -> EUI Aliases: Build-Time */

exports.OuiLoadingElastic = OuiLoadingElastic;