/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.customcodecs;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.opensearch.common.settings.Setting;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.codec.CodecServiceFactory;
import org.opensearch.index.codec.customcodecs.CustomCodecServiceFactory;
import org.opensearch.index.codec.customcodecs.Lucene99QatCodec;
import org.opensearch.index.codec.customcodecs.QatZipperFactory;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.plugins.EnginePlugin;
import org.opensearch.plugins.Plugin;

public final class CustomCodecPlugin
extends Plugin
implements EnginePlugin {
    public Optional<CodecServiceFactory> getCustomCodecServiceFactory(IndexSettings indexSettings) {
        String codecName = (String)indexSettings.getValue(EngineConfig.INDEX_CODEC_SETTING);
        if (codecName.equals("zstd_no_dict") || codecName.equals("zstd") || codecName.equals("qat_lz4") || codecName.equals("qat_deflate")) {
            return Optional.of(new CustomCodecServiceFactory());
        }
        if (!QatZipperFactory.isQatAvailable() && (codecName.equals(Lucene99QatCodec.Mode.QAT_LZ4.getCodec()) || codecName.equals(Lucene99QatCodec.Mode.QAT_DEFLATE.getCodec()))) {
            throw new IllegalArgumentException("QAT codecs are not supported. Please create indices with a different codec.");
        }
        return Optional.empty();
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(Lucene99QatCodec.INDEX_CODEC_QAT_MODE_SETTING);
    }
}

