/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.caching.CacheProvider;
import org.opensearch.timeseries.caching.TimeSeriesCache;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.ml.CheckpointDao;
import org.opensearch.timeseries.ml.IntermediateResult;
import org.opensearch.timeseries.ml.ModelColdStart;
import org.opensearch.timeseries.ml.ModelManager;
import org.opensearch.timeseries.ml.ModelState;
import org.opensearch.timeseries.ml.Sample;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.ratelimit.CheckpointReadWorker;
import org.opensearch.timeseries.ratelimit.CheckpointWriteWorker;
import org.opensearch.timeseries.ratelimit.ColdEntityWorker;
import org.opensearch.timeseries.ratelimit.ColdStartWorker;
import org.opensearch.timeseries.ratelimit.FeatureRequest;
import org.opensearch.timeseries.ratelimit.RateLimitedRequestWorker;
import org.opensearch.timeseries.ratelimit.RequestPriority;
import org.opensearch.timeseries.ratelimit.SaveResultStrategy;
import org.opensearch.timeseries.stats.StatNames;
import org.opensearch.timeseries.stats.Stats;
import org.opensearch.timeseries.transport.EntityResultRequest;

public class EntityResultProcessor<RCFModelType extends ThresholdedRandomCutForest, IndexableResultType extends IndexableResult, IntermediateResultType extends IntermediateResult<IndexableResultType>, IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, CheckpointDaoType extends CheckpointDao<RCFModelType, IndexType, IndexManagementType>, CheckpointWriteWorkerType extends CheckpointWriteWorker<RCFModelType, IndexType, IndexManagementType, CheckpointDaoType>, ModelColdStartType extends ModelColdStart<RCFModelType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriteWorkerType>, ModelManagerType extends ModelManager<RCFModelType, IndexableResultType, IntermediateResultType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriteWorkerType, ModelColdStartType>, CacheType extends TimeSeriesCache<RCFModelType>, SaveResultStrategyType extends SaveResultStrategy<IndexableResultType, IntermediateResultType>, ColdStartWorkerType extends ColdStartWorker<RCFModelType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriteWorkerType, ModelColdStartType, CacheType, IndexableResultType, IntermediateResultType, ModelManagerType, SaveResultStrategyType>, HCCheckpointReadWorkerType extends CheckpointReadWorker<RCFModelType, IndexableResultType, IntermediateResultType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriteWorkerType, ModelColdStartType, ModelManagerType, CacheType, SaveResultStrategyType, ColdStartWorkerType>, ColdEntityWorkerType extends ColdEntityWorker<RCFModelType, IndexableResultType, IndexType, IndexManagementType, CheckpointDaoType, IntermediateResultType, ModelManagerType, CheckpointWriteWorkerType, ModelColdStartType, CacheType, SaveResultStrategyType, ColdStartWorkerType, HCCheckpointReadWorkerType>> {
    private static final Logger LOG = LogManager.getLogger(EntityResultProcessor.class);
    private CacheProvider<RCFModelType, CacheType> cache;
    private ModelManagerType modelManager;
    private Stats stats;
    private ColdStartWorkerType entityColdStartWorker;
    private HCCheckpointReadWorkerType checkpointReadQueue;
    private ColdEntityWorkerType coldEntityQueue;
    private SaveResultStrategyType saveResultStrategy;
    private StatNames modelCorruptionStat;

    public EntityResultProcessor(CacheProvider<RCFModelType, CacheType> cache, ModelManagerType manager, Stats stats, ColdStartWorkerType entityColdStartWorker, HCCheckpointReadWorkerType checkpointReadQueue, ColdEntityWorkerType coldEntityQueue, SaveResultStrategyType saveResultStrategy, StatNames modelCorruptionStat) {
        this.cache = cache;
        this.modelManager = manager;
        this.stats = stats;
        this.entityColdStartWorker = entityColdStartWorker;
        this.checkpointReadQueue = checkpointReadQueue;
        this.coldEntityQueue = coldEntityQueue;
        this.saveResultStrategy = saveResultStrategy;
        this.modelCorruptionStat = modelCorruptionStat;
    }

    public ActionListener<Optional<? extends Config>> onGetConfig(ActionListener<AcknowledgedResponse> listener, String forecasterId, EntityResultRequest request, Optional<Exception> prevException, AnalysisType analysisType) {
        return ActionListener.wrap(configOptional -> {
            if (!configOptional.isPresent()) {
                listener.onFailure((Exception)new EndRunException(forecasterId, "Config " + forecasterId + " is not available.", false));
                return;
            }
            Config config = (Config)configOptional.get();
            if (request.getEntities() == null) {
                listener.onFailure((Exception)new EndRunException(forecasterId, "Fail to get any entities from request.", false));
                return;
            }
            HashMap<Entity, double[]> cacheMissEntities = new HashMap<Entity, double[]>();
            for (Map.Entry<Entity, double[]> entityEntry : request.getEntities().entrySet()) {
                Optional<String> modelIdOptional;
                Entity entity = entityEntry.getKey();
                if (this.isEntityFromOldNodeMsg(entity) && config.getCategoryFields() != null && config.getCategoryFields().size() == 1) {
                    Map<String, String> attrValues = entity.getAttributes();
                    entity = Entity.createSingleAttributeEntity(config.getCategoryFields().get(0), attrValues.get(""));
                }
                if ((modelIdOptional = entity.getModelId(forecasterId)).isEmpty()) continue;
                String modelId = modelIdOptional.get();
                double[] datapoint = entityEntry.getValue();
                ModelState entityModel = this.cache.get().get(modelId, config);
                if (entityModel == null) {
                    cacheMissEntities.put(entity, datapoint);
                    continue;
                }
                try {
                    Object result = ((ModelManager)this.modelManager).getResult(new Sample(datapoint, Instant.ofEpochMilli(request.getStart()), Instant.ofEpochMilli(request.getEnd())), entityModel, modelId, config, request.getTaskId());
                    this.saveResultStrategy.saveResult(result, config, Instant.ofEpochMilli(request.getStart()), Instant.ofEpochMilli(request.getEnd()), modelId, datapoint, Optional.of(entity), request.getTaskId());
                }
                catch (IllegalArgumentException e) {
                    LOG.error((Message)new ParameterizedMessage("Likely model corruption for [{}]", (Object)modelId), (Throwable)e);
                    this.stats.getStat(this.modelCorruptionStat.getName()).increment();
                    this.cache.get().removeModel(forecasterId, modelId);
                    ((RateLimitedRequestWorker)this.entityColdStartWorker).put((FeatureRequest)new FeatureRequest(System.currentTimeMillis() + config.getIntervalInMilliseconds(), forecasterId, RequestPriority.MEDIUM, datapoint, request.getStart(), entity, request.getTaskId()));
                }
            }
            Pair<List<Entity>, List<Entity>> hotColdEntities = this.cache.get().selectUpdateCandidate(cacheMissEntities.keySet(), forecasterId, config);
            ArrayList<FeatureRequest> hotEntityRequests = new ArrayList<FeatureRequest>();
            ArrayList<FeatureRequest> coldEntityRequests = new ArrayList<FeatureRequest>();
            for (Entity hotEntity : (List)hotColdEntities.getLeft()) {
                double[] hotEntityValue = (double[])cacheMissEntities.get(hotEntity);
                if (hotEntityValue == null) {
                    LOG.error((Message)new ParameterizedMessage("feature value should not be null: [{}]", (Object)hotEntity));
                    continue;
                }
                hotEntityRequests.add(new FeatureRequest(System.currentTimeMillis() + config.getIntervalInMilliseconds(), forecasterId, RequestPriority.MEDIUM, hotEntityValue, request.getStart(), hotEntity, request.getTaskId()));
            }
            for (Entity coldEntity : (List)hotColdEntities.getRight()) {
                double[] coldEntityValue = (double[])cacheMissEntities.get(coldEntity);
                if (coldEntityValue == null) {
                    LOG.error((Message)new ParameterizedMessage("feature value should not be null: [{}]", (Object)coldEntity));
                    continue;
                }
                coldEntityRequests.add(new FeatureRequest(System.currentTimeMillis() + config.getIntervalInMilliseconds(), forecasterId, RequestPriority.LOW, coldEntityValue, request.getStart(), coldEntity, request.getTaskId()));
            }
            ((RateLimitedRequestWorker)this.checkpointReadQueue).putAll(hotEntityRequests);
            ((RateLimitedRequestWorker)this.coldEntityQueue).putAll(coldEntityRequests);
            if (prevException.isPresent()) {
                listener.onFailure((Exception)prevException.get());
            } else {
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }
        }, exception -> {
            LOG.error((Message)new ParameterizedMessage("fail to get entity's analysis result for config [{}]: start: [{}], end: [{}]", new Object[]{forecasterId, request.getStart(), request.getEnd()}), (Throwable)exception);
            listener.onFailure(exception);
        });
    }

    private boolean isEntityFromOldNodeMsg(Entity categoricalValues) {
        Map<String, String> attrValues = categoricalValues.getAttributes();
        return attrValues != null && attrValues.containsKey("");
    }
}

