/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.ratelimit;

import java.io.IOException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.ratelimit.QueuedRequest;
import org.opensearch.timeseries.ratelimit.RequestPriority;

public abstract class ResultWriteRequest<ResultType extends IndexableResult>
extends QueuedRequest
implements Writeable {
    private final ResultType result;
    private final String resultIndex;

    public ResultWriteRequest(long expirationEpochMs, String configId, RequestPriority priority, ResultType result, String resultIndex) {
        super(expirationEpochMs, configId, priority);
        this.result = result;
        this.resultIndex = resultIndex;
    }

    public ResultWriteRequest(StreamInput in, Writeable.Reader<ResultType> resultReader) throws IOException {
        this.result = (IndexableResult)resultReader.read(in);
        this.resultIndex = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        ((IndexableResult)this.result).writeTo(out);
        out.writeOptionalString(this.resultIndex);
    }

    public ResultType getResult() {
        return this.result;
    }

    public String getResultIndex() {
        return this.resultIndex;
    }
}

