/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.opensearch.action.admin.cluster.settings.ClusterGetSettingsRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.client.indices.GetIndexResponse;
import org.opensearch.client.indices.GetMappingsRequest;
import org.opensearch.client.indices.GetMappingsResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.settings.Settings;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.mapping.IndexMapping;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;

public class OpenSearchRestClient
implements OpenSearchClient {
    private final RestHighLevelClient client;

    @Override
    public boolean exists(String indexName) {
        try {
            return this.client.indices().exists(new GetIndexRequest(new String[]{indexName}), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to check if index [" + indexName + "] exist", e);
        }
    }

    @Override
    public void createIndex(String indexName, Map<String, Object> mappings) {
        try {
            this.client.indices().create(new CreateIndexRequest(indexName).mapping(mappings), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create index [" + indexName + "]", e);
        }
    }

    @Override
    public Map<String, IndexMapping> getIndexMappings(String ... indexExpression) {
        GetMappingsRequest request = new GetMappingsRequest().indices(indexExpression);
        try {
            GetMappingsResponse response = this.client.indices().getMapping(request, RequestOptions.DEFAULT);
            return response.mappings().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new IndexMapping((MappingMetadata)e.getValue())));
        }
        catch (IOException e2) {
            throw new IllegalStateException("Failed to get index mappings for " + String.valueOf(indexExpression), e2);
        }
    }

    @Override
    public Map<String, Integer> getIndexMaxResultWindows(String ... indexExpression) {
        GetSettingsRequest request = new GetSettingsRequest().indices(indexExpression).includeDefaults(true);
        try {
            GetSettingsResponse response = this.client.indices().getSettings(request, RequestOptions.DEFAULT);
            Map settings = response.getIndexToSettings();
            Map defaultSettings = response.getIndexToDefaultSettings();
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            defaultSettings.forEach((key, value) -> {
                Integer maxResultWindow = value.getAsInt("index.max_result_window", null);
                if (maxResultWindow != null) {
                    result.put((String)key, maxResultWindow);
                }
            });
            settings.forEach((key, value) -> {
                Integer maxResultWindow = value.getAsInt("index.max_result_window", null);
                if (maxResultWindow != null) {
                    result.put((String)key, maxResultWindow);
                }
            });
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get max result window for " + String.valueOf(indexExpression), e);
        }
    }

    @Override
    public OpenSearchResponse search(OpenSearchRequest request) {
        return request.search(req -> {
            try {
                return this.client.search(req, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to perform search operation with request " + String.valueOf(req), e);
            }
        }, req -> {
            try {
                return this.client.scroll(req, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to perform scroll operation with request " + String.valueOf(req), e);
            }
        });
    }

    @Override
    public List<String> indices() {
        try {
            GetIndexResponse indexResponse = this.client.indices().get(new GetIndexRequest(new String[0]), RequestOptions.DEFAULT);
            Stream<String> aliasStream = ImmutableList.copyOf(indexResponse.getAliases().values()).stream().flatMap(Collection::stream).map(AliasMetadata::alias);
            return Stream.concat(Arrays.stream(indexResponse.getIndices()), aliasStream).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get indices", e);
        }
    }

    @Override
    public Map<String, String> meta() {
        try {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            ClusterGetSettingsRequest request = new ClusterGetSettingsRequest();
            request.includeDefaults(true);
            request.local(true);
            Settings defaultSettings = this.client.cluster().getSettings(request, RequestOptions.DEFAULT).getDefaultSettings();
            builder.put((Object)"CLUSTER_NAME", (Object)defaultSettings.get("cluster.name", "opensearch"));
            return builder.build();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to get cluster meta info", e);
        }
    }

    @Override
    public void cleanup(OpenSearchRequest request) {
        request.clean(scrollId -> {
            try {
                ClearScrollRequest clearRequest = new ClearScrollRequest();
                clearRequest.addScrollId(scrollId);
                this.client.clearScroll(clearRequest, RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to clean up resources for search request " + String.valueOf(request), e);
            }
        });
    }

    @Override
    public void schedule(Runnable task) {
        task.run();
    }

    @Override
    public NodeClient getNodeClient() {
        throw new UnsupportedOperationException("Unsupported method.");
    }

    @Generated
    public OpenSearchRestClient(RestHighLevelClient client) {
        this.client = client;
    }
}

