/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.ToolMetadata;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.transport.tools.MLGetToolAction;
import org.opensearch.ml.common.transport.tools.MLToolGetRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLGetToolAction
extends BaseRestHandler {
    private static final String ML_GET_TOOL_ACTION = "ml_get_tool_action";
    private Map<String, Tool.Factory> toolFactories;

    public RestMLGetToolAction(Map<String, Tool.Factory> toolFactories) {
        this.toolFactories = toolFactories;
    }

    public String getName() {
        return ML_GET_TOOL_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/tools/{%s}", "/_plugins/_ml", "tool_name")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLToolGetRequest mlToolGetRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLGetToolAction.INSTANCE, (ActionRequest)mlToolGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLToolGetRequest getRequest(RestRequest request) throws IOException {
        ArrayList toolList = new ArrayList();
        this.toolFactories.forEach((key, value) -> toolList.add(ToolMetadata.builder().name(key).description(value.getDefaultDescription()).type(value.getDefaultType()).version(value.getDefaultVersion()).build()));
        String toolName = RestActionUtils.getParameterId(request, "tool_name");
        MLToolGetRequest mlToolGetRequest = MLToolGetRequest.builder().toolName(toolName).toolMetadataList(toolList).build();
        return mlToolGetRequest;
    }
}

