/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.agents;

import java.time.Instant;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.transport.agent.MLRegisterAgentRequest;
import org.opensearch.ml.common.transport.agent.MLRegisterAgentResponse;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportRegisterAgentAction
extends HandledTransportAction<ActionRequest, MLRegisterAgentResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportRegisterAgentAction.class);
    MLIndicesHandler mlIndicesHandler;
    Client client;
    ClusterService clusterService;

    @Inject
    public TransportRegisterAgentAction(TransportService transportService, ActionFilters actionFilters, Client client, MLIndicesHandler mlIndicesHandler, ClusterService clusterService) {
        super("cluster:admin/opensearch/ml/agents/register", transportService, actionFilters, MLRegisterAgentRequest::new);
        this.client = client;
        this.mlIndicesHandler = mlIndicesHandler;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLRegisterAgentResponse> listener) {
        User user = RestActionUtils.getUserContext(this.client);
        MLRegisterAgentRequest registerAgentRequest = MLRegisterAgentRequest.fromActionRequest((ActionRequest)request);
        MLAgent mlAgent = registerAgentRequest.getMlAgent();
        this.registerAgent(mlAgent, listener);
    }

    private void registerAgent(MLAgent agent, ActionListener<MLRegisterAgentResponse> listener) {
        Instant now = Instant.now();
        boolean isHiddenAgent = RestActionUtils.isSuperAdminUser(this.clusterService, this.client);
        MLAgent mlAgent = agent.toBuilder().createdTime(now).lastUpdateTime(now).isHidden(Boolean.valueOf(isHiddenAgent)).build();
        this.mlIndicesHandler.initMLAgentIndex(ActionListener.wrap(result -> {
            if (result.booleanValue()) {
                try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                    IndexRequest indexRequest = (IndexRequest)new IndexRequest(".plugins-ml-agent").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    XContentBuilder builder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());
                    mlAgent.toXContent(builder, ToXContent.EMPTY_PARAMS);
                    indexRequest.source(builder);
                    this.client.index(indexRequest, ActionListener.runBefore((ActionListener)ActionListener.wrap(r -> listener.onResponse((Object)new MLRegisterAgentResponse(r.getId())), e -> {
                        log.error("Failed to index ML agent", (Throwable)e);
                        listener.onFailure(e);
                    }), () -> ((ThreadContext.StoredContext)context).restore()));
                }
                catch (Exception e2) {
                    log.error("Failed to index ML agent", (Throwable)e2);
                    listener.onFailure(e2);
                }
            } else {
                log.error("Failed to create ML agent index");
                listener.onFailure((Exception)new OpenSearchException("Failed to create ML agent index", new Object[0]));
            }
        }, e -> {
            log.error("Failed to create ML agent index", (Throwable)e);
            listener.onFailure(e);
        }));
    }
}

