/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.ml;

import com.amazon.randomcutforest.RandomCutForest;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ForecastDescriptor;
import com.amazon.randomcutforest.parkservices.RCFCaster;
import java.time.Clock;
import java.util.Locale;
import org.opensearch.forecast.indices.ForecastIndex;
import org.opensearch.forecast.indices.ForecastIndexManagement;
import org.opensearch.forecast.ml.ForecastCheckpointDao;
import org.opensearch.forecast.ml.ForecastColdStart;
import org.opensearch.forecast.ml.RCFCasterResult;
import org.opensearch.forecast.model.ForecastResult;
import org.opensearch.forecast.ratelimit.ForecastCheckpointWriteWorker;
import org.opensearch.timeseries.MemoryTracker;
import org.opensearch.timeseries.feature.FeatureManager;
import org.opensearch.timeseries.ml.ModelManager;

public class ForecastModelManager
extends ModelManager<RCFCaster, ForecastResult, RCFCasterResult, ForecastIndex, ForecastIndexManagement, ForecastCheckpointDao, ForecastCheckpointWriteWorker, ForecastColdStart> {
    public ForecastModelManager(ForecastCheckpointDao checkpointDao, Clock clock, int rcfNumTrees, int rcfNumSamplesInTree, int rcfNumMinSamples, ForecastColdStart entityColdStarter, MemoryTracker memoryTracker, FeatureManager featureManager) {
        super(rcfNumTrees, rcfNumSamplesInTree, rcfNumMinSamples, entityColdStarter, memoryTracker, clock, featureManager, checkpointDao);
    }

    @Override
    protected RCFCasterResult createEmptyResult() {
        return new RCFCasterResult(null, 0.0, 0L, 0.0);
    }

    @Override
    protected <RCFDescriptor extends AnomalyDescriptor> RCFCasterResult toResult(RandomCutForest forecast, RCFDescriptor castDescriptor) {
        if (castDescriptor instanceof ForecastDescriptor) {
            ForecastDescriptor forecastDescriptor = (ForecastDescriptor)castDescriptor;
            return new RCFCasterResult(forecastDescriptor.getTimedForecast().rangeVector, forecastDescriptor.getDataConfidence(), forecast.getTotalUpdates(), forecastDescriptor.getRCFScore());
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Unsupported type of AnomalyDescriptor : %s", castDescriptor));
    }
}

