/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.StepListener;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.routing.Preference;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.securityanalytics.SecurityAnalyticsPlugin;
import org.opensearch.securityanalytics.commons.model.IOCType;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.threatIntel.action.monitor.SearchThreatIntelMonitorAction;
import org.opensearch.securityanalytics.threatIntel.action.monitor.request.SearchThreatIntelMonitorRequest;
import org.opensearch.securityanalytics.threatIntel.common.StashedThreadContext;
import org.opensearch.securityanalytics.threatIntel.common.TIFJobState;
import org.opensearch.securityanalytics.threatIntel.common.TIFLockService;
import org.opensearch.securityanalytics.threatIntel.model.DefaultIocStoreConfig;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfig;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;
import org.opensearch.threadpool.ThreadPool;

public class SATIFSourceConfigService {
    private static final Logger log = LogManager.getLogger(SATIFSourceConfigService.class);
    private final Client client;
    private final ClusterService clusterService;
    private final ClusterSettings clusterSettings;
    private final ThreadPool threadPool;
    private final NamedXContentRegistry xContentRegistry;
    private final TIFLockService lockService;

    public SATIFSourceConfigService(Client client, ClusterService clusterService, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, TIFLockService lockService) {
        this.client = client;
        this.clusterService = clusterService;
        this.clusterSettings = clusterService.getClusterSettings();
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.lockService = lockService;
    }

    public void indexTIFSourceConfig(SATIFSourceConfig saTifSourceConfig, LockModel lock, ActionListener<SATIFSourceConfig> actionListener) {
        StepListener createIndexStepListener = new StepListener();
        createIndexStepListener.whenComplete(v -> {
            try {
                IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap--job").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(saTifSourceConfig.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).id(saTifSourceConfig.getId()).timeout((TimeValue)this.clusterSettings.get(SecurityAnalyticsSettings.INDEX_TIMEOUT));
                log.debug("Indexing tif source config");
                this.client.index(indexRequest, ActionListener.wrap(response -> {
                    log.debug("Threat intel source config with id [{}] indexed success.", (Object)response.getId());
                    SATIFSourceConfig responseSaTifSourceConfig = SATIFSourceConfigService.createSATIFSourceConfig(saTifSourceConfig, response);
                    actionListener.onResponse((Object)responseSaTifSourceConfig);
                }, e -> {
                    log.error("Failed to index threat intel source config with id [{}]", (Object)saTifSourceConfig.getId());
                    actionListener.onFailure(e);
                }));
            }
            catch (IOException e2) {
                log.error("Exception saving the threat intel source config in index", (Throwable)e2);
                actionListener.onFailure((Exception)e2);
            }
        }, exception -> {
            this.lockService.releaseLock(lock);
            log.error("Failed to release lock", (Throwable)exception);
            actionListener.onFailure(exception);
        });
        this.createJobIndexIfNotExists((StepListener<Void>)createIndexStepListener);
    }

    private static SATIFSourceConfig createSATIFSourceConfig(SATIFSourceConfig saTifSourceConfig, IndexResponse response) {
        return new SATIFSourceConfig(response.getId(), response.getVersion(), saTifSourceConfig.getName(), saTifSourceConfig.getFormat(), saTifSourceConfig.getType(), saTifSourceConfig.getDescription(), saTifSourceConfig.getCreatedByUser(), saTifSourceConfig.getCreatedAt(), saTifSourceConfig.getSource(), saTifSourceConfig.getEnabledTime(), saTifSourceConfig.getLastUpdateTime(), saTifSourceConfig.getSchedule(), saTifSourceConfig.getState(), saTifSourceConfig.getRefreshType(), saTifSourceConfig.getLastRefreshedTime(), saTifSourceConfig.getLastRefreshedUser(), saTifSourceConfig.isEnabled(), saTifSourceConfig.getIocStoreConfig(), saTifSourceConfig.getIocTypes(), saTifSourceConfig.isEnabledForScan());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getIndexMapping() {
        try (InputStream is = SATIFSourceConfigService.class.getResourceAsStream("/mappings/threat_intel_job_mapping.json");){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                string = reader.lines().map(String::trim).collect(Collectors.joining());
            }
            return string;
        }
        catch (IOException e) {
            log.error("Failed to get the threat intel index mapping", (Throwable)e);
            throw new SecurityAnalyticsException("Failed to get threat intel index mapping", RestStatus.BAD_REQUEST, e);
        }
    }

    public void createJobIndexIfNotExists(StepListener<Void> stepListener) {
        if (this.clusterService.state().metadata().hasIndex(".opensearch-sap--job")) {
            stepListener.onResponse(null);
            return;
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(".opensearch-sap--job").mapping(this.getIndexMapping()).settings(SecurityAnalyticsPlugin.TIF_JOB_INDEX_SETTING);
        StashedThreadContext.run(this.client, () -> this.client.admin().indices().create(createIndexRequest, ActionListener.wrap(r -> {
            log.debug("[{}] index created", (Object)".opensearch-sap--job");
            stepListener.onResponse(null);
        }, e -> {
            if (e instanceof ResourceAlreadyExistsException) {
                log.info("Index [{}] already exists", (Object)".opensearch-sap--job");
                stepListener.onResponse(null);
                return;
            }
            log.error("Failed to create [{}] index", (Object)".opensearch-sap--job", e);
            stepListener.onFailure(e);
        })));
    }

    public void getTIFSourceConfig(String tifSourceConfigId, ActionListener<SATIFSourceConfig> actionListener) {
        GetRequest getRequest = new GetRequest(".opensearch-sap--job", tifSourceConfigId);
        this.client.get(getRequest, ActionListener.wrap(getResponse -> {
            if (!getResponse.isExists()) {
                actionListener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(String.format(Locale.getDefault(), "Threat intel source config [%s] not found.", tifSourceConfigId), RestStatus.NOT_FOUND, new Object[0]))));
                return;
            }
            SATIFSourceConfig saTifSourceConfig = null;
            if (!getResponse.isSourceEmpty()) {
                XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)getResponse.getSourceAsBytesRef(), (MediaType)XContentType.JSON);
                saTifSourceConfig = SATIFSourceConfig.docParse(xcp, getResponse.getId(), getResponse.getVersion());
            }
            if (saTifSourceConfig == null) {
                actionListener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(String.format(Locale.getDefault(), "No threat intel source config exists [%s]", tifSourceConfigId), RestStatus.BAD_REQUEST, new Object[0]))));
            } else {
                log.debug("Threat intel source config with id [{}] fetched", (Object)getResponse.getId());
                actionListener.onResponse(saTifSourceConfig);
            }
        }, e -> {
            log.error("Failed to fetch threat intel source config document", (Throwable)e);
            actionListener.onFailure(e);
        }));
    }

    public void searchTIFSourceConfigs(SearchSourceBuilder searchSourceBuilder, ActionListener<SearchResponse> actionListener) {
        SearchRequest searchRequest = SATIFSourceConfigService.getSearchRequest(searchSourceBuilder);
        if (!this.clusterService.state().metadata().hasIndex(".opensearch-sap--job")) {
            actionListener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException("Threat intel source config index does not exist", RestStatus.BAD_REQUEST, new Object[0]))));
            return;
        }
        this.client.search(searchRequest, ActionListener.wrap(searchResponse -> {
            if (searchResponse.isTimedOut()) {
                actionListener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException("Search threat intel source configs request timed out", RestStatus.REQUEST_TIMEOUT, new Object[0]))));
                return;
            }
            for (SearchHit hit : searchResponse.getHits()) {
                XContentParser xcp = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                SATIFSourceConfig satifSourceConfig = SATIFSourceConfig.docParse(xcp, hit.getId(), hit.getVersion());
                XContentBuilder xcb = satifSourceConfig.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS);
                hit.sourceRef(BytesReference.bytes((XContentBuilder)xcb));
            }
            log.debug("Fetched all threat intel source configs successfully.");
            actionListener.onResponse(searchResponse);
        }, e -> {
            log.error("Failed to fetch all threat intel source configs for search request [{}]", (Object)searchRequest, e);
            actionListener.onFailure(e);
        }));
    }

    private static SearchRequest getSearchRequest(SearchSourceBuilder searchSourceBuilder) {
        searchSourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(true));
        searchSourceBuilder.version(Boolean.valueOf(true));
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder);
        searchRequest.indices(new String[]{".opensearch-sap--job"});
        searchRequest.preference(Preference.PRIMARY_FIRST.type());
        BoolQueryBuilder boolQueryBuilder = searchRequest.source().query() == null ? new BoolQueryBuilder() : QueryBuilders.boolQuery().must(searchRequest.source().query());
        BoolQueryBuilder bqb = new BoolQueryBuilder();
        bqb.should().add(new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.existsQuery((String)"source_config")));
        boolQueryBuilder.filter((QueryBuilder)bqb);
        searchRequest.source().query((QueryBuilder)boolQueryBuilder);
        return searchRequest;
    }

    public void updateTIFSourceConfig(SATIFSourceConfig saTifSourceConfig, ActionListener<SATIFSourceConfig> actionListener) {
        try {
            IndexRequest indexRequest = (IndexRequest)((IndexRequest)new IndexRequest(".opensearch-sap--job").setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(saTifSourceConfig.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).id(saTifSourceConfig.getId()).timeout((TimeValue)this.clusterSettings.get(SecurityAnalyticsSettings.INDEX_TIMEOUT));
            this.client.index(indexRequest, ActionListener.wrap(response -> {
                log.debug("Threat intel source config with id [{}] update success.", (Object)response.getId());
                SATIFSourceConfig responseSaTifSourceConfig = SATIFSourceConfigService.createSATIFSourceConfig(saTifSourceConfig, response);
                actionListener.onResponse((Object)responseSaTifSourceConfig);
            }, e -> {
                log.error("Failed to index threat intel source config with id [{}]", (Object)saTifSourceConfig.getId());
                actionListener.onFailure(e);
            }));
        }
        catch (IOException e2) {
            log.error("Exception updating the threat intel source config in index", (Throwable)e2);
        }
    }

    public void deleteTIFSourceConfig(SATIFSourceConfig saTifSourceConfig, ActionListener<DeleteResponse> actionListener) {
        if (!this.clusterService.state().metadata().hasIndex(".opensearch-sap--job")) {
            actionListener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException("Threat intel source config index does not exist", RestStatus.BAD_REQUEST, new Object[0]))));
            return;
        }
        DeleteRequest request = (DeleteRequest)((DeleteRequest)new DeleteRequest(".opensearch-sap--job", saTifSourceConfig.getId()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).timeout((TimeValue)this.clusterSettings.get(SecurityAnalyticsSettings.INDEX_TIMEOUT));
        this.client.delete(request, ActionListener.wrap(deleteResponse -> {
            if (deleteResponse.status().equals((Object)RestStatus.OK)) {
                log.debug("Deleted threat intel source config [{}] successfully", (Object)saTifSourceConfig.getId());
                actionListener.onResponse(deleteResponse);
            } else if (deleteResponse.status().equals((Object)RestStatus.NOT_FOUND)) {
                actionListener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(String.format(Locale.getDefault(), "Threat intel source config with id [{%s}] not found", saTifSourceConfig.getId()), RestStatus.NOT_FOUND, new Object[0]))));
            } else {
                actionListener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(String.format(Locale.getDefault(), "Failed to delete threat intel source config [{%s}]", saTifSourceConfig.getId()), deleteResponse.status(), new Object[0]))));
            }
        }, e -> {
            log.error("Failed to delete threat intel source config with id [{}]", (Object)saTifSourceConfig.getId());
            actionListener.onFailure(e);
        }));
    }

    public void deleteAllIocIndices(Set<String> indicesToDelete, Boolean backgroundJob, ActionListener<AcknowledgedResponse> listener) {
        if (!indicesToDelete.isEmpty()) {
            DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(indicesToDelete.toArray(new String[0]));
            this.client.admin().indices().delete(deleteIndexRequest, ActionListener.wrap(deleteIndicesResponse -> {
                if (!deleteIndicesResponse.isAcknowledged()) {
                    log.error("Could not delete one or more IOC indices: [" + String.valueOf(indicesToDelete) + "]. Retrying one by one.");
                    this.deleteIocIndex(indicesToDelete, backgroundJob, listener);
                } else {
                    log.info("Successfully deleted indices: [" + String.valueOf(indicesToDelete) + "]");
                    if (!backgroundJob.booleanValue()) {
                        listener.onResponse(deleteIndicesResponse);
                    }
                }
            }, e -> {
                log.error("Delete for IOC Indices failed: [" + String.valueOf(indicesToDelete) + "]. Retrying one By one.");
                this.deleteIocIndex(indicesToDelete, backgroundJob, listener);
            }));
        }
    }

    private void deleteIocIndex(Set<String> indicesToDelete, Boolean backgroundJob, ActionListener<AcknowledgedResponse> listener) {
        for (String index : indicesToDelete) {
            DeleteIndexRequest singleDeleteRequest = new DeleteIndexRequest(indicesToDelete.toArray(new String[0]));
            this.client.admin().indices().delete(singleDeleteRequest, ActionListener.wrap(response -> {
                if (!response.isAcknowledged()) {
                    log.error("Could not delete one or more IOC indices: " + index);
                    if (!backgroundJob.booleanValue()) {
                        listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(String.format(Locale.getDefault(), "Could not delete one or more IOC indices: " + index, new Object[0]), RestStatus.BAD_REQUEST, new Object[0]))));
                    }
                } else {
                    log.debug("Successfully deleted one or more IOC indices:" + index);
                    if (!backgroundJob.booleanValue()) {
                        listener.onResponse(response);
                    }
                }
            }, e -> {
                log.debug("Exception: [" + e.getMessage() + "] while deleting the index " + index);
                if (!backgroundJob.booleanValue()) {
                    listener.onFailure(e);
                }
            }));
        }
    }

    public void getClusterState(ActionListener<ClusterStateResponse> actionListener, String ... indices) {
        ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(indices).metadata(true).local(true)).indicesOptions(IndicesOptions.strictExpand());
        this.client.admin().cluster().state(clusterStateRequest, ActionListener.wrap(clusterStateResponse -> {
            log.debug("Successfully retrieved cluster state");
            actionListener.onResponse(clusterStateResponse);
        }, e -> {
            log.error("Error fetching cluster state");
            actionListener.onFailure(e);
        }));
    }

    public void checkAndEnsureThreatIntelMonitorsDeleted(ActionListener<Boolean> listener) {
        SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap--job"}).source(new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(false)).version(Boolean.valueOf(false)).query((QueryBuilder)QueryBuilders.matchAllQuery()).fetchSource(FetchSourceContext.FETCH_SOURCE)).preference(Preference.PRIMARY_FIRST.type());
        this.client.search(searchRequest, ActionListener.wrap(saTifSourceConfigResponse -> {
            if (saTifSourceConfigResponse.getHits().getHits().length <= 1) {
                String alertingConfigIndex = ".opendistro-alerting-config";
                if (!this.clusterService.state().metadata().hasIndex(alertingConfigIndex)) {
                    log.debug("[{}] index does not exist, continuing deleting threat intel source config", (Object)alertingConfigIndex);
                    listener.onResponse((Object)true);
                } else {
                    SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(false)).version(Boolean.valueOf(false)).query((QueryBuilder)QueryBuilders.matchAllQuery()).fetchSource(FetchSourceContext.FETCH_SOURCE);
                    SearchRequest newSearchRequest = new SearchRequest();
                    newSearchRequest.source(searchSourceBuilder);
                    newSearchRequest.indices(new String[]{alertingConfigIndex});
                    newSearchRequest.preference(Preference.PRIMARY_FIRST.type());
                    BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().must(newSearchRequest.source().query());
                    BoolQueryBuilder bqb = new BoolQueryBuilder();
                    bqb.should().add(new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.matchQuery((String)"monitor.owner", (Object)"security_analytics")));
                    boolQueryBuilder.filter((QueryBuilder)bqb);
                    newSearchRequest.source().query((QueryBuilder)boolQueryBuilder);
                    this.client.execute((ActionType)SearchThreatIntelMonitorAction.INSTANCE, (ActionRequest)new SearchThreatIntelMonitorRequest(newSearchRequest), ActionListener.wrap(response -> {
                        if (response.getHits().getHits().length == 0) {
                            log.debug("All threat intel monitors are deleted, continuing deleting threat intel source config");
                            listener.onResponse((Object)true);
                        } else {
                            log.error("All threat intel monitors need to be deleted before deleting threat intel source config");
                            listener.onResponse((Object)false);
                        }
                    }, e -> {
                        log.error("Failed to search for threat intel monitors");
                        listener.onFailure(e);
                    }));
                }
            } else {
                log.debug("Multiple threat intel source configs exist, threat intel monitors do not need to be deleted");
                listener.onResponse((Object)true);
            }
        }, e -> {
            log.error("Failed to search for threat intel source configs");
            listener.onFailure(e);
        }));
    }

    public void getIocTypeToIndices(ActionListener<Map<String, List<String>>> listener) {
        SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap--job"});
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)SATIFSourceConfigService.getEnabledForScanFieldName(), (boolean)true));
        String stateFieldName = SATIFSourceConfigService.getStateFieldName();
        BoolQueryBuilder stateQueryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)stateFieldName, (Object)TIFJobState.AVAILABLE.toString()));
        stateQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)stateFieldName, (Object)TIFJobState.REFRESHING.toString()));
        queryBuilder.must((QueryBuilder)stateQueryBuilder);
        searchRequest.source().query((QueryBuilder)queryBuilder);
        this.client.search(searchRequest, ActionListener.wrap(searchResponse -> {
            HashMap<String, List> cumulativeIocTypeToIndices = new HashMap<String, List>();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                XContentParser xcp = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                SATIFSourceConfig config = SATIFSourceConfig.docParse(xcp, hit.getId(), hit.getVersion());
                if (!(config.getIocStoreConfig() instanceof DefaultIocStoreConfig)) continue;
                DefaultIocStoreConfig iocStoreConfig = (DefaultIocStoreConfig)config.getIocStoreConfig();
                for (DefaultIocStoreConfig.IocToIndexDetails iocToindexDetails : iocStoreConfig.getIocToIndexDetails()) {
                    String activeIndex = iocToindexDetails.getActiveIndex();
                    IOCType iocType = iocToindexDetails.getIocType();
                    List strings = cumulativeIocTypeToIndices.computeIfAbsent(iocType.toString(), k -> new ArrayList());
                    strings.add(activeIndex);
                }
            }
            listener.onResponse(cumulativeIocTypeToIndices);
        }, e -> {
            log.error("Failed to fetch ioc indices", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    public static String getStateFieldName() {
        return String.format("%s.%s", "source_config", "state");
    }

    public static String getEnabledForScanFieldName() {
        return String.format("%s.%s", "source_config", "enabled_for_scan");
    }

    public static Set<String> getConcreteIndices(ClusterStateResponse clusterStateResponse) {
        HashSet<String> concreteIndices = new HashSet<String>();
        Collection values = clusterStateResponse.getState().metadata().indices().values();
        for (IndexMetadata metadata : values) {
            concreteIndices.add(metadata.getIndex().getName());
        }
        return concreteIndices;
    }
}

